/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.exesupport;

import com.hp.openvms.netbeans.exesupport.ExeDataObject;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

class SurrogateNode
extends AbstractNode {
    private Node realNode;
    public static final String PROP_OUTPUT_SWITCH = "cqpExeOutputSwitch";
    private DataObject dobj;

    public SurrogateNode(Children ch, Node realNode) {
        super(ch);
        this.realNode = realNode;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Remote Properties");
        set.setDisplayName("Remote Properties");
        set.setShortDescription("Remote Properties of the file");
        this.dobj = (DataObject)this.realNode.getCookie(DataObject.class);
        set.put((Node.Property)this.createRemoteFilePathProperty());
        set.put((Node.Property)this.createUseXtermPropertyCompile());
        set.put((Node.Property)this.createForeignCommandProperty());
        set.put((Node.Property)this.createPromptForRuntimeArgumentsProperty());
        set.put((Node.Property)this.createRemoteArgumentsProperty());
        try {
            if (this.dobj.getPrimaryFile().getFileSystem() instanceof FTPFileSystem) {
                set.put((Node.Property)this.createFileResidenceProperty());
            }
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        Boolean outputSwitch = (Boolean)this.dobj.getPrimaryFile().getAttribute("Run as Foreign Command");
        if (outputSwitch != null && outputSwitch.equals(new Boolean("false"))) {
            set.put((Node.Property)new PropertySupport.ReadOnly("Arguments", String.class, "Arguments", "Arguments"){

                public Object getValue() {
                    return (String)SurrogateNode.this.dobj.getPrimaryFile().getAttribute("Arguments");
                }
            });
        }
        sheet.put(set);
        return sheet;
    }

    public void setOutputSwitch(Boolean outputSwitch) throws IOException {
        this.dobj.getPrimaryFile().setAttribute(PROP_OUTPUT_SWITCH, (Object)outputSwitch);
    }

    public Boolean getOutputSwitch() {
        Boolean outputSwitch = (Boolean)this.dobj.getPrimaryFile().getAttribute(PROP_OUTPUT_SWITCH);
        if (outputSwitch == null) {
            return new Boolean("False");
        }
        return new Boolean("True");
    }

    private String getFlaggedNameOutputSwitch(String dispName, String name) {
        return dispName;
    }

    private PropertySupport createUseXtermPropertyCompile() {
        class UseXtermPropertySupport
        extends PropertySupport.ReadWrite {
            public UseXtermPropertySupport() {
                super("Use XTerm for Execution", Boolean.class, "Use XTerm for Execution", "Use the X terminal window to display the output");
            }

            public Object getValue() {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = dobj.getPrimaryFile().getAttribute("useXtermExecution");
                try {
                    if (obj != null) {
                        return obj;
                    }
                    AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)dobj.getPrimaryFile().getFileSystem();
                    return new Boolean(nfs.getUseXtermCompile());
                }
                catch (FileStateInvalidException e) {
                    return new Boolean(DistributedSettings.getDefault().getUseXtermCompile());
                }
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                    dobj.getPrimaryFile().setAttribute("useXtermExecution", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new UseXtermPropertySupport();
    }

    private PropertySupport createForeignCommandProperty() {
        class ForeignCommandPropertySupport
        extends PropertySupport.ReadWrite {
            public ForeignCommandPropertySupport() {
                super("Run as Foreign Command", Boolean.class, "Run as Foreign Command", "Run as Foreign Command");
            }

            public Object getValue() {
                ExeDataObject dobj = (ExeDataObject)SurrogateNode.this.realNode.getCookie(ExeDataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = dobj.getPrimaryFile().getAttribute("Run as Foreign Command");
                if (obj != null) {
                    return obj;
                }
                try {
                    AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)dobj.getPrimaryFile().getFileSystem();
                    return new Boolean("False");
                }
                catch (FileStateInvalidException e) {
                    return new Boolean("True");
                }
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    ExeDataObject dobj = (ExeDataObject)SurrogateNode.this.realNode.getCookie(ExeDataObject.class);
                    dobj.getPrimaryFile().setAttribute("Run as Foreign Command", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new ForeignCommandPropertySupport();
    }

    private PropertySupport createPromptForRuntimeArgumentsProperty() {
        class PromptForForeignCommandPropertySupport
        extends PropertySupport.ReadWrite {
            public PromptForForeignCommandPropertySupport() {
                super("Prompt for Runtime Arguments", Boolean.class, "Prompt for Runtime Arguments", "Prompt for Runtime Arguments");
            }

            public Object getValue() {
                ExeDataObject dobj = (ExeDataObject)SurrogateNode.this.realNode.getCookie(ExeDataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = dobj.getPrimaryFile().getAttribute("Prompt for Runtime Arguments");
                if (obj != null) {
                    return obj;
                }
                try {
                    AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)dobj.getPrimaryFile().getFileSystem();
                    return new Boolean("False");
                }
                catch (FileStateInvalidException e) {
                    return new Boolean("True");
                }
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    ExeDataObject dobj = (ExeDataObject)SurrogateNode.this.realNode.getCookie(ExeDataObject.class);
                    dobj.getPrimaryFile().setAttribute("Prompt for Runtime Arguments", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new PromptForForeignCommandPropertySupport();
    }

    private PropertySupport createRemoteFilePathProperty() {
        class RemoteFilePathPropertySupport
        extends PropertySupport.ReadOnly {
            public RemoteFilePathPropertySupport() {
                super("Remote File Path", String.class, "Remote File Path", "Remote File Path");
            }

            public Object getValue() {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = dobj.getPrimaryFile().getAttribute("REMOTE_FILEPATH");
                if (obj != null) {
                    return obj;
                }
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return vmsPath;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                    dobj.getPrimaryFile().setAttribute("REMOTE_FILEPATH", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                String vmsPath = fobj.getNameExt();
                try {
                    File file = FileUtil.toFile((FileObject)fobj);
                    if (Utilities.isWindows()) {
                        vmsPath = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                        vmsPath = FileUtilityLang.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                    }
                    this.setValue(vmsPath);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return new RemoteFilePathPropertySupport();
    }

    private PropertySupport createFileResidenceProperty() {
        class FileResidenceProperty
        extends PropertySupport.ReadOnly {
            public FileResidenceProperty() {
                super("File Residence", String.class, "File Residence", "Determine if the file should reside in local disk, server or both");
            }

            public Object getValue() {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = fobj.getAttribute("file_residence_mode");
                if (obj != null) {
                    Integer itr = (Integer)obj;
                    String ret = "Make Client and Server";
                    switch (itr) {
                        case 1: {
                            ret = "Client Only";
                            break;
                        }
                        case 0: {
                            ret = "Server Only";
                            break;
                        }
                        case 2: {
                            ret = "Client and Server";
                        }
                    }
                    return ret;
                }
                return "Client and Server";
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                    dobj.getPrimaryFile().setAttribute("file_residence_mode", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new FileResidenceProperty();
    }

    private PropertySupport createRemoteArgumentsProperty() {
        class RemoteArgumentsPropertySupport
        extends PropertySupport.ReadWrite {
            public RemoteArgumentsPropertySupport() {
                super("Arguments", String.class, "Arguments", "Arguments");
            }

            public Object getValue() {
                DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                FileObject fobj = dobj.getPrimaryFile();
                Object obj = dobj.getPrimaryFile().getAttribute("REMOTE_ARGUMENT");
                if (obj != null) {
                    return obj;
                }
                return "";
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    DataObject dobj = (DataObject)SurrogateNode.this.realNode.getCookie(DataObject.class);
                    dobj.getPrimaryFile().setAttribute("REMOTE_ARGUMENT", val);
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return false;
            }
        }
        return new RemoteArgumentsPropertySupport();
    }
}

