/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.dclsupport.dcl;

import com.hp.openvms.netbeans.dclsupport.dcl.RemoteDCLExecutor;
import com.hp.openvms.netbeans.dclsupport.dcl.datasys.DCLBuildSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.common.cookies.RemoteCookie;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class RemoteDCLRunTargetsAction
extends CookieAction
implements Presenter.Popup {
    public String getName() {
        return NbBundle.getMessage(RemoteDCLRunTargetsAction.class, (String)"LBL_run_targets_action");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu((SystemAction)this, new ActSubMenuModel((NodeAction)this), true);
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{DCLBuildSupport.class};
    }

    protected void performAction(Node[] activatedNodes) {
    }

    protected boolean enable(Node[] node) {
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(DataObject.class);
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            if (dobj.getCookie(RemoteCookie.class) != null) continue;
            return false;
        }
        return true;
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = new ArrayList();
        private DataObject dobj = null;
        private final NodeAction action;

        ActSubMenuModel(NodeAction action) {
            this.action = action;
        }

        public int getCount() {
            return this.targets.size();
        }

        public String getLabel(int index) {
            return (String)this.targets.get(index);
        }

        public HelpCtx getHelpCtx(int index) {
            return HelpCtx.DEFAULT_HELP;
        }

        private static void refreshFS() {
            Enumeration fss = FileSystemCapability.COMPILE.fileSystems();
            FileSystem defaultFS = Repository.getDefault().getDefaultFileSystem();
            while (fss.hasMoreElements()) {
                FileSystem fs = (FileSystem)fss.nextElement();
                if (fs.isReadOnly() || fs == defaultFS || !(fs instanceof AbstractNetworkFileSystem)) continue;
                fs.refresh(false);
            }
        }

        public void performActionAt(final int index) {
            if (DistributedSettings.getDefault().getSaveAll()) {
                LifecycleManager.getDefault().saveAll();
            }
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    ActSubMenuModel.refreshFS();
                    String target = (String)ActSubMenuModel.this.targets.get(index);
                    RemoteDCLExecutor ret = new RemoteDCLExecutor(ActSubMenuModel.this.dobj);
                    try {
                        ret.execute(ActSubMenuModel.this.dobj, target);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    ActSubMenuModel.refreshFS();
                }
            });
        }

        void addNotify() {
            Node[] nodes = this.action.getActivatedNodes();
            if (nodes.length != 1) {
                return;
            }
            this.dobj = (DataObject)nodes[0].getCookie(DataObject.class);
            DCLBuildSupport dclSupport = (DCLBuildSupport)nodes[0].getCookie(DCLBuildSupport.class);
            String[] tars = dclSupport.getTargets();
            if (tars.length == 1) {
                this.targets.add("");
            }
            for (int i = 0; i < tars.length; ++i) {
                this.targets.add(tars[i]);
            }
        }

        public synchronized void addChangeListener(ChangeListener l) {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(SystemAction action, ActSubMenuModel model, boolean popup) {
            super(action, (Actions.SubMenuModel)model, popup);
            this.model = model;
            this.addNotify();
        }

        public void addNotify() {
            this.model.addNotify();
            super.addNotify();
        }
    }
}

