/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.basicsupport.editor.basic;

import com.hp.openvms.netbeans.basicsupport.basic.BasicCompilerType;
import com.hp.openvms.netbeans.basicsupport.editor.basic.BasicFormatSupport;
import com.hp.openvms.netbeans.basicsupport.editor.basic.BasicTokenContext;
import com.hp.openvms.netbeans.basicsupport.editor.basic.IndentInfo;
import com.hp.openvms.netbeans.basicsupport.editor.basic.StringLexerInput;
import com.hp.openvms.netbeans.basicsupport.editor.lang.BasicLanguage;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.openide.compiler.CompilerType;

public class BasicFormatter
extends ExtFormatter {
    public int openParenOn = 0;

    public BasicFormatter(Class kitClass) {
        super(kitClass);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof PlainSyntax;
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        int[] ret = null;
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        int dotPos = target.getCaret().getDot();
        if (doc != null) {
            if ("e".equals(typedText) | "E".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if (fnw >= 0 && fnw + 12 <= doc.getLength() && ("else".equals(doc.getText(fnw, dotPos - fnw)) || "case".equals(doc.getText(fnw, dotPos - fnw)) || "use".equals(doc.getText(fnw, dotPos - fnw)) || "end def".equals(doc.getText(fnw, 7)) || "end function".equals(doc.getText(fnw, 12)) || "end group".equals(doc.getText(fnw, 9)) || "end handler".equals(doc.getText(fnw, 11)) || "end if".equals(doc.getText(fnw, 6)) || "end program".equals(doc.getText(fnw, 11)) || "end record".equals(doc.getText(fnw, 10)) || "end select".equals(doc.getText(fnw, 10)) || "end sub".equals(doc.getText(fnw, 7)) || "end when".equals(doc.getText(fnw, 8)))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {}
            } else if ("f".equals(typedText) | "F".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if (fnw >= 0 && fnw + 6 <= doc.getLength() && "end if".equals(doc.getText(fnw, 6))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {}
            } else if ("m".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if (fnw >= 0 && fnw + 11 <= doc.getLength() && "end program".equals(doc.getText(fnw, 11))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {}
            } else if ("n".equals(typedText) | "N".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if (fnw >= 0 && fnw + 12 <= doc.getLength() && ("then".equals(doc.getText(fnw, 4)) || "endunion".equals(doc.getText(fnw, 8)) || "end union".equals(doc.getText(fnw, 9)) || "endfunction".equals(doc.getText(fnw, 11)) || "end function".equals(doc.getText(fnw, 12)) || "end when".equals(doc.getText(fnw, 8)))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {}
            } else if ("t".equals(typedText) | "T".equals(typedText)) {
                try {
                    int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                    if (fnw >= 0 && fnw + 10 <= doc.getLength() && ("end select".equals(doc.getText(fnw, 10)) || "next".equals(doc.getText(fnw, 4)))) {
                        ret = new int[]{fnw, dotPos};
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
        this.addFormatLayer((FormatLayer)new BasicLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter fw) {
        return new BasicFormatSupport(fw);
    }

    public class BasicLayer
    extends AbstractFormatLayer {
        public int initialIndentation;

        public BasicLayer() {
            super("basic-layer");
            this.initialIndentation = 0;
            BasicFormatter.this.openParenOn = 0;
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new BasicFormatSupport(fw);
        }

        public TokenContextPath getTokenContextPath() {
            return BasicTokenContext.contextPath;
        }

        public TokenID getWhitespaceTokenID() {
            return BasicTokenContext.WHITESPACE;
        }

        public TokenContextPath getWhitespaceTokenContextPath() {
            return this.getTokenContextPath();
        }

        public void insertWhiteSpace(FormatWriter fw, FormatTokenPosition pos, int indent) {
            if (pos.getToken() != null) {
                for (int i = 0; i < indent; ++i) {
                    fw.insertString(pos.getToken(), 0, " ");
                }
            } else {
                for (int i = 0; i < indent; ++i) {
                    fw.insertToken(null, null, null, " ");
                }
            }
        }

        public boolean isWhiteSpace(FormatTokenPosition pos) {
            BasicLanguage language = BasicLanguage.get();
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            return tok.getId().getIntId() == 1;
        }

        public TokenItem findLineStartToken(TokenItem token, BasicFormatSupport fs) {
            if (token != null) {
                FormatTokenPosition pos = fs.getPosition(token, 0);
                pos = fs.findLineStart(pos);
                token = pos.getToken();
                while (token.getTokenID() == BasicTokenContext.WHITESPACE) {
                    token = token.getNext();
                }
            }
            return token;
        }

        public void removeFirstTabFromLine(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition tmpPos = pos;
            FormatTokenPosition savPos = pos;
            if (tmpPos != null) {
                while (tmpPos != null && tmpPos.getToken() != null && tmpPos.getToken().getImage() != null && tmpPos.getToken().getImage().charAt(0) != '\n') {
                    savPos = tmpPos;
                    if ((tmpPos = fs.getPreviousPosition(tmpPos)) != null) continue;
                }
                if ((tmpPos = savPos) != null && tmpPos.getToken() != null && tmpPos.getToken().getImage() != null && tmpPos.getToken().getImage().charAt(0) != '\n') {
                    savPos = tmpPos;
                    String tabString = savPos.getToken().getImage();
                    while (tabString.indexOf(9) != -1) {
                        int tabPos = tabString.indexOf(9);
                        tabString = tabString.substring(0, tabPos) + tabString.substring(tabString.indexOf(9) + 1, tabString.length());
                        fw.remove(tmpPos.getToken(), tabPos, 1);
                        for (int i = 0; i < fs.getSpacesPerTab(); ++i) {
                            tabString = tabString.substring(0, tabPos) + " " + tabString.substring(tabPos, tabString.length());
                            fw.insertString(savPos.getToken(), tabPos, " ");
                        }
                    }
                }
            }
        }

        public void removeWhiteSpace(FormatWriter fw, FormatTokenPosition pos, int indent) {
            BasicLanguage language = BasicLanguage.get();
            StringLexerInput input = new StringLexerInput(pos.getToken().getImage());
            Lexer lex = language.createLexer();
            lex.restart((LexerInput)input, null);
            Token tok = lex.nextToken();
            if (tok != null && tok.getId().getIntId() == 1) {
                for (int i = 0; i < indent; ++i) {
                    fw.remove(pos.getToken(), 0, 1);
                }
            }
        }

        public void AdjustCursor(FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, int indent) {
            if (indent != idf.getIndent() && indent > idf.getIndent()) {
                this.insertWhiteSpace(fw, pos, indent - idf.getIndent());
            }
        }

        public void IndentLine(BasicFormatSupport fs, FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, int indent) {
            FormatTokenPosition firstNWS = fs.findLineFirstNonWhitespace(pos);
            int tempIndent = idf.getIndent();
            if (firstNWS != null) {
                boolean remove = true;
                if (indent != tempIndent) {
                    if (indent > tempIndent) {
                        int temp = indent - tempIndent;
                        this.insertWhiteSpace(fw, firstNWS, temp);
                    } else {
                        int temp = tempIndent - indent;
                        if (remove) {
                            this.removeWhiteSpace(fw, firstNWS, temp);
                        }
                    }
                }
            }
        }

        public FormatTokenPosition FindCorrespondingIFStatement(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isENDIFStatement(temp)) {
                    --i;
                } else if (fs.isIFStatement(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public boolean IsIfStatementClosed(FormatTokenPosition pos, BasicFormatSupport fs) {
            boolean status;
            block1: {
                FormatTokenPosition temp;
                FormatTokenPosition current = fs.getInitialPosition(pos);
                status = false;
                boolean i = false;
                do {
                    if ((temp = fs.getNextNonEmptyLine(pos)) == null) break block1;
                } while (!fs.isBegin(temp));
                return this.IsBeginBalanced(temp, fs);
            }
            status = false;
            return status;
        }

        public boolean IsBeginBalanced(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition nxt = fs.getNextNonEmptyLine(pos);
            int i = 0;
            while (nxt != null) {
                if (nxt == null) {
                    return false;
                }
                if (!fs.isBeginInSameLineAsEnd(nxt)) {
                    if (fs.isBegin(nxt)) {
                        --i;
                    } else if (fs.isEnd(nxt) && ++i == 1) {
                        return true;
                    }
                }
                nxt = fs.getNextNonEmptyLine(nxt);
            }
            return false;
        }

        public FormatTokenPosition FindCorrespondingRepeat(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (!fs.isRepeatInSameLineAsUntil(temp)) {
                    if (fs.isUntil(temp)) {
                        --i;
                    } else if (fs.isRepeat(temp) && ++i == 1) {
                        FormatTokenPosition ip;
                        pos = ip = fs.getInitialPosition(temp);
                        return pos;
                    }
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingRecord(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndRecord(temp)) {
                    --i;
                } else if (fs.isRecord(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingGroup(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndGroup(temp)) {
                    --i;
                } else if (fs.isGroup(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingDef(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndDef(temp) || fs.isFNEnd(temp)) {
                    --i;
                } else if (fs.isDef(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingHandler(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndHandler(temp)) {
                    --i;
                } else if (fs.isHandler(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingVariant(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndVariant(temp)) {
                    --i;
                } else if (fs.isVariant(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingSelect(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndSelect(temp)) {
                    --i;
                } else if (fs.isSelect(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingSub(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndSub(temp)) {
                    --i;
                } else if (fs.isSub(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingProgram(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndProgram(temp)) {
                    --i;
                } else if (fs.isProgram(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingFunction(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndFunction(temp)) {
                    --i;
                } else if (fs.isFunction(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingWhen(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndWhen(temp)) {
                    --i;
                } else if (fs.isWhen(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingNext(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isNext(temp)) {
                    --i;
                } else if ((fs.isForOnly(temp) || fs.isUntil(temp) || fs.isWhile(temp)) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingCase(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isEndSelect(temp)) {
                    temp = this.FindCorrespondingSelect(temp, fs);
                } else if (fs.isEndVariant(temp)) {
                    temp = this.FindCorrespondingVariant(temp, fs);
                } else if (fs.isCase(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingPercentIF(FormatTokenPosition pos, BasicFormatSupport fs) {
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (fs.isPercentEndIFStatement(temp)) {
                    --i;
                } else if (fs.isPercentIFStatement(temp) && ++i == 1) {
                    FormatTokenPosition ip;
                    pos = ip = fs.getInitialPosition(temp);
                    return pos;
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public FormatTokenPosition FindCorrespondingBegin(FormatTokenPosition pos, BasicFormatSupport fs) {
            if (fs.isBeginInSameLineAsEnd(pos)) {
                return fs.getInitialPosition(pos);
            }
            FormatTokenPosition current = fs.getInitialPosition(pos);
            int i = 0;
            while (true) {
                FormatTokenPosition temp;
                if ((temp = fs.getPreviousNonEmptyLine(pos)) == null) break;
                if (!fs.isBeginInSameLineAsEnd(temp)) {
                    if (fs.isCase(temp)) {
                        int a = fs.getCaserec();
                        if (a == 0) {
                            if (++i == 1) {
                                FormatTokenPosition ip;
                                pos = ip = fs.getInitialPosition(temp);
                                return pos;
                            }
                        } else {
                            a = fs.getCaserec();
                            fs.setCaserec(a - 1);
                        }
                    } else if (fs.isRecord(temp)) {
                        if (++i == 1) {
                            FormatTokenPosition ip;
                            pos = ip = fs.getInitialPosition(temp);
                            return pos;
                        }
                    } else if (fs.isEnd(temp)) {
                        --i;
                    } else if (fs.isBegin(temp) && ++i == 1) {
                        FormatTokenPosition ip;
                        pos = ip = fs.getInitialPosition(temp);
                        return pos;
                    }
                }
                pos = temp;
            }
            pos = current;
            return pos;
        }

        public void formatOpenLine(BasicFormatSupport fs, FormatWriter fw, FormatTokenPosition pos, IndentInfo idf, FormatTokenPosition ip) {
            FormatTokenPosition tmpPos = ip;
            int mOpenPos = 0;
            if (tmpPos != null) {
                mOpenPos = fs.getLineOpenPos(tmpPos);
            }
            if (mOpenPos <= 1) {
                this.IndentLine(fs, fw, pos, idf, fs.getIndent(tmpPos) + fs.getShiftWidth());
            } else {
                this.IndentLine(fs, fw, pos, idf, mOpenPos);
            }
        }

        public void formatCommentLine(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs) {
            if (pos != null) {
                int commentPos = fs.getCommentPosition();
                String tmpCommentChar = fs.getCommentChar(pos);
                if (tmpCommentChar == null) {
                    return;
                }
                int actualPos = pos.getToken().getImage().indexOf(tmpCommentChar) + 1;
                if (commentPos != actualPos && commentPos > actualPos) {
                    FormatTokenPosition tmpPos = fs.getPosition(pos.getToken(), actualPos - 1);
                    this.insertWhiteSpace(fw, tmpPos, commentPos - actualPos);
                }
            }
        }

        public void formatBegin(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs, IndentInfo idf) {
        }

        public void formatFunction(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
            if (prev != null) {
                FormatTokenPosition ip = fs.getInitialPosition(prev);
                if (fs.isFunction(ip) || fs.isProcedure(ip)) {
                    if (fs.isEndingWithSemicolon(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                    } else {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    }
                } else if (fs.isProgram(ip)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                } else {
                    int idt = fs.getIndent(ip);
                    int actualIdt = idt - fs.getShiftWidth();
                    if (actualIdt <= 0) {
                        this.IndentLine(fs, fw, pos, idf, 0);
                    } else {
                        this.IndentLine(fs, fw, pos, idf, actualIdt);
                    }
                }
            }
        }

        public void formatRepeat(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
            if (prev != null) {
                FormatTokenPosition ip = fs.getInitialPosition(prev);
                if (fs.isRepeat(ip)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                } else if (fs.isCase(ip) || fs.isWhile(ip) || fs.isBegin(ip) || fs.isRecord(ip) || fs.isELSEOnlyStatement(ip) || fs.isForOnly(ip) || fs.isIfOnlyStatement(ip) || fs.isRepeat(ip) || fs.isWhile(ip)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                } else {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                }
            }
        }

        public void formatCase(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
            if (prev != null) {
                FormatTokenPosition ip = fs.getInitialPosition(prev);
                this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
            }
        }

        public void formatEnd(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition corrBegin = this.FindCorrespondingBegin(pos, fs);
            this.IndentLine(fs, fw, pos, idf, fs.getIndent(corrBegin));
        }

        public void formatClosedParen(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs, IndentInfo idf, int tmpIndent) {
            this.IndentLine(fs, fw, pos, idf, tmpIndent);
        }

        public void formatUntil(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs, IndentInfo idf) {
            FormatTokenPosition CorrRep = this.FindCorrespondingRepeat(pos, fs);
            this.IndentLine(fs, fw, pos, idf, fs.getIndent(CorrRep));
        }

        public void formatGeneral(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs, IndentInfo idf) {
            if (fs.isStatementLabel(pos)) {
                this.IndentLine(fs, fw, pos, idf, 0);
            } else if ((fs.isELSEStatement(pos) || fs.isELSEOnlyStatement(pos)) && !fs.isIFStatement(pos)) {
                if (!fs.isIfInSameLineAsElse(pos)) {
                    FormatTokenPosition MostRecentIf = this.FindCorrespondingIFStatement(pos, fs);
                    this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentIf, "if"));
                } else {
                    FormatTokenPosition preIf = fs.getPreviousNonEmptyLine(pos);
                    if (fs.isForOnly(preIf) || fs.isWhile(preIf) || fs.isIfOnlyStatement(preIf) || fs.isELSEOnlyStatement(preIf)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getStatementPos(preIf)) + fs.getShiftWidth());
                    } else {
                        FormatTokenPosition fbp = fs.getPreviousUnbalancedLine(pos);
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(fbp)));
                    }
                }
            } else if (fs.isThenStatement(pos) || fs.isENDIFStatement(pos)) {
                FormatTokenPosition MostRecentIf = this.FindCorrespondingIFStatement(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentIf, "if"));
            } else if (fs.isCase(pos)) {
                FormatTokenPosition nw = fs.getPreviousNonEmptyLine(pos);
                FormatTokenPosition nn = fs.getInitialPosition(nw);
                if (fs.isVariant(nn) || fs.isSelect(nn)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getIndent(nn) + fs.getShiftWidth());
                } else {
                    FormatTokenPosition MostRecentCase = this.FindCorrespondingCase(pos, fs);
                    this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentCase, "case"));
                }
            } else if (fs.isEnd(pos)) {
                this.formatEnd(fw, pos, fs, idf);
            } else if (fs.isEndRecord(pos)) {
                FormatTokenPosition MostRecentRecord = this.FindCorrespondingRecord(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentRecord, "record"));
            } else if (fs.isEndVariant(pos)) {
                FormatTokenPosition MostRecentVariant = this.FindCorrespondingVariant(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentVariant, "variant"));
            } else if (fs.isEndDef(pos) || fs.isFNEnd(pos)) {
                FormatTokenPosition MostRecentDef = this.FindCorrespondingDef(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentDef, "def"));
            } else if (fs.isEndGroup(pos)) {
                FormatTokenPosition MostRecentGroup = this.FindCorrespondingGroup(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentGroup, "group"));
            } else if (fs.isEndHandler(pos)) {
                FormatTokenPosition MostRecentHandler = this.FindCorrespondingHandler(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentHandler, "handler"));
            } else if (fs.isEndSelect(pos)) {
                FormatTokenPosition MostRecentSelect = this.FindCorrespondingSelect(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentSelect, "select"));
            } else if (fs.isEndSub(pos)) {
                FormatTokenPosition MostRecentSub = this.FindCorrespondingSub(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentSub, "sub"));
            } else if (fs.isEndProgram(pos)) {
                FormatTokenPosition MostRecentProgram = this.FindCorrespondingProgram(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentProgram, "program"));
            } else if (fs.isEndFunction(pos)) {
                FormatTokenPosition MostRecentFunction = this.FindCorrespondingFunction(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentFunction, "function"));
            } else if (fs.isNext(pos)) {
                FormatTokenPosition MostRecentNext = this.FindCorrespondingNext(pos, fs);
                if (fs.isForOnly(MostRecentNext)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentNext, "for"));
                } else if (fs.isUntil(MostRecentNext)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentNext, "until"));
                } else if (fs.isWhile(MostRecentNext)) {
                    this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentNext, "while"));
                }
            } else if (fs.isEndWhen(pos) || fs.isUse(pos)) {
                FormatTokenPosition MostRecentWhen = this.FindCorrespondingWhen(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentWhen, "when"));
            } else if (fs.isPercentEndIFStatement(pos) || fs.isPercentThenStatement(pos) || fs.isPercentElseStatement(pos)) {
                FormatTokenPosition MostRecentPercentEndIF = this.FindCorrespondingPercentIF(pos, fs);
                this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(MostRecentPercentEndIF, "%if"));
            } else {
                FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
                if (prev != null) {
                    FormatTokenPosition ip = fs.getInitialPosition(prev);
                    if (fs.isIfOnlyStatement(ip)) {
                        if (fs.isContinueBooleanExp(ip) || fs.isContinueBooleanExp(pos)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else if (fs.isContinuedStatement(fs.getPreviousNonEmptyLine(ip))) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(fs.getStartingContinuePos())));
                        } else if (fs.isContendExp(ip, "if")) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        }
                    } else if (fs.isPercentIFStatement(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    } else if (fs.isELSEOnlyStatement(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                    } else if (fs.isThenStatement(ip)) {
                        FormatTokenPosition MostRecentIf = this.FindCorrespondingIFStatement(ip, fs);
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(MostRecentIf) + fs.getShiftWidth());
                    } else if (fs.isIfThenOnlyStatement(ip) || fs.isIfInSameLineAsElse(ip)) {
                        if (fs.isContendExp(ip, "if")) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "if") + fs.getShiftWidth());
                        }
                    } else if (fs.isPercentIFStatement(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "%if") + fs.getShiftWidth());
                    } else if (fs.isContinuedStatement(ip)) {
                        FormatTokenPosition tmpPos = fs.getPreviousNonEmptyLine(ip);
                        if (fs.isContinuedStatement(tmpPos = fs.getInitialPosition(tmpPos))) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else {
                            fs.setStartingContinuePos(ip);
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                        }
                    } else if (fs.isRecord(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "record") + fs.getShiftWidth());
                    } else if (fs.isVariant(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "variant") + fs.getShiftWidth());
                    } else if (fs.isGroup(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "group") + fs.getShiftWidth());
                    } else if (fs.isHandler(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "handler") + fs.getShiftWidth());
                    } else if (fs.isCase(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "case") + fs.getShiftWidth());
                    } else if (fs.isDef(ip)) {
                        if (fs.isContendExp(ip)) {
                            this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "def"));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "def") + fs.getShiftWidth());
                        }
                    } else if (fs.isSub(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "sub") + fs.getShiftWidth());
                    } else if (fs.isProgram(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "program") + fs.getShiftWidth());
                    } else if (fs.isFunction(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getStatementPos(ip)) + fs.getShiftWidth());
                    } else if (fs.isUse(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "use") + fs.getShiftWidth());
                    } else if (fs.isWhen(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "when") + fs.getShiftWidth());
                    } else if (fs.isForOnly(ip)) {
                        if (fs.isContendExp(ip, "for")) {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(ip));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "for") + fs.getShiftWidth());
                        }
                    } else if (fs.isWhile(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "while") + fs.getShiftWidth());
                    } else if (fs.isUntil(ip)) {
                        this.IndentLine(fs, fw, pos, idf, fs.getVisualPos(ip, "until") + fs.getShiftWidth());
                    } else {
                        FormatTokenPosition ppp = fs.getPreviousNonEmptyLine(ip);
                        if (fs.isContinuedStatement(ppp)) {
                            ppp = fs.getStartingContinuePos();
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(ppp)));
                        } else {
                            this.IndentLine(fs, fw, pos, idf, fs.getIndent(fs.getInitialPosition(ip)));
                        }
                    }
                } else {
                    this.IndentLine(fs, fw, pos, idf, fs.getFormattedIndentPosition());
                }
            }
        }

        public void formatLine(FormatWriter fw, FormatTokenPosition pos, BasicFormatSupport fs) {
            this.removeFirstTabFromLine(fw, pos, fs);
            if (fs.findLineFirstNonWhitespace(pos) != null) {
                IndentInfo idf = new IndentInfo();
                fs.getIndentationInfo(pos, idf);
                this.formatGeneral(fw, pos, fs, idf);
            }
        }

        public void format(FormatWriter fw) {
            block19: {
                try {
                    Document doc = fw.getDocument();
                    String s = Utilities.getLastActiveComponent().getSelectedText();
                    BasicFormatSupport fs = (BasicFormatSupport)this.createFormatSupport(fw);
                    FormatTokenPosition pos = fs.getFormatStartPosition();
                    boolean t = false;
                    BasicFormatter.this.openParenOn = 0;
                    fs.setIsComment(false);
                    fs.setStartingContinuePos(null);
                    if (fs.isIndentOnly()) {
                        IndentInfo idf = new IndentInfo();
                        fs.getIndentationInfo(pos, idf);
                        if (fs.findLineFirstNonWhitespace(pos) != null) {
                            this.formatGeneral(fw, pos, fs, idf);
                        } else {
                            FormatTokenPosition prev = fs.getPreviousNonEmptyLine(pos);
                            if (prev != null) {
                                FormatTokenPosition ip = fs.getInitialPosition(prev);
                                if (fs.isEndingWithSemicolon(ip)) {
                                    this.AdjustCursor(fw, pos, idf, fs.getIndent(ip));
                                } else if (fs.isIfOnlyStatement(ip) || fs.isELSEOnlyStatement(ip) || fs.isBegin(ip) || fs.isConst(ip) || fs.isLabel(ip) || fs.isType(ip) || fs.isVar(ip)) {
                                    this.AdjustCursor(fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                                } else if (fs.isWhile(ip) || fs.isRepeat(ip) || fs.isForOnly(ip) || fs.isRecord(ip) || fs.isWith(ip) || fs.isThenStatement(ip)) {
                                    this.AdjustCursor(fw, pos, idf, fs.getIndent(ip) + fs.getShiftWidth());
                                } else {
                                    FormatTokenPosition ppr = fs.getPreviousNonEmptyLine(prev);
                                    if (fs.isIfOnlyStatement(ppr) || fs.isELSEOnlyStatement(ppr) || fs.isWhile(ppr) || fs.isForOnly(ppr) || fs.isWith(ppr)) {
                                        this.AdjustCursor(fw, pos, idf, fs.getIndent(fs.getInitialPosition(ppr)));
                                    } else {
                                        this.AdjustCursor(fw, pos, idf, fs.getIndent(ip));
                                    }
                                }
                            }
                        }
                        break block19;
                    }
                    while (pos != null) {
                        if (!fs.isComment(pos)) {
                            this.formatLine(fw, pos, fs);
                        } else {
                            this.formatCommentLine(fw, pos, fs);
                        }
                        BasicCompilerType ct = (BasicCompilerType)CompilerType.find(BasicCompilerType.class);
                        FormatTokenPosition pos2 = fs.findLineEnd(pos);
                        if (pos2 != null && pos2.getToken() != null && (pos = fs.getNextPosition(pos2, Position.Bias.Forward)) != pos2 && pos != null && pos.getToken() != null) {
                            FormatTokenPosition fnw = fs.findLineFirstNonWhitespace(pos);
                            if (fnw != null) {
                                pos = fnw;
                                continue;
                            }
                            pos = fs.findLineStart(pos);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("basic-strip-whitespace-at-line-end");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new BasicFormatSupport(fw);
        }

        public void format(FormatWriter fw) {
            Document doc = fw.getDocument();
            BasicFormatSupport fs = (BasicFormatSupport)this.createFormatSupport(fw);
            FormatTokenPosition pos = fs.getFormatStartPosition();
            if (!fs.isIndentOnly()) {
                while (pos.getToken() != null) {
                    if ((pos = fs.removeLineEndWhitespace(pos)).getToken() == null) continue;
                    pos = fs.getNextPosition(pos);
                }
            }
        }
    }
}

