/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.baseclasses.compiler;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCleanCompiler;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerType;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public abstract class AlphaVMSCompilerType
extends ExternalCompilerType {
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_MAKEFILE_COMPILER = "makefileCompiler";
    public static final String PROP_BUILD_OPTION = "buildOption";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_BUILD_COMMAND = "buildCommand";
    public static final String PROP_CCPP_GLOBAL_QUALIFIER = "globalQualifier";
    public static final String PROP_CCPP_LOCAL_QUALIFIER = "localQualifier";
    public static final Object COMPILE = CompilerCookie.Compile.class;
    public static final Object BUILD = CompilerCookie.Build.class;
    public static final Object CLEAN = CompilerCookie.Clean.class;
    public static final Object REMOTE_COMPILE = RemoteCompileCookie.class;
    public static final Object REMOTE_BUILD = RemoteBuildCookie.class;
    public static final String ALPHA_VMS_ERROR_EXPR = "^(.*)\\n[ \\t]*[A|a]t line number ([0-9]+) in file (.*)$";
    public static final String PROP_ERROR_EXPRESSION = "errorExpression";
    private static ResourceBundle bundle;
    private static boolean modified;
    static final long serialVersionUID = 6452094368962892246L;
    protected FileObject fobj;
    protected Map settingsMap;
    protected Project project;
    public static ExternalCompiler.ErrorExpression errorExpression;

    public AlphaVMSCompilerType() {
    }

    public AlphaVMSCompilerType(FileObject fobj) {
        this.fobj = fobj;
    }

    public boolean getPropertyModified() {
        return modified;
    }

    public void setPropertyModified(boolean modified) {
        AlphaVMSCompilerType.modified = modified;
    }

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(AlphaVMSCompilerType.class);
        }
        return bundle.getString(name);
    }

    public void prepareJob(CompilerJob job, Class type, DataObject obj) {
        AlphaVMSCleanCompiler cleaner;
        if (type.equals(CLEAN) || type.equals(BUILD) || type.equals(REMOTE_BUILD)) {
            cleaner = new AlphaVMSCleanCompiler(obj);
            job.add(cleaner);
        } else {
            cleaner = null;
        }
        if (type.equals(COMPILE) || type.equals(BUILD) || type.equals(REMOTE_COMPILE) || type.equals(REMOTE_BUILD)) {
            Compiler compiler = this.createCompiler(type, obj.getPrimaryFile());
            job.add(compiler);
            if (cleaner != null) {
                compiler.dependsOn(cleaner);
            }
        } else if (cleaner == null) {
            // empty if block
        }
    }

    protected abstract Compiler createCompiler(Class var1, FileObject var2);

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        String exp_opt = (String)this.settingsMap.get("error_exp_opt");
        String[] pos = exp_opt.split(" ");
        return new ExternalCompiler.ErrorExpression(NbBundle.getMessage(AlphaVMSCompilerType.class, (String)"ALPHA_VMS_ERROR_FILTER"), (String)this.settingsMap.get("error_exp"), Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2]), Integer.parseInt(pos[3]));
    }

    public void setErrorExpression(ExternalCompiler.ErrorExpression e) {
        this.settingsMap.put("error_exp", e.getErrorExpression());
        this.settingsMap.put("error_exp_opt", Integer.toString(e.getFilePos()) + " " + Integer.toString(e.getLinePos()) + " " + Integer.toString(e.getColumnPos()) + " " + Integer.toString(e.getDescriptionPos()));
    }

    public Boolean outputSwitch() {
        try {
            return ((AbstractNetworkFileSystem)this.fobj.getFileSystem()).getUseXtermCompile() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public Integer xDisplayNumber() {
        try {
            return new Integer(((AbstractNetworkFileSystem)this.fobj.getFileSystem()).getXDisplayDeviceNumber());
        }
        catch (Exception e) {
            return new Integer(0);
        }
    }

    public RemoteFSFile getBuildDirectory() {
        try {
            String dir = (String)this.settingsMap.get("build_dir");
            RemoteFSFile rdir = (RemoteFSFile)Utils.deSerializeObj(dir);
            if (dir == null || dir.trim().length() == 0 || rdir.getAbsolutePath().length() == 0) {
                return null;
            }
            return rdir;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setBuildDirectory(RemoteFSFile buildDir) {
        try {
            if (buildDir != null && buildDir.getAbsolutePath().equals("")) {
                buildDir = null;
            }
            String dir = Utils.serializeObj(buildDir);
            this.settingsMap.put("build_dir", dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBuildCommand() {
        return (String)this.settingsMap.get("build_command");
    }

    public void setBuildCommand(String newBuildCommand) {
        this.settingsMap.put("build_command", newBuildCommand);
    }

    public NbProcessDescriptor getExternalCompiler() {
        return new NbProcessDescriptor((String)this.settingsMap.get("compile_command"), (String)this.settingsMap.get("compile_param"), AlphaVMSCompilerType.getAdditionalHint());
    }

    public void setExternalCompiler(NbProcessDescriptor ext) {
        this.settingsMap.put("compile_command", ext.getProcessName());
        this.settingsMap.put("compile_param", ext.getArguments());
    }

    public Object getBuildOption() {
        String dir = (String)this.settingsMap.get("use_command_file");
        return dir.equals("true") ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setBuildOption(Object newBuildOption) {
        this.settingsMap.put("use_command_file", (Boolean)newBuildOption != false ? "true" : "false");
    }

    public RemoteFSFile getMakefileCompiler() {
        String file = (String)this.settingsMap.get("command_file");
        if (file == null || file.trim().length() == 0) {
            return null;
        }
        try {
            return (RemoteFSFile)Utils.deSerializeObj(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setMakefileCompiler(RemoteFSFile ext) {
        try {
            String file = ext != null && ext.getAbsolutePath().equals("") ? "" : Utils.serializeObj(ext);
            this.settingsMap.put("command_file", file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getGlobalQualifier() {
        return (String)this.settingsMap.get("global_qualifier");
    }

    public String getLocalQualifier() {
        return (String)this.settingsMap.get("local_qualifier");
    }

    public void setGlobalQualifier(String val) {
        this.settingsMap.put("global_qualifier", val);
    }

    public void setLocalQualifier(String val) {
        this.settingsMap.put("local_qualifier", val);
    }

    public static final String getAdditionalHint() {
        return "";
    }

    public String createDefaultBuildCommand() {
        return "@{command file} {file}";
    }

    static {
        errorExpression = new ExternalCompiler.ErrorExpression(NbBundle.getMessage(AlphaVMSCompilerType.class, (String)"ALPHA_VMS_ERROR_FILTER"), ALPHA_VMS_ERROR_EXPR, 3, 2, -1, 1);
    }
}

