/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lexer.editorbridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.swing.TokenElement;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.lexer.editorbridge.LanguageDescriptor;
import org.netbeans.modules.lexer.editorbridge.TokenRootElement;

public class LexerLayer
extends DrawLayer.AbstractLayer
implements DocumentListener {
    public static final String NAME = "lexer-layer";
    public static final int VISIBILITY = 1050;
    private final LanguageDescriptor languageDescriptor;
    private int tokenEndOffset;
    private int tokenIndex;
    private Coloring coloring;
    private boolean active;
    private boolean documentModified;
    static /* synthetic */ Class class$org$netbeans$modules$lexer$editorbridge$TokenRootElement;

    public static TokenRootElement getTokenRootElement(Document document) {
        return (TokenRootElement)document.getProperty(class$org$netbeans$modules$lexer$editorbridge$TokenRootElement == null ? (class$org$netbeans$modules$lexer$editorbridge$TokenRootElement = LexerLayer.class$("org.netbeans.modules.lexer.editorbridge.TokenRootElement")) : class$org$netbeans$modules$lexer$editorbridge$TokenRootElement);
    }

    public LexerLayer(LanguageDescriptor languageDescriptor, JTextComponent jTextComponent) {
        super(NAME);
        this.languageDescriptor = languageDescriptor;
        Document document = jTextComponent.getDocument();
        jTextComponent.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("document".equals(propertyChangeEvent.getPropertyName())) {
                    Document document;
                    Document document2 = (Document)propertyChangeEvent.getOldValue();
                    if (document2 != null) {
                        document2.removeDocumentListener(LexerLayer.this);
                    }
                    if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                        LexerLayer.this.checkDocument(document);
                    }
                }
            }
        });
        this.checkDocument(document);
    }

    private void checkDocument(Document document) {
        document.addDocumentListener(this);
        if (TokenRootElement.get(document) == null) {
            this.createTokenRootElement(document);
        }
    }

    protected TokenRootElement createTokenRootElement(Document document) {
        return new TokenRootElement(document, this.languageDescriptor.getLanguage());
    }

    private TokenRootElement getTokenRootElement(DrawContext drawContext) {
        BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
        return TokenRootElement.get((Document)baseDocument);
    }

    private Coloring findColoring(DrawContext drawContext, Token token) {
        TokenId tokenId = token.getId();
        String string = this.languageDescriptor.getColoringPrefix() + tokenId.getName();
        Coloring coloring = drawContext.getEditorUI().getColoring(string);
        if (coloring == null) {
            List list = tokenId.getCategoryNames();
            Iterator iterator = list.iterator();
            while (coloring == null && iterator.hasNext()) {
                string = this.languageDescriptor.getColoringPrefix() + (String)iterator.next();
                coloring = drawContext.getEditorUI().getColoring(string);
            }
        }
        return coloring;
    }

    public boolean extendsEOL() {
        return true;
    }

    public void init(final DrawContext drawContext) {
        this.tokenIndex = 0;
        this.tokenEndOffset = 0;
        int n = drawContext.getStartOffset();
        int n2 = drawContext.getEndOffset();
        final TokenRootElement tokenRootElement = this.getTokenRootElement(drawContext);
        boolean bl = this.active = tokenRootElement != null;
        if (this.active && this.documentModified) {
            this.documentModified = false;
            if (n > tokenRootElement.getLastUpdateStartOffset() || n2 < tokenRootElement.getLastUpdateEndOffset()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditorUI editorUI = drawContext.getEditorUI();
                        JTextComponent jTextComponent = editorUI.getComponent();
                        if (jTextComponent != null) {
                            TextUI textUI = jTextComponent.getUI();
                            textUI.damageRange(jTextComponent, tokenRootElement.getLastUpdateStartOffset(), tokenRootElement.getLastUpdateEndOffset());
                        }
                    }
                });
            }
        }
        if (this.active) {
            this.tokenIndex = tokenRootElement.getElementIndex(n);
            if (this.tokenIndex >= 0) {
                TokenElement tokenElement;
                int n3 = tokenRootElement.getElementOffset(this.tokenIndex);
                int n4 = tokenRootElement.getElementCount();
                if (this.tokenIndex + 1 == n4) {
                    tokenElement = (TokenElement)tokenRootElement.getElement(this.tokenIndex);
                    if (n3 + (tokenElement.getEndOffset() - tokenElement.getStartOffset()) <= n) {
                        this.active = false;
                    }
                } else {
                    tokenElement = (TokenElement)tokenRootElement.getElement(this.tokenIndex);
                }
                if (this.active) {
                    this.tokenEndOffset = n3 + LexerLayer.getTokenElementLength(tokenElement);
                    this.setNextActivityChangeOffset(this.tokenEndOffset);
                    this.coloring = this.findColoring(drawContext, (Token)tokenElement);
                }
            } else {
                this.active = false;
            }
        }
        if (this.coloring != null) {
            this.coloring.apply(drawContext);
        }
    }

    public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
        return this.active;
    }

    public void updateContext(DrawContext drawContext) {
        if (this.coloring != null) {
            this.coloring.apply(drawContext);
        }
        int n = drawContext.getFragmentOffset() + drawContext.getFragmentLength();
        while (this.active && n >= this.tokenEndOffset) {
            TokenRootElement tokenRootElement = this.getTokenRootElement(drawContext);
            boolean bl = this.active = tokenRootElement != null;
            if (!this.active) continue;
            int n2 = tokenRootElement.getElementCount();
            ++this.tokenIndex;
            if (this.tokenIndex >= n2) {
                this.active = false;
            }
            if (!this.active) continue;
            TokenElement tokenElement = (TokenElement)tokenRootElement.getElement(this.tokenIndex);
            int n3 = LexerLayer.getTokenElementLength(tokenElement);
            this.tokenEndOffset += n3;
            this.coloring = this.findColoring(drawContext, (Token)tokenElement);
            this.setNextActivityChangeOffset(this.tokenEndOffset);
        }
    }

    private static int getTokenElementLength(TokenElement tokenElement) {
        return tokenElement.getEndOffset() - tokenElement.getStartOffset();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified = true;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

