/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.SimpleFileOwnerQueryImplementation;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class FileOwnerQuery {
    private static Lookup.Result implementations;
    private static List cache;
    public static final int EXTERNAL_ALGORITHM_TRANSIENT = 0;

    private FileOwnerQuery() {
    }

    public static Project getOwner(FileObject file) {
        if (file == null) {
            throw new NullPointerException("Passed null to FileOwnerQuery.getOwner(FileObject)");
        }
        FileObject archiveRoot = FileUtil.getArchiveFile((FileObject)file);
        if (archiveRoot != null) {
            file = archiveRoot;
        }
        for (FileOwnerQueryImplementation q : FileOwnerQuery.getInstances()) {
            Project p = q.getOwner(file);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static Project getOwner(URI uri) {
        if (uri.isOpaque() && "jar".equalsIgnoreCase(uri.getScheme())) {
            String schemaPart = uri.getSchemeSpecificPart();
            int index = schemaPart.lastIndexOf(33);
            if (index > 0) {
                schemaPart = schemaPart.substring(0, index);
            }
            try {
                uri = URI.create(schemaPart);
            }
            catch (IllegalArgumentException ex) {
                try {
                    URL u = new URL(schemaPart);
                    uri = new File(u.getPath()).toURI();
                }
                catch (MalformedURLException ex2) {
                    ex2.printStackTrace();
                    assert (false) : schemaPart;
                    return null;
                }
            }
        } else if (!uri.isAbsolute() || uri.isOpaque()) {
            throw new IllegalArgumentException("Bad URI: " + uri);
        }
        for (FileOwnerQueryImplementation q : FileOwnerQuery.getInstances()) {
            Project p = q.getOwner(uri);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    static void reset() {
        SimpleFileOwnerQueryImplementation.reset();
    }

    public static void markExternalOwner(FileObject root, Project owner, int algorithm) throws IllegalArgumentException {
        switch (algorithm) {
            case 0: {
                SimpleFileOwnerQueryImplementation.markExternalOwnerTransient((FileObject)root, (Project)owner);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such algorithm: " + algorithm);
            }
        }
    }

    public static void markExternalOwner(URI root, Project owner, int algorithm) throws IllegalArgumentException {
        switch (algorithm) {
            case 0: {
                SimpleFileOwnerQueryImplementation.markExternalOwnerTransient((URI)root, (Project)owner);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such algorithm: " + algorithm);
            }
        }
    }

    private static synchronized List getInstances() {
        if (implementations == null) {
            implementations = Lookup.getDefault().lookup(new Lookup.Template(FileOwnerQueryImplementation.class));
            implementations.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    Class<FileOwnerQuery> clazz = FileOwnerQuery.class;
                    synchronized (FileOwnerQuery.class) {
                        cache = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
        if (cache == null) {
            cache = new ArrayList(implementations.allInstances());
        }
        return cache;
    }
}

