/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.projectapi.AuxiliaryConfigBasedPreferencesProvider;
import org.netbeans.modules.projectapi.AuxiliaryConfigImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtils {
    private ProjectUtils() {
    }

    public static ProjectInformation getInformation(Project p) {
        ProjectInformation pi = (ProjectInformation)p.getLookup().lookup(ProjectInformation.class);
        if (pi != null) {
            return pi;
        }
        return new BasicInformation(p);
    }

    public static Sources getSources(Project p) {
        Sources s = (Sources)p.getLookup().lookup(Sources.class);
        if (s != null) {
            return s;
        }
        return GenericSources.genericOnly(p);
    }

    public static boolean hasSubprojectCycles(final Project master, final Project candidate) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                return ProjectUtils.visit(new HashSet(), new HashMap(), master, master, candidate);
            }
        });
    }

    public static Preferences getPreferences(Project project, Class clazz, boolean shared) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"clazz", (Object)clazz);
        return AuxiliaryConfigBasedPreferencesProvider.getPreferences(project, clazz, shared);
    }

    private static boolean visit(Set<Project> encountered, Map<Project, Set<? extends Project>> cache, Project curr, Project master, Project candidate) {
        if (!encountered.add(curr)) {
            return true;
        }
        Set<Project> subprojects = cache.get(curr);
        if (subprojects == null) {
            SubprojectProvider spp = (SubprojectProvider)curr.getLookup().lookup(SubprojectProvider.class);
            subprojects = spp != null ? spp.getSubprojects() : Collections.emptySet();
            cache.put(curr, subprojects);
        }
        for (Project project : subprojects) {
            if (candidate == project) {
                candidate = null;
            }
            if (!ProjectUtils.visit(encountered, cache, project, master, candidate)) continue;
            return true;
        }
        if (candidate != null && curr == master && ProjectUtils.visit(encountered, cache, candidate, master, candidate)) {
            return true;
        }
        assert (encountered.contains(curr));
        encountered.remove(curr);
        return false;
    }

    public static AuxiliaryConfiguration getAuxiliaryConfiguration(Project project) {
        return new AuxiliaryConfigImpl(project);
    }

    private static final class BasicInformation
    implements ProjectInformation {
        private final Project p;

        public BasicInformation(Project p) {
            this.p = p;
        }

        public String getName() {
            try {
                return this.p.getProjectDirectory().getURL().toExternalForm();
            }
            catch (FileStateInvalidException e) {
                return e.toString();
            }
        }

        public String getDisplayName() {
            return this.p.getProjectDirectory().getNameExt();
        }

        public Icon getIcon() {
            return new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/projectapi/resources/empty.gif"));
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public Project getProject() {
            return this.p;
        }
    }
}

