/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lexer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.TokenCategory;
import org.netbeans.api.lexer.TokenId;

public abstract class Language {
    private static final Object LOCK = new Object();
    private Set ids;
    private Map idName2id;
    private Set categories;
    private Map lang2isSubset;

    protected Language() {
    }

    public abstract Lexer createLexer();

    protected abstract Set createIds();

    public final Set getIds() {
        if (this.ids == null) {
            this.ids = new TokenCategory.TokenIdSet(this.createIds());
            this.idName2id = Language.createName2IdMap(this.ids.iterator());
        }
        return this.ids;
    }

    public final TokenId getId(int n) {
        return ((TokenCategory.TokenIdSet)this.getIds()).getIndexedIds()[n];
    }

    public final TokenId getValidId(int n) {
        TokenId tokenId = this.getId(n);
        if (tokenId == null) {
            throw new IllegalStateException("No valid tokenId for intId=" + n + " in language " + this);
        }
        return tokenId;
    }

    public final TokenId getId(String string) {
        return (TokenId)this.idName2id.get(string);
    }

    public final int getMaxIntId() {
        return ((TokenCategory.TokenIdSet)this.getIds()).getIndexedIds().length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getCategories() {
        Object object = LOCK;
        synchronized (object) {
            if (this.categories == null) {
                this.categories = new TokenCategory.CategorySet(this.getIds(), this.getMaxIntId());
            }
            return this.categories;
        }
    }

    public final TokenCategory getCategory(String string) {
        return ((TokenCategory.CategorySet)this.getCategories()).getCategory(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSubsetOf(Language language) {
        if (language == this) {
            return true;
        }
        Object object = LOCK;
        synchronized (object) {
            Boolean bl;
            if (this.lang2isSubset == null) {
                this.lang2isSubset = new WeakHashMap(2);
            }
            if ((bl = (Boolean)this.lang2isSubset.get(language)) == null) {
                bl = this.isSubsetOfImpl(language) ? Boolean.TRUE : Boolean.FALSE;
                this.lang2isSubset.put(language, bl);
            }
            return bl;
        }
    }

    private boolean isSubsetOfImpl(Language language) {
        return language.getIds().containsAll(this.getIds());
    }

    private static Map createName2IdMap(Iterator iterator) {
        HashMap<String, TokenId> hashMap = new HashMap<String, TokenId>(2);
        while (iterator.hasNext()) {
            TokenId tokenId = (TokenId)iterator.next();
            TokenId tokenId2 = hashMap.put(tokenId.getName(), tokenId);
            if (tokenId2 == null) continue;
            throw new IllegalStateException("Duplicate name tokenIds: " + tokenId.getName());
        }
        return hashMap;
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String idsToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getIds().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((TokenId)iterator.next()).toStringDetail());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

