/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectVisualPanel;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteRuntimePanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import patchsources.OpenProjectList_Dist;

public class RemoteFTPSelectPanel
implements WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    public static final String WIZARD_KEY_TARGET_FOLDER = "targetFolder";
    public static final String WIZARD_KEY_TARGET_NAME = "targetName";
    public static final int MAX_FILE_COUNT_LIMIT = 200;
    protected RemoteFTPSelectVisualPanel component;
    private RemoteRuntimeType rrt;
    private char[] retPass;
    private ArrayList listeners = new ArrayList();
    private String projectDirectory;
    private boolean editable = false;
    private boolean checkLocalDir = false;
    private String title;
    protected ArrayList rootsHistory;
    protected int panelIndex;
    protected boolean ods2allowed;
    private int count;
    private RemoteFTPSelectPanel remoteftpselectpanel;

    public RemoteFTPSelectPanel(String projectDirectory, String title) {
        this.projectDirectory = projectDirectory;
        this.title = title;
    }

    public RemoteFTPSelectPanel(String projectDirectory, boolean editable, String title) {
        this.projectDirectory = projectDirectory;
        this.editable = editable;
        this.checkLocalDir = editable;
        this.title = title;
    }

    public RemoteFTPSelectPanel(String projectDirectory, RemoteRuntimeType rrt, String title) {
        this.projectDirectory = projectDirectory;
        this.rrt = rrt;
        this.title = title;
    }

    public boolean isFinishPanel() {
        return this.editable;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteFTPSelectVisualPanel(this, this.projectDirectory, this.editable, this.title);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValidLocal() {
        String localCache = this.component.getLocalCacheRoot();
        if (localCache == null || localCache.length() == 0) {
            return false;
        }
        if (!new File(localCache).exists()) {
            return false;
        }
        for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
            String lroot;
            if (!(fs instanceof LocalFileSystem && !(fs instanceof AbstractNetworkFileSystem) ? (lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(localCache) : fs instanceof AbstractNetworkFileSystem && (lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot()).equalsIgnoreCase(localCache))) continue;
            return false;
        }
        return true;
    }

    public boolean isValidLocal(String r1, String r2) {
        if (r1.equalsIgnoreCase(r2)) {
            return false;
        }
        if (r1.length() < r2.length()) {
            if (r1.charAt(r1.length() - 1) == File.separatorChar) {
                r1 = r1.substring(0, r1.length() - 1);
            }
            if (r2.toUpperCase().indexOf(r1.toUpperCase()) == 0 && r2.charAt(r1.length()) == File.separatorChar) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidRemote(String r1, String r2) {
        if (r1.equalsIgnoreCase(r2)) {
            return false;
        }
        if (r1.length() < r2.length()) {
            if (r1.indexOf(93) != -1) {
                r1 = r1.substring(0, r1.indexOf(93));
            }
            if (r2.toUpperCase().indexOf(r1.toUpperCase()) == 0 && (r2.charAt(r1.length()) == '.' || r2.charAt(r1.length()) == ']')) {
                return false;
            }
        }
        return true;
    }

    public boolean isInRootsHistory(String r, String l) throws WizardValidationException {
        if (this.rootsHistory != null) {
            for (int i = 0; i < this.rootsHistory.size(); ++i) {
                String aFolder;
                if (i == this.panelIndex) continue;
                Map map = (Map)this.rootsHistory.get(i);
                String rRoot = ((String)map.get("remote_directory")).toUpperCase();
                String lRoot = ((String)map.get("local_directory")).toUpperCase();
                if (rRoot.trim().length() == 0 || lRoot.trim().length() == 0) continue;
                if (!(this.isValidRemote(rRoot, r) && this.isValidRemote(r, rRoot) || this.isOverwriteConfirmed("MSG_DIR_ALREADY_IN_THIS_REMOTE_PROJECT", aFolder = r.substring(r.lastIndexOf(46) + 1, r.indexOf(93))))) {
                    throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_REMOTE_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_PROJECT"));
                }
                if (this.isValidLocal(lRoot, l) && this.isValidLocal(l, lRoot) || this.isOverwriteConfirmed("MSG_DIR_ALREADY_IN_THIS_LOCAL_PROJECT", aFolder = l.substring(l.lastIndexOf(File.separatorChar) + 1, l.length()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return true;
    }

    private boolean isOverwriteConfirmed(String aKey, String aPath) {
        String aMessage = NbBundle.getMessage(RemoteRuntimePanel.class, (String)aKey);
        if (aPath != null) {
            aMessage = aMessage + " (";
            aMessage = aMessage + aPath;
            aMessage = aMessage + ").  ";
        }
        aMessage = aMessage + "Do you want to overwrite ?";
        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)aMessage, "Question", 0, 3));
        return NotifyDescriptor.OK_OPTION.equals(obj);
    }

    private boolean is3GLProject(String localCache) throws WizardValidationException {
        try {
            if (null == localCache || localCache.equals("")) {
                return false;
            }
            File file = new File(localCache);
            Project project = OpenProjectList_Dist.fileToProject(file);
            RemoteProjectSettings rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (rs == null) {
                return false;
            }
        }
        catch (Exception e) {
            throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"ERR_FIND_3GL_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"ERR_FIND_3GL_PROJECT"));
        }
        return true;
    }

    public boolean isValidPath() throws WizardValidationException {
        try {
            String aFolder;
            String nbprojFolder;
            String aFolder2;
            String localCache = this.component.getLocalCacheRoot();
            String remoteRoot = this.component.getRemoteFTPRoot();
            if (localCache == null || localCache.length() == 0 || remoteRoot == null || remoteRoot.length() == 0) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_LENGTH0"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_LENGTH0"));
            }
            if (this.checkLocalDir && !new File(localCache).exists()) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_NO_LOCAL_DIR"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_NO_LOCAL_DIR"));
            }
            if (!this.getRemoteRuntimeType().getRemoteFileService().fileExists(remoteRoot)) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_NO_REMOTE_DIR"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_NO_REMOTE_DIR"));
            }
            for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
                if (!(fs instanceof AbstractNetworkFileSystem)) continue;
                String lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot().toUpperCase();
                String rroot = ((AbstractNetworkFileSystem)fs).getRemoteRoot().toUpperCase();
                if (!this.isValidLocal(lroot, localCache.toUpperCase())) {
                    throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT"));
                }
                if (this.isValidRemote(rroot, remoteRoot.toUpperCase())) continue;
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT"));
            }
            if (this.isInRootsHistory(remoteRoot.toUpperCase(), localCache.toUpperCase())) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_LOCAL_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_THIS_LOCAL_PROJECT"));
            }
            if ((new File(localCache + File.separatorChar + "nbproject").exists() || new File(localCache + File.separatorChar + "NBPROJECT").exists() || localCache.toUpperCase().indexOf("NBPROJECT") != -1) && this.is3GLProject(localCache) && !this.isOverwriteConfirmed("MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT", aFolder2 = localCache.substring(localCache.lastIndexOf(File.separatorChar) + 1, localCache.length()))) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_LOCAL_PROJECT"));
            }
            String string = nbprojFolder = remoteRoot.endsWith("]") ? remoteRoot.substring(0, remoteRoot.length() - 1) + "." + "nbproject]" : remoteRoot + "[nbproject]";
            if ((this.getRemoteRuntimeType().getRemoteFileService().fileExists(nbprojFolder) || remoteRoot.toUpperCase().indexOf("NBPROJECT") != -1) && !this.isOverwriteConfirmed("MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT", aFolder = remoteRoot.substring(remoteRoot.lastIndexOf(46) + 1, remoteRoot.indexOf(93)))) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_DIR_ALREADY_IN_OTHER_REMOTE_PROJECT"));
            }
        }
        catch (WizardValidationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new WizardValidationException((JComponent)this.getComponent(), e.getMessage(), e.getMessage());
        }
        return true;
    }

    public final void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeState() {
        ArrayList list;
        RemoteFTPSelectPanel remoteFTPSelectPanel = this;
        synchronized (remoteFTPSelectPanel) {
            list = (ArrayList)this.listeners.clone();
        }
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public void readSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        this.rrt = (RemoteRuntimeType)wiz.getProperty("remote_runtime");
        if (this.projectDirectory == null) {
            this.component.setLocalDirectory(((File)wiz.getProperty(WIZARD_KEY_TARGET_FOLDER)).getAbsolutePath() + File.separatorChar + (String)wiz.getProperty(WIZARD_KEY_TARGET_NAME));
        }
        this.rootsHistory = (ArrayList)wiz.getProperty("remotefs_list");
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        wiz.putProperty("remote_directory", (Object)this.component.getRemoteFTPRoot());
        wiz.putProperty("local_directory", (Object)this.component.getLocalCacheRoot());
        wiz.putProperty("FTP_PORT", (Object)this.component.getFTPPortValue());
        wiz.putProperty("AUTO_SYNC", (Object)this.component.getAutoSync());
        wiz.putProperty("READ_ONLY", (Object)this.component.getReadOnly());
        wiz.putProperty("IS_PASSIVE", (Object)this.component.getUsePassiveMode());
        wiz.putProperty("SSH_FORWARD", (Object)this.component.getUseSSHForwarding());
        wiz.putProperty("FTP_PASS", (Object)this.remoteftpselectpanel.getFtpPass());
    }

    private void countFiles(File dir, ArrayList queue) throws Exception {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                queue.add(files[i]);
            }
            ++this.count;
            if (this.count != 200) continue;
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_FILE_COUNT_LIMIT_EXCEED"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"TITLE_LOCAL_ROOT"), 2));
            if (res.equals(NotifyDescriptor.OK_OPTION)) {
                throw new Exception("OK");
            }
            throw new Exception("Cancel");
        }
        if (queue.size() > 0) {
            File file = (File)queue.get(0);
            queue.remove(0);
            for (int j = 0; j < queue.size(); ++j) {
                this.countFiles(file, queue);
            }
        }
    }

    private boolean isLargeRoot(String localPath) {
        block2: {
            try {
                ArrayList queue = new ArrayList();
                this.countFiles(new File(localPath), queue);
            }
            catch (Exception e) {
                if (e.getMessage().equals("OK")) break block2;
                return true;
            }
        }
        return false;
    }

    public void validate() throws WizardValidationException {
        String remoteRoot;
        block11: {
            remoteRoot = this.component.getRemoteFTPRoot();
            String localRoot = this.component.getLocalCacheRoot();
            this.isValidPath();
            if (this.isLargeRoot(localRoot)) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_FILE_COUNT_TOO_MANY"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_FILE_COUNT_TOO_MANY"));
            }
            if (!this.ods2allowed) {
                try {
                    if (this.rrt.getRemoteFileService().checkIfODS2(remoteRoot)) {
                        throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_ODS2_DISK_NOT_ALLOWED"), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_ODS2_DISK_NOT_ALLOWED"));
                    }
                    break block11;
                }
                catch (RemoteException e) {
                    throw new WizardValidationException((JComponent)this.getComponent(), e.getMessage(), e.getMessage());
                }
            }
            String nbprojFolderLocal = localRoot.endsWith(File.separator) ? localRoot + "nbproject" : localRoot + File.separatorChar + "nbproject";
        }
        String nbprojFolder = remoteRoot.endsWith("]") ? remoteRoot.substring(0, remoteRoot.length() - 1) + "." + "nbproject]" : remoteRoot + "[nbproject]";
        try {
            String remoteRootDir;
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("USER", this.rrt.getUserName());
            if (!this.rrt.getSavePassword()) {
                this.retPass = this.rrt.getFTPCredentials(this.component);
                if (this.retPass == null) {
                    return;
                }
            } else {
                hm.put("PASSWD", this.rrt.getPassword());
            }
            if ((remoteRootDir = this.rrt.getRemoteFileService().getDefaultDirectory()) != null && remoteRootDir.length() > 0 && remoteRootDir.trim().equalsIgnoreCase(FileUtility.openVMSPathToUnixPath(remoteRoot, true))) {
                throw new WizardValidationException((JComponent)this.getComponent(), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_NO_SYSLOGIN", (Object)remoteRoot), NbBundle.getMessage(RemoteRuntimePanel.class, (String)"MSG_NO_SYSLOGIN", (Object)remoteRoot));
            }
        }
        catch (RemoteException e) {
            throw new WizardValidationException((JComponent)this.getComponent(), e.getMessage(), e.getMessage());
        }
    }

    public char[] getFtpPass() {
        return this.retPass;
    }
}

