/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.distributed.common.propertyeditors.ErrorExpressionEditor2;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remoteexecute.TargetExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class RemoteExecutor {
    private static final long serialVersionUID = 4921782425419448313L;
    public static final String PROP_REMOTE_EXECUTOR = "remoteExecutor";
    public static final String TAG_FILE = "file";
    public static final String TAG_CURRENT_DIR = "current dir";
    public static final String TAG_ARGUMENTS = "arguments";
    public static final String TAG_ROOT_DIR = "root dir";
    public static final String TAG_FILENAME = "file name";
    public static final String TAG_EXT = "file extension";
    public static final String TAG_DEVICE = "device";
    public static final String TAG_DIRECTORY = "directory";
    public static final String TAG_JAVA_CLASSNAME = "java class";
    public static final String PROP_ERROR_EXPRESSION = "errorExpression";
    public static final String PROP_CHANGE_WORKING_DIR = "changeWorkingDir";
    protected ExternalCompiler.ErrorExpression errorExpression = ErrorExpressionEditor2.errorExpression;
    protected RemoteProcessDescriptor remoteExecutor;
    protected boolean useXterm;
    protected boolean includeFileExtension;
    protected boolean useUnixFilePath;
    protected boolean changeWorkingDir;
    protected boolean useFileNameOnly;
    protected File workingDirectory = null;
    protected MapFormat format;
    private static final ResourceBundle bundle = NbBundle.getBundle(RemoteExecutor.class);

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        return this.errorExpression;
    }

    public void setErrorExpression(ExternalCompiler.ErrorExpression e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        ExternalCompiler.ErrorExpression old = this.errorExpression;
        this.errorExpression = e;
    }

    public boolean getChangeWorkingDir() {
        return this.changeWorkingDir;
    }

    public void setChangeWorkingDir(boolean workingDir) {
        boolean old = this.changeWorkingDir;
        this.changeWorkingDir = workingDir;
    }

    public RemoteProcessDescriptor getRemoteExecutor() {
        return this.getExternalExecutor();
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        if (this.remoteExecutor == null) {
            this.remoteExecutor = new RemoteProcessDescriptor("run ", " {arguments} {file}", NbBundle.getBundle(RemoteExecutor.class).getString("MSG_RemoteExecutorHint"));
        }
        return this.remoteExecutor;
    }

    public void setRemoteExecutor(RemoteProcessDescriptor re) {
        this.setExternalExecutor(re);
    }

    public void setExternalExecutor(RemoteProcessDescriptor re) {
        this.remoteExecutor = re;
    }

    protected MapFormat createMapFormat(DataObject obj, AbstractNetworkFileSystem nfs) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        FileObject fobj = obj.getPrimaryFile();
        String arguments = (String)fobj.getAttribute("REMOTE_ARGUMENT");
        if (arguments != null && arguments.length() > 0) {
            m.put(TAG_ARGUMENTS, arguments);
        } else {
            m.put(TAG_ARGUMENTS, "");
        }
        String className = fobj.getPath();
        className = className.replace('/', '.');
        if (className.lastIndexOf(46) > 0) {
            className = className.substring(0, className.lastIndexOf(46));
        }
        m.put(TAG_JAVA_CLASSNAME, className);
        File file = FileUtil.toFile((FileObject)fobj);
        String vmsPath = "";
        if (Utilities.isWindows()) {
            vmsPath = RemoteFSUtils._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            vmsPath = RemoteFSUtils.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
        }
        String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
        if (curDir == null || curDir.length() == 0) {
            File pfile = FileUtil.toFile((FileObject)fobj.getParent());
            if (Utilities.isWindows()) {
                curDir = RemoteFSUtils._winPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                curDir = RemoteFSUtils.unixPathToOpenVMSPath(pfile.getAbsolutePath(), true, fobj.getParent());
            }
        }
        m.put(TAG_CURRENT_DIR, curDir);
        String rootDir = nfs.getRemoteRoot();
        m.put(TAG_ROOT_DIR, rootDir);
        m.put(TAG_FILE, vmsPath);
        String fileName = curDir + fobj.getName();
        String devName = vmsPath.indexOf(":") > 0 ? vmsPath.substring(0, vmsPath.indexOf(":")) : vmsPath;
        m.put(TAG_FILENAME, fileName);
        m.put(TAG_EXT, fobj.getExt());
        m.put(TAG_DEVICE, devName);
        m.put(TAG_DIRECTORY, curDir);
        MapFormat mf = new MapFormat(m);
        mf.setLeftBrace("{");
        mf.setRightBrace("}");
        return mf;
    }

    public abstract boolean isRemoteJavaCompile();

    public ExecutorTask execute(DataObject obj) throws IOException {
        NbProcessDescriptor npd;
        String cmd;
        AbstractNetworkFileSystem nfs = null;
        RemoteRuntimeType rrt = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
        }
        catch (FileStateInvalidException exp) {
            // empty catch block
        }
        rrt = nfs.getRemoteRuntimeType();
        if (nfs == null || !(nfs instanceof AbstractNetworkFileSystem)) {
            IOException ioe = new IOException("The file " + obj.getNodeDelegate().getDisplayName() + " is not a remote file");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)bundle.getString("EXC_no_remote_execution"), 2));
            ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        if (rrt == null) {
            IOException ioe = new IOException("");
            String[] host = nfs.getDisplayName().split(" ");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("No matching remote server with name \"" + host[0].toString() + "\" is found.\n Please go to Services Tab and create remote server"), 1));
            ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        if (rrt.getRemoteRuntime() == null) {
            IOException ioe = new IOException("");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Remote server \"" + rrt.getHostName() + "\" " + " is disconnected.\nPlease go to Runtime Tab and make connection using \"" + rrt.getUserName() + "\""), 1));
            ErrorManager.getDefault().annotate((Throwable)ioe, 1, null, null, null, null);
            throw ioe;
        }
        File file = FileUtil.toFile((FileObject)obj.getPrimaryFile().getParent());
        String cwd = null;
        if (this.getChangeWorkingDir()) {
            cwd = this.getWorkingDirectory(file, obj);
        }
        boolean useX = false;
        Boolean bobj = null;
        int displayNumber = 0;
        bobj = this.isRemoteJavaCompile() ? (Boolean)obj.getPrimaryFile().getAttribute("useXtermCompile") : (Boolean)obj.getPrimaryFile().getAttribute("useXtermExecution");
        useX = bobj != null ? bobj : (this.isRemoteJavaCompile() ? nfs.getUseXtermCompile() : nfs.getUseXtermExecution());
        if (useX) {
            Integer iobj = (Integer)obj.getPrimaryFile().getAttribute("xDisplayDeviceNumber");
            displayNumber = iobj != null ? iobj.intValue() : nfs.getXDisplayDeviceNumber();
        }
        if (useX && Utilities.isWindows() && (cmd = DistributedSettings.getDefault().getXServer()) != null && cmd.length() > 0) {
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Problem launching X Window sever on your desktop.", 2));
                ErrorManager.getDefault().annotate((Throwable)e, 1, null, null, null, null);
                throw e;
            }
        }
        RemoteProcessDescriptor rpd = obj.getPrimaryFile().getMIMEType().endsWith("ant+xml") ? ((npd = (NbProcessDescriptor)obj.getPrimaryFile().getAttribute("externalCompiler")) != null ? new RemoteProcessDescriptor(npd.getProcessName(), npd.getArguments(), "") : this.getRemoteExecutor()) : this.getRemoteExecutor();
        Project project = FileOwnerQuery.getOwner((FileObject)obj.getPrimaryFile());
        String projName = "";
        if (project != null) {
            projName = ProjectUtils.getInformation((Project)project).getDisplayName();
        }
        TargetExecutor texec = new TargetExecutor(rrt, rpd, this.getErrorExpression(), useX, this.format, cwd, obj, displayNumber);
        return texec.execute(projName + " (" + obj.getPrimaryFile().getNameExt() + ")");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.distributed.RemoteExecutor");
    }

    public String getWorkingDirectory(File file, DataObject obj) {
        String cwd = null;
        if (this.workingDirectory != null) {
            if (Utilities.isWindows()) {
                cwd = RemoteFSUtils.__winPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true);
                cwd = FileUtility.openVMSPathToUnixPath(cwd, true);
            } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                cwd = FileUtility.unixPathToOpenVMSPath(this.workingDirectory.getAbsolutePath(), true);
            }
        } else if (Utilities.isWindows()) {
            cwd = RemoteFSUtils._winPathToOpenVMSPath(file.getAbsolutePath(), true, obj.getPrimaryFile().getParent());
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
            cwd = RemoteFSUtils.unixPathToOpenVMSPath(file.getAbsolutePath(), true, obj.getPrimaryFile().getParent());
        }
        return cwd;
    }

    public static void disconnectRemoteProcesses() {
    }

    public static class Format
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_CLASSNAME = "classname";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        static final long serialVersionUID = 1105067849363827986L;

        public Format() {
            this(NbClassPath.createClassPath(), NbClassPath.createBootClassPath(), NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.EXECUTE), NbClassPath.createLibraryPath());
        }

        public Format(NbClassPath classPath, NbClassPath bootClassPath, NbClassPath repository, NbClassPath library) {
            super(new HashMap(7));
            Map map = this.getMap();
            map.put(TAG_CLASSPATH, classPath.getClassPath());
            map.put(TAG_BOOTCLASSPATH, bootClassPath.getClassPath());
            map.put(TAG_REPOSITORY, repository.getClassPath());
            map.put(TAG_LIBRARY, library.getClassPath());
            map.put(TAG_JAVAHOME, System.getProperty(TAG_JAVAHOME));
            map.put(TAG_JDKHOME, System.getProperty(TAG_JDKHOME));
            map.put(TAG_SEPARATOR, File.separator);
            map.put(TAG_PATHSEPARATOR, File.pathSeparator);
        }
    }
}

