/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.actions;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.actions.CaseIgnoreComparator;
import org.netbeans.modules.distributed.ideserverclient.actions.MyTimer;
import org.netbeans.modules.distributed.ideserverclient.actions.TimerListener;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.rmi.protocol.Admin;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class AdminPanel
extends JPanel
implements TimerListener {
    private DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
    private JTable jTable1;
    private JScrollPane scrollPane;
    private MyTimer t;
    private static final String[] columnNames = new String[]{" Server System", " User", " Number of Processes", " Number of Connections"};
    private String password;
    private JScrollPane jScrollPane1;

    public AdminPanel(String password) {
        this.password = password;
        this.setUpTable(this.getAdminInterfaces(password));
        this.t = new MyTimer(1000, this);
        this.t.start();
    }

    public void stopRefresh() {
        this.t.interrupt();
    }

    public void timeElapsed(MyTimer t) {
        Map adminInterfaces = this.getAdminInterfaces(this.password);
        if (adminInterfaces != null) {
            this.jScrollPane1.remove(this.jTable1);
            this.jTable1 = new JTable(this.getData(adminInterfaces), columnNames);
            this.jScrollPane1.setViewportView(this.jTable1);
            this.jTable1.repaint();
        } else {
            this.stopRefresh();
        }
    }

    private Map getAdminInterfaces(String password) {
        TreeMap<String, Admin> map = new TreeMap<String, Admin>(new CaseIgnoreComparator());
        HashSet runtimes = DistributedSettings.getDefault().getRemoteRuntimes();
        for (RemoteRuntimeType rrt : runtimes) {
            if (!rrt.isConnected()) continue;
            map.put(rrt.getHostName(), rrt.getAdminInterface(password));
        }
        return map;
    }

    private Object[][] getData(Map admins) {
        int numOfUsers = 0;
        Object[][] data = null;
        try {
            Iterator itr = admins.keySet().iterator();
            while (itr.hasNext()) {
                String host = ((String)itr.next()).toLowerCase();
                Admin admin = (Admin)admins.get(host);
                if (admin == null) continue;
                numOfUsers += admin.getUserCount();
            }
            data = new Object[numOfUsers][columnNames.length];
            itr = admins.keySet().iterator();
            int j = 0;
            while (itr.hasNext()) {
                String[] users;
                boolean samehost = false;
                String host = ((String)itr.next()).toLowerCase();
                Admin admin = (Admin)admins.get(host);
                if (admin == null || (users = admin.getListOfUsers()) == null) continue;
                for (int i = 0; i < users.length; ++i) {
                    if (!samehost) {
                        data[j][0] = "  " + host;
                        samehost = true;
                    }
                    data[j][1] = "  " + users[i];
                    data[j][2] = "  " + admin.getNumberOfUserProcess(users[i]);
                    data[j][3] = "  " + admin.getNumberOfUserConnections(users[i]);
                    ++j;
                }
            }
        }
        catch (RemoteException e) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
            return null;
        }
        return data;
    }

    private void setTableCellAlignment(int alignment) {
        this.renderer.setHorizontalAlignment(alignment);
        for (int i = 0; i < this.jTable1.getColumnCount(); ++i) {
            this.jTable1.setDefaultRenderer(this.jTable1.getColumnClass(i), this.renderer);
        }
        this.jTable1.updateUI();
    }

    private void setUpTable(Map admins) {
        Object[][] data;
        this.initComponents();
        this.jTable1 = admins != null ? ((data = this.getData(admins)) != null ? new JTable(this.getData(admins), columnNames) : new JTable(new Object[0][], columnNames)) : new JTable(new Object[0][], columnNames);
        JTableHeader mytableheader = this.jTable1.getTableHeader();
        mytableheader.setFont(new Font("Arial", 1, 12));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.setTableCellAlignment(2);
        this.setPreferredSize(new Dimension(700, 300));
    }

    private void fillupTable(RemoteRuntimeType rrt) {
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.setLayout(new GridLayout(1, 0));
        this.add(this.jScrollPane1);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public void updateTable() {
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
            class MyTableModel
            extends AbstractTableModel {
                final String[] columnNames = new String[]{"Name", "Value"};
                final Object[][] data = new Object[][]{{"a", "b"}, {"c", "d"}, {"e", "f"}};

                MyTableModel() {
                }

                public int getColumnCount() {
                    return this.columnNames.length;
                }

                public int getRowCount() {
                    return this.data.length;
                }

                public String getColumnName(int col) {
                    return this.columnNames[col];
                }

                public Object getValueAt(int row, int col) {
                    return this.data[row][col];
                }
            }
            this.jTable1.setModel(new MyTableModel());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        AdminPanel adp = new AdminPanel("VMSRULES");
        adp.show();
    }

    class AdminTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] data;
        private MyTimer t;

        public AdminTableModel(String[] columnNames, Object[][] data) {
            this.columnNames = columnNames;
            this.data = data;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }
    }
}

