/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.debugger.InvalidExpressionException;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.debugger.Variable;
import com.hp.openvms.netbeans.debugsupport.model.Local;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.HashSet;
import java.util.Set;

public class AbstractVariable
implements Variable,
Customizer {
    private String name;
    private String value;
    private RemoteDebugger debugger;
    private String id;
    private String genericType;
    private Local[] fields;
    private Set listeners = new HashSet();

    public AbstractVariable(RemoteDebugger debugger, String name, String type, String value, String id) {
        this.debugger = debugger;
        this.name = name;
        this.genericType = type;
        this.value = value;
        this.id = id;
        if (this.id == null) {
            this.id = Integer.toString(super.hashCode());
        }
    }

    public String getValue() {
        String v = this.getInnerValue();
        return v;
    }

    public void setValue(String expression) throws InvalidExpressionException {
        String value = expression;
        if (this.genericType.equals("char *")) {
            String oldstrValue;
            String strAddr = null;
            String strValue = null;
            int i = expression.indexOf(32);
            if (i >= 0) {
                strAddr = expression.substring(0, i);
                strValue = expression.substring(i + 1);
            } else if (expression.startsWith("0x")) {
                strAddr = expression;
            } else {
                strValue = expression;
            }
            String oldValue = this.getValue();
            if (strAddr != null && !oldValue.startsWith(strAddr)) {
                strAddr = expression;
            }
            if ((i = oldValue.indexOf(32)) >= 0 && !(oldstrValue = oldValue.substring(i + 1)).equals(strValue)) {
                for (int n = 0; n < strValue.length(); ++n) {
                    char c = strValue.charAt(n);
                    if (c == oldstrValue.charAt(n)) continue;
                    if (n < 2) break;
                    int k = n - 2;
                }
            }
            return;
        }
    }

    public void setObject(Object bean) {
        try {
            if (!(bean instanceof String)) {
                throw new IllegalArgumentException("" + bean);
            }
            this.setValue((String)bean);
        }
        catch (InvalidExpressionException ieex) {
            IllegalArgumentException iaex = new IllegalArgumentException(ieex.getLocalizedMessage());
            iaex.initCause(ieex);
            throw iaex;
        }
    }

    public int getFieldsCount() {
        if (this.fields == null) {
            this.initFields();
        }
        return this.fields.length;
    }

    public Local getField(String name) {
        if (this.fields == null) {
            return null;
        }
        for (Local f : this.fields) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    public Local[] getFields(int from, int to) {
        if (this.fields == null) {
            this.initFields();
        }
        if (to != 0) {
            to = Math.min(this.fields.length, to);
            from = Math.min(this.fields.length, from);
            Local[] fv = new Local[to - from];
            System.arraycopy(this.fields, from, fv, 0, to - from);
            return fv;
        }
        return this.fields;
    }

    public String getToStringValue() throws InvalidExpressionException {
        String v = this.getInnerValue();
        return v;
    }

    public String getType() {
        if (this.genericType != null) {
            return this.genericType;
        }
        return "";
    }

    public void setDeclaredType(String type) {
        this.genericType = type;
    }

    public boolean equals(Object o) {
        return o instanceof AbstractVariable && this.id.equals(((AbstractVariable)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String name() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    protected String getInnerValue() {
        return this.value;
    }

    protected void setInnerValue(String v) {
        this.value = v;
    }

    protected final RemoteDebugger getDebugger() {
        return this.debugger;
    }

    String getID() {
        return this.id;
    }

    private static String getTypeDescription(PushbackReader signature) throws IOException {
        int c = signature.read();
        switch (c) {
            case 90: {
                return "boolean";
            }
            case 66: {
                return "byte";
            }
            case 67: {
                return "char";
            }
            case 83: {
                return "short";
            }
            case 73: {
                return "int";
            }
            case 74: {
                return "long";
            }
            case 70: {
                return "float";
            }
            case 68: {
                return "double";
            }
            case 91: {
                int arrayCount = 1;
                while (true) {
                    if ((c = signature.read()) != 91) break;
                    ++arrayCount;
                }
                signature.unread(c);
                return AbstractVariable.getTypeDescription(signature) + " " + AbstractVariable.brackets(arrayCount);
            }
            case 76: {
                StringBuffer typeName = new StringBuffer(50);
                while (true) {
                    if ((c = signature.read()) == 59) {
                        int idx = typeName.lastIndexOf("/");
                        return idx == -1 ? typeName.toString() : typeName.substring(idx + 1);
                    }
                    if (c == 60) {
                        int idx = typeName.lastIndexOf("/");
                        if (idx != -1) {
                            typeName.delete(0, idx + 1);
                        }
                        typeName.append("<");
                        while (true) {
                            String td = AbstractVariable.getTypeDescription(signature);
                            typeName.append(td);
                            c = signature.read();
                            if (c == 62) break;
                            signature.unread(c);
                            typeName.append(',');
                        }
                        signature.read();
                        typeName.append(">");
                        return typeName.toString();
                    }
                    typeName.append((char)c);
                }
            }
        }
        throw new IOException();
    }

    private static String brackets(int arrayCount) {
        StringBuffer sb = new StringBuffer(arrayCount * 2);
        do {
            sb.append("[]");
        } while (--arrayCount > 0);
        return sb.toString();
    }

    private void initFields() {
        this.fields = new Local[0];
    }

    public void addField(Local field) {
        if (this.fields == null) {
            this.initFields();
        }
        int n = this.fields.length;
        Local[] fv = new Local[n + 1];
        System.arraycopy(this.fields, 0, fv, 0, n);
        this.fields = fv;
        this.fields[n] = field;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    public String toString() {
        return "ObjectVariable ";
    }

    private static String convertToStringInitializer(String s) {
        StringBuffer sb = new StringBuffer();
        int k = s.length();
        block9: for (int i = 0; i < k; ++i) {
            switch (s.charAt(i)) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    private static String convertToCharInitializer(String s) {
        StringBuffer sb = new StringBuffer();
        int k = s.length();
        block9: for (int i = 0; i < k; ++i) {
            switch (s.charAt(i)) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block9;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }
}

