/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.breakpoints.DebuggerAnnotation;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class EditorContextImpl
extends EditorContext {
    private static String fronting = System.getProperty("netbeans.debugger.fronting");
    private PropertyChangeSupport pcs;
    private Map annotationToURL = new HashMap();
    private ChangeListener changedFilesListener;
    private Map timeStampToRegistry = new HashMap();
    private Set modifiedDataObjects;
    private PropertyChangeListener editorObservableListener;
    private Lookup.Result resDataObject;
    private Lookup.Result resEditorCookie;
    private Lookup.Result resNode;
    private Object currentLock = new Object();
    private String currentURL = null;
    private EditorCookie currentEditorCookie = null;

    public EditorContextImpl() {
        this.pcs = new PropertyChangeSupport(this);
        this.resDataObject = Utilities.actionsGlobalContext().lookup(new Lookup.Template(DataObject.class));
        this.resDataObject.addLookupListener((LookupListener)new EditorLookupListener(DataObject.class));
        this.resEditorCookie = Utilities.actionsGlobalContext().lookup(new Lookup.Template(EditorCookie.class));
        this.resEditorCookie.addLookupListener((LookupListener)new EditorLookupListener(EditorCookie.class));
        this.resNode = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Node.class));
        this.resNode.addLookupListener((LookupListener)new EditorLookupListener(Node.class));
    }

    public boolean showSource(String url, int lineNumber, Object timeStamp) {
        Line l = this.getLine(url, lineNumber, timeStamp);
        if (l == null) {
            return false;
        }
        if (fronting != null) {
            if (fronting.equals("true")) {
                l.show(3);
            } else {
                l.show(2);
            }
            return true;
        }
        if (Utilities.isWindows()) {
            l.show(3);
        } else {
            l.show(2);
        }
        return true;
    }

    public void createTimeStamp(Object timeStamp) {
        this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        Registry r = new Registry();
        this.timeStampToRegistry.put(timeStamp, r);
        Iterator i = this.modifiedDataObjects.iterator();
        while (i.hasNext()) {
            r.register((DataObject)i.next());
        }
        if (this.changedFilesListener == null) {
            this.changedFilesListener = new ChangedFilesListener();
            DataObject.getRegistry().addChangeListener(this.changedFilesListener);
        }
    }

    public void disposeTimeStamp(Object timeStamp) {
        this.timeStampToRegistry.remove(timeStamp);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
    }

    public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        Line l = this.getLine(url, lineNumber, timeStamp);
        if (l == null) {
            return null;
        }
        DebuggerAnnotation annotation = new DebuggerAnnotation(annotationType, l);
        this.annotationToURL.put(annotation, url);
        return annotation;
    }

    public void removeAnnotation(Object a) {
        DebuggerAnnotation annotation = (DebuggerAnnotation)((Object)a);
        annotation.detach();
        if (this.annotationToURL.remove((Object)annotation) == null) {
            return;
        }
    }

    public int getLineNumber(Object annotation, Object timeStamp) {
        DebuggerAnnotation a = (DebuggerAnnotation)((Object)annotation);
        if (timeStamp == null) {
            return a.getLine().getLineNumber() + 1;
        }
        String url = (String)this.annotationToURL.get((Object)a);
        Line.Set lineSet = this.getLineSet(url, timeStamp);
        return lineSet.getOriginalLineNumber(a.getLine()) + 1;
    }

    public void updateTimeStamp(Object timeStamp, String url) {
        Registry registry = (Registry)this.timeStampToRegistry.get(timeStamp);
        registry.register(EditorContextImpl.getDataObject(url));
    }

    public int getCurrentLineNumber() {
        JTextComponent jtc = EditorRegistry.lastFocusedComponent();
        if (jtc == null) {
            return -1;
        }
        StyledDocument d = (StyledDocument)EditorRegistry.lastFocusedComponent().getDocument();
        return NbDocument.findLineNumber((StyledDocument)d, (int)jtc.getCaretPosition()) + 1;
    }

    public int getMostRecentLineNumber() {
        EditorCookie e = this.getMostRecentEditorCookie();
        if (e == null) {
            return -1;
        }
        JEditorPane ep = this.getMostRecentEditor();
        if (ep == null) {
            return -1;
        }
        StyledDocument d = e.getDocument();
        if (d == null) {
            return -1;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return -1;
        }
        int ln = NbDocument.findLineNumber((StyledDocument)d, (int)caret.getDot());
        return ln + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentURL() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentURL == null) {
                DataObject[] nodes = this.resDataObject.allInstances().toArray(new DataObject[0]);
                this.currentURL = "";
                if (nodes.length != 1) {
                    return this.currentURL;
                }
                DataObject dobj = nodes[0];
                if (dobj instanceof DataShadow) {
                    dobj = ((DataShadow)dobj).getOriginal();
                }
                try {
                    this.currentURL = dobj.getPrimaryFile().getURL().toString();
                }
                catch (FileStateInvalidException ex) {
                    // empty catch block
                }
            }
            return this.currentURL;
        }
    }

    public String getMostRecentURL() {
        Node[] nodes;
        String url = this.getCurrentURL();
        if (url.length() == 0 && (nodes = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodes.length; ++i) {
                DataObject dobj = (DataObject)nodes[i].getCookie(DataObject.class);
                if (dobj == null) continue;
                try {
                    url = dobj.getPrimaryFile().getURL().toExternalForm();
                    break;
                }
                catch (FileStateInvalidException ex) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    public String getCurrentFunctionName() {
        return "";
    }

    public String getSelectedFunctionName() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return "";
        }
        JEditorPane ep = this.getCurrentEditor();
        if (ep == null) {
            return "";
        }
        StyledDocument doc = e.getDocument();
        if (doc == null) {
            return "";
        }
        int offset = ep.getCaret().getDot();
        Object t = null;
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        return "";
    }

    public int getFieldLineNumber(String url, String className, String fieldName) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentMIMEType() {
        Object object = this.currentLock;
        synchronized (object) {
            FileObject fo;
            DataObject[] nodes = this.resDataObject.allInstances().toArray(new DataObject[0]);
            if (nodes.length != 1) {
                return "";
            }
            DataObject dobj = nodes[0];
            if (dobj instanceof DataShadow) {
                dobj = ((DataShadow)dobj).getOriginal();
            }
            try {
                fo = URLMapper.findFileObject((URL)dobj.getPrimaryFile().getURL());
            }
            catch (FileStateInvalidException ex) {
                fo = null;
            }
            return fo != null ? fo.getMIMEType() : "";
        }
    }

    public String getMostRecentMIMEType() {
        Node[] nodes;
        String mime = this.getCurrentMIMEType();
        if (mime.length() == 0 && (nodes = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodes.length; ++i) {
                DataObject dobj = (DataObject)nodes[i].getCookie(DataObject.class);
                if (dobj == null) continue;
                if (dobj instanceof DataShadow) {
                    dobj = ((DataShadow)dobj).getOriginal();
                }
                try {
                    FileObject fo = URLMapper.findFileObject((URL)dobj.getPrimaryFile().getURL());
                    mime = fo.getMIMEType();
                    break;
                }
                catch (FileStateInvalidException ex) {
                    // empty catch block
                }
            }
        }
        return mime;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    private JEditorPane getCurrentEditor() {
        EditorCookie e = this.getCurrentEditorCookie();
        if (e == null) {
            return null;
        }
        if (e instanceof EditorCookie.Observable) {
            JEditorPane[] op = e.getOpenedPanes();
            if (op == null || op.length < 1) {
                return null;
            }
            return op[0];
        }
        return null;
    }

    private JEditorPane getMostRecentEditor() {
        EditorCookie e = this.getMostRecentEditorCookie();
        if (e == null) {
            return null;
        }
        JEditorPane[] op = e.getOpenedPanes();
        if (op == null || op.length < 1) {
            return null;
        }
        return op[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditorCookie getCurrentEditorCookie() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentEditorCookie == null) {
                TopComponent tc = TopComponent.getRegistry().getActivated();
                if (tc != null) {
                    this.currentEditorCookie = (EditorCookie)tc.getLookup().lookup(EditorCookie.class);
                }
                if (this.currentEditorCookie instanceof EditorCookie.Observable) {
                    if (this.editorObservableListener == null) {
                        this.editorObservableListener = new EditorLookupListener(EditorCookie.Observable.class);
                    }
                    ((EditorCookie.Observable)this.currentEditorCookie).addPropertyChangeListener(this.editorObservableListener);
                }
            }
            return this.currentEditorCookie;
        }
    }

    private EditorCookie getMostRecentEditorCookie() {
        Node[] nodes;
        EditorCookie ec = this.getCurrentEditorCookie();
        if (ec == null && (nodes = TopComponent.getRegistry().getActivatedNodes()) != null) {
            for (int i = 0; i < nodes.length; ++i) {
                ec = (EditorCookie)nodes[i].getCookie(EditorCookie.class);
                if (ec == null) continue;
                System.err.println("Got it!");
            }
        }
        return ec;
    }

    private Line.Set getLineSet(String url, Object timeStamp) {
        LineCookie lineCookie;
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        if (timeStamp != null) {
            Registry registry = (Registry)this.timeStampToRegistry.get(timeStamp);
            Line.Set ls = null;
            try {
                ls = registry.getLineSet(dataObject);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            if (ls != null) {
                return ls;
            }
        }
        if ((lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return lineCookie.getLineSet();
    }

    private Line getLine(String url, int lineNumber, Object timeStamp) {
        Line.Set ls = this.getLineSet(url, timeStamp);
        if (ls == null) {
            return null;
        }
        try {
            if (timeStamp == null) {
                return ls.getCurrent(lineNumber - 1);
            }
            return ls.getOriginal(lineNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    private static DataObject getDataObject(String url) {
        FileObject file;
        assert (url != null && url.startsWith("file:") || !Boolean.getBoolean("gdb.assertions.enabled"));
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            assert (!Boolean.getBoolean("gdb.assertions.enabled"));
            return null;
        }
        catch (Exception ex) {
            assert (!Boolean.getBoolean("gdb.assertions.enabled"));
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private class EditorLookupListener
    implements LookupListener,
    PropertyChangeListener {
        private Class type;

        public EditorLookupListener(Class type) {
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            if (this.type == DataObject.class) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == EditorCookie.class) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            } else if (this.type == Node.class) {
                EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("openedPanes")) {
                EditorContextImpl.this.pcs.firePropertyChange("openedPanes", null, null);
            }
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        public void stateChanged(ChangeEvent e) {
            HashSet newDOs = new HashSet(DataObject.getRegistry().getModifiedSet());
            newDOs.removeAll(EditorContextImpl.this.modifiedDataObjects);
            for (Registry r : EditorContextImpl.this.timeStampToRegistry.values()) {
                Iterator i2 = newDOs.iterator();
                while (i2.hasNext()) {
                    r.register((DataObject)i2.next());
                }
            }
            EditorContextImpl.this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        }
    }

    private static class Registry {
        private Map dataObjectToLineSet = new HashMap();

        private Registry() {
        }

        void register(DataObject dataObject) {
            LineCookie lc = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lc == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lc.getLineSet());
        }

        Line.Set getLineSet(DataObject dataObject) {
            return (Line.Set)this.dataObjectToLineSet.get(dataObject);
        }
    }
}

