/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.openide.util.Utilities;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (!this.listen) {
            return;
        }
        if (!(propertyName.equals("condition") || propertyName.equals("url") || propertyName.equals("lineNumber") || propertyName.equals("enabled"))) {
            return;
        }
        if (e.getSource() instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)((Object)e.getSource());
            this.annotate(lb);
            return;
        }
        if (e.getSource() instanceof FunctionBreakpoint) {
            FunctionBreakpoint fb = (FunctionBreakpoint)((Object)e.getSource());
            this.annotate(fb);
            return;
        }
    }

    public void breakpointAdded(Breakpoint b) {
        if (b instanceof LineBreakpoint) {
            ((LineBreakpoint)b).addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotate((LineBreakpoint)b);
        }
        if (b instanceof FunctionBreakpoint) {
            ((FunctionBreakpoint)b).addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint b) {
        if (b instanceof LineBreakpoint) {
            ((LineBreakpoint)b).removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation((LineBreakpoint)b);
        }
        if (b instanceof FunctionBreakpoint) {
            FunctionBreakpoint fb = (FunctionBreakpoint)b;
            fb.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation(fb);
            int bpn = fb.getBreakpointNumber();
            if (bpn > 0) {
                RemoteDebugger debugger = fb.getDebugger();
            }
        }
    }

    public RemoteBreakpoint findBreakpoint(String url, int lineNumber) {
        for (Object o : this.breakpointToAnnotation.keySet()) {
            int ln;
            Object annotation;
            if (o instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)((Object)o);
                if (!lb.getURL().equals(url)) continue;
                annotation = this.breakpointToAnnotation.get((Object)lb);
                ln = EditorContextBridge.getContext().getLineNumber(annotation, null);
                if (ln == lineNumber) {
                    return lb;
                }
            }
            if (!(o instanceof FunctionBreakpoint)) continue;
            FunctionBreakpoint fb = (FunctionBreakpoint)((Object)o);
            if (Utilities.isWindows()) {
                boolean found = false;
                if (fb.getURL().equals(url)) {
                    found = true;
                } else {
                    String fb_url = fb.getURL();
                    if (fb_url.startsWith("file:/") && url.startsWith("file:/") && fb_url.charAt(7) == ':' && url.charAt(7) == ':') {
                        String url_lc = url.substring(0, 8);
                        url_lc = url_lc.toLowerCase() + url.substring(8);
                        String fb_url_lc = fb_url.substring(0, 8);
                        if ((fb_url_lc = fb_url_lc.toLowerCase() + fb_url.substring(8)).equals(url_lc)) {
                            found = true;
                        }
                    }
                }
                if (!found) {
                    continue;
                }
            } else if (!fb.getURL().equals(url)) continue;
            annotation = this.breakpointToAnnotation.get((Object)fb);
            ln = EditorContextBridge.getContext().getLineNumber(annotation, null);
            if (ln != lineNumber) continue;
            return fb;
        }
        return null;
    }

    private void annotate(LineBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.get((Object)b);
        if (annotation != null) {
            EditorContextBridge.getContext().removeAnnotation(annotation);
        }
        if (b.isHidden()) {
            return;
        }
        annotation = EditorContextBridge.annotate(b);
        if (annotation == null) {
            return;
        }
        this.breakpointToAnnotation.put(b, annotation);
        DebuggerEngine dm = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object timeStamp = null;
        if (dm != null) {
            timeStamp = dm.lookupFirst(null, RemoteDebugger.class);
        }
        this.update(b, timeStamp);
    }

    public void updateBreakpoints() {
        for (Object o : this.breakpointToAnnotation.keySet()) {
            if (o instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)((Object)o);
                this.update(lb, null);
            }
            if (!(o instanceof FunctionBreakpoint)) continue;
            FunctionBreakpoint fb = (FunctionBreakpoint)((Object)o);
            this.update(fb, null);
        }
    }

    private void update(LineBreakpoint b, Object timeStamp) {
        Object annotation = this.breakpointToAnnotation.get((Object)b);
        int ln = EditorContextBridge.getContext().getLineNumber(annotation, timeStamp);
        this.listen = false;
        b.setLineNumber(ln);
        this.listen = true;
    }

    private void removeAnnotation(LineBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.remove((Object)b);
        if (annotation != null) {
            EditorContextBridge.getContext().removeAnnotation(annotation);
        }
    }

    private void annotate(FunctionBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.get((Object)b);
        if (annotation != null) {
            EditorContextBridge.getContext().removeAnnotation(annotation);
        }
        if (b.isHidden()) {
            return;
        }
        int lineNumber = b.getLineNumber();
        if (lineNumber < 1) {
            return;
        }
        annotation = EditorContextBridge.annotate(b);
        if (annotation == null) {
            return;
        }
        this.breakpointToAnnotation.put(b, annotation);
        DebuggerEngine dm = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object timeStamp = null;
        if (dm != null) {
            timeStamp = dm.lookupFirst(null, RemoteDebugger.class);
        }
        this.update(b, timeStamp);
    }

    private void update(FunctionBreakpoint b, Object timeStamp) {
        Object annotation = this.breakpointToAnnotation.get((Object)b);
        int ln = EditorContextBridge.getContext().getLineNumber(annotation, timeStamp);
        this.listen = false;
        b.setLineNumber(ln);
        this.listen = true;
    }

    private void removeAnnotation(FunctionBreakpoint b) {
        Object annotation = this.breakpointToAnnotation.remove((Object)b);
        if (annotation == null) {
            annotation = b.annotation;
        }
        if (annotation != null) {
            EditorContextBridge.getContext().removeAnnotation(annotation);
        }
    }
}

