/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteproject.wizard;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remoteproject.wizard.PanelConfigureProjectVisual;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

final class PanelConfigureProject
implements WizardDescriptor.Panel,
WizardDescriptor.ValidatingPanel,
WizardDescriptor.FinishablePanel {
    private WizardDescriptor wizardDescriptor;
    private int type;
    private PanelConfigureProjectVisual component;
    private TemplateWizard settings = null;
    private final Set listeners = new HashSet(1);

    public PanelConfigureProject(int type) {
        this.type = type;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new PanelConfigureProjectVisual(this, this.type);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        this.getComponent();
        return this.component.valid(this.wizardDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    private File findProjectCreationDir() {
        return ProjectChooser.getProjectsFolder();
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        this.component.read(this.wizardDescriptor);
        Object substitute = this.component.getClientProperty("NewProjectWizard_Title");
        if (substitute != null) {
            this.wizardDescriptor.putProperty("NewProjectWizard_Title", substitute);
        }
        this.settings = (TemplateWizard)settings;
        this.setTargetFolder();
    }

    private void setTargetFolder() {
        try {
            File dir = ProjectChooser.getProjectsFolder();
            if (dir != null) {
                FileObject fob = FileUtil.toFileObject((File)dir);
                if (fob != null) {
                    DataFolder fld = (DataFolder)DataObject.find((FileObject)fob);
                    if (fld != null) {
                        this.settings.setTargetFolder(fld);
                    } else {
                        System.err.println("  No data object for " + dir);
                    }
                } else {
                    System.err.println("  No fileobject for " + dir);
                }
            } else {
                System.err.println(" project creation dir null");
            }
        }
        catch (DataObjectNotFoundException e) {
            throw new IllegalArgumentException("Could not find data object for " + this.findProjectCreationDir());
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor d = (WizardDescriptor)settings;
        this.component.store(d);
        ((TemplateWizard)settings).putProperty("targetName", d.getProperty("name"));
        ((TemplateWizard)settings).putProperty("targetFolder", d.getProperty("projdir"));
    }

    public boolean isFinishPanel() {
        return false;
    }

    public void validate() throws WizardValidationException {
        this.getComponent();
        this.component.validate(this.wizardDescriptor);
    }
}

