/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute.ant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.ant.RemoteAntExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import patchsources.OpenProjectList_Dist;

public class RemoteJavaFileActions
extends NodeAction
implements Presenter.Popup {
    static final long serialVersionUID = -7910677883191530623L;
    public static final String REMOTE_BUILD = "Compile File";
    public static final String REMOTE_RUN = "Run File";
    public static final String REMOTE_DEBUG = "Debug File";
    public static final String REMOTE_OPERATIONS = "Remote Java Operations";

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu((SystemAction)this, new ActSubMenuModel(this), true);
    }

    protected boolean enable(Node[] nodes) {
        for (int j = 0; j < nodes.length; ++j) {
            DataObject dobj = (DataObject)nodes[0].getCookie(DataObject.class);
            FileObject fobj = dobj.getPrimaryFile();
            try {
                if (fobj.getFileSystem() instanceof AbstractNetworkFileSystem) continue;
                return false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public void performAction(Node[] nodes) {
    }

    public String getName() {
        return REMOTE_OPERATIONS;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean asynchronous() {
        return false;
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = null;
        private Node[] nodes = null;
        private DataObject dobj = null;
        private String vmsPath = null;
        private String clazz = null;
        private final NodeAction action;

        ActSubMenuModel(NodeAction action) {
            this.action = action;
            this.targets = new ArrayList();
        }

        public int getCount() {
            if (this.targets == null) {
                return 0;
            }
            return this.targets.size();
        }

        public String getLabel(int index) {
            return (String)this.targets.get(index);
        }

        public HelpCtx getHelpCtx(int index) {
            return new HelpCtx("org.apache.tools.ant.module.executing-target");
        }

        private static void refreshFS() {
            for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
                if (fs.isReadOnly() || !(fs instanceof AbstractNetworkFileSystem)) continue;
                fs.refresh(false);
            }
        }

        public static RemoteAntExecutor getRemoteAntExecutorType() {
            RemoteAntExecutor ex = (RemoteAntExecutor)Lookup.getDefault().lookup(RemoteAntExecutor.class);
            return ex;
        }

        public void performActionAt(final int index) {
            if (DistributedSettings.getDefault().getSaveAll()) {
                LifecycleManager.getDefault().saveAll();
            }
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    ActSubMenuModel.refreshFS();
                    String antTarget = "";
                    String antProp = "";
                    String target = (String)ActSubMenuModel.this.targets.get(index);
                    if (target.equals(RemoteJavaFileActions.REMOTE_BUILD)) {
                        antTarget = "compile-single";
                    } else if (target.equals(RemoteJavaFileActions.REMOTE_DEBUG)) {
                        antTarget = "remotedebug";
                    } else if (target.equals(RemoteJavaFileActions.REMOTE_RUN)) {
                        antTarget = "run-single";
                    } else {
                        return;
                    }
                    RemoteAntExecutor ret = ActSubMenuModel.getRemoteAntExecutorType();
                    if (ret == null) {
                        ErrorManager.getDefault().notify((Throwable)new Exception("Remote Ant Execute Action Failed"));
                        return;
                    }
                    try {
                        HashMap<String, String> pmap = new HashMap<String, String>();
                        pmap.put("javac.includes", ActSubMenuModel.this.vmsPath);
                        pmap.put("run.class", ActSubMenuModel.this.clazz);
                        pmap.put("main.class", ActSubMenuModel.this.clazz);
                        ret.execute(ActSubMenuModel.this.dobj, antTarget, pmap);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    ActSubMenuModel.refreshFS();
                }
            });
        }

        private FileObject getRoot(FileObject root, FileObject file) {
            FileObject srcDir = null;
            if (FileUtil.isParentOf((FileObject)root, (FileObject)file) || root.equals(file)) {
                srcDir = root;
            }
            return srcDir;
        }

        void addNotify() {
            this.nodes = this.action.getActivatedNodes();
            if (this.nodes.length == 0) {
                return;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)((DataObject)this.nodes[0].getCookie(DataObject.class)).getPrimaryFile());
            if (project == null) {
                return;
            }
            AntArtifactProvider antProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class);
            if (antProvider == null) {
                return;
            }
            AntArtifact[] antArts = antProvider.getBuildArtifacts();
            if (antArts == null || antArts.length == 0) {
                return;
            }
            FileObject buildXml = antArts[0].getScriptFile();
            FileObject pdir = project.getProjectDirectory();
            String projectDirectory = FileUtil.toFile((FileObject)pdir).getAbsolutePath();
            try {
                this.dobj = DataObject.find((FileObject)buildXml);
                FileObject fobj = ((DataObject)this.nodes[0].getCookie(DataObject.class)).getPrimaryFile();
                Sources srcs = ProjectUtils.getSources((Project)project);
                SourceGroup[] sgs = srcs.getSourceGroups("java");
                this.vmsPath = this.clazz = FileUtil.getRelativePath((FileObject)sgs[0].getRootFolder(), (FileObject)fobj);
                if (this.clazz == null) {
                    return;
                }
                if (this.clazz.endsWith(".java")) {
                    this.clazz = this.clazz.substring(0, this.clazz.length() - 5);
                }
                this.clazz = this.clazz.replace('/', '.');
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
                if (!(fs instanceof AbstractNetworkFileSystem) || !projectDirectory.equalsIgnoreCase(((AbstractNetworkFileSystem)fs).getLocalRoot())) continue;
                this.targets.add(RemoteJavaFileActions.REMOTE_BUILD);
                this.targets.add(RemoteJavaFileActions.REMOTE_RUN);
                this.targets.add(RemoteJavaFileActions.REMOTE_DEBUG);
            }
        }

        public synchronized void addChangeListener(ChangeListener l) {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(SystemAction action, ActSubMenuModel model, boolean popup) {
            super(action, (Actions.SubMenuModel)model, popup);
            this.model = model;
            this.addNotify();
        }

        public void addNotify() {
            this.model.addNotify();
            super.addNotify();
        }
    }
}

