/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.openide.ErrorManager;
import org.openide.compiler.ExternalCompiler;

public class ParseOutput {
    private static String trimString(String s) {
        char c;
        int idx = 0;
        int slen = s.length();
        if (slen == 0) {
            return s;
        }
        while (((c = s.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s = s.substring(idx)).length() - 1) < 0) {
            return s;
        }
        while (((c = s.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s.substring(0, idx + 2);
    }

    private static RE getErrorPattern(ExternalCompiler.ErrorExpression err) {
        String regexp = err.getErrorExpression();
        try {
            RECompiler rec = new RECompiler();
            REProgram rep = rec.compile(regexp);
            RE errRE = new RE(rep, 2);
            return errRE;
        }
        catch (RESyntaxException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    public static void parseErrors(ExternalCompiler.ErrorExpression err, Reader parsedReader, Writer osw) {
        RE errorPattern = ParseOutput.getErrorPattern(err);
        ReaderCharacterIterator chi = new ReaderCharacterIterator(new BufferedReader(parsedReader));
        BufferedWriter os = new BufferedWriter(osw);
        int idx = 0;
        try {
            while (errorPattern.match(chi, idx)) {
                String sg;
                int column;
                int line;
                if (err.getFilePos() < 0) {
                    return;
                }
                int lowerBound = 0;
                int upperBound = errorPattern.getParenCount() - 1;
                String file = errorPattern.getParen(err.getFilePos());
                if (err.getLinePos() < lowerBound || err.getLinePos() > upperBound) {
                    line = 1;
                } else {
                    try {
                        line = Integer.parseInt(errorPattern.getParen(err.getLinePos()));
                    }
                    catch (NumberFormatException ex) {
                        line = 1;
                    }
                }
                if (err.getColumnPos() < lowerBound || err.getColumnPos() > upperBound) {
                    column = 1;
                } else {
                    try {
                        column = Integer.parseInt(errorPattern.getParen(err.getColumnPos()));
                    }
                    catch (NumberFormatException ex) {
                        column = 1;
                    }
                }
                String msg = err.getDescriptionPos() < lowerBound || err.getDescriptionPos() > upperBound ? "" : ((sg = errorPattern.getParen(err.getDescriptionPos())) == null ? "" : sg.trim());
                String refText = "";
                String rst = chi.substring(idx, errorPattern.getParenStart(0));
                if (!rst.equals("")) {
                    os.write(ParseOutput.trimString(rst));
                    os.newLine();
                    os.flush();
                }
                os.write((file != null ? file.trim() : null) + line + column + msg + refText);
                os.newLine();
                os.flush();
                idx = errorPattern.getParenEnd(0);
            }
            String rst = chi.substring(idx);
            if (!rst.equals("")) {
                os.write(ParseOutput.trimString(rst));
                os.newLine();
                os.flush();
            }
        }
        catch (IOException io) {
            io.printStackTrace(System.err);
        }
    }
}

