/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.debugger.Field;
import com.hp.openvms.netbeans.debugsupport.debugger.InvalidExpressionException;
import com.hp.openvms.netbeans.debugsupport.debugger.LocalVariable;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.debugger.Variable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class VariablesTableModel
implements TableModel,
Constants {
    private RemoteDebugger debugger;
    private ContextProvider lookupProvider;

    public VariablesTableModel(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.debugger = (RemoteDebugger)lookupProvider.lookupFirst(null, RemoteDebugger.class);
    }

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if (columnID.equals("LocalsToString") || columnID.equals("WatchToString")) {
            if (row instanceof Variable) {
                return ((Variable)row).getValue();
            }
        } else if (columnID.equals("LocalsType") || columnID.equals("WatchType")) {
            if (row instanceof Variable) {
                return VariablesTableModel.getShort(((Variable)row).getType());
            }
        } else if ((columnID.equals("LocalsValue") || columnID.equals("WatchValue")) && row instanceof Variable) {
            return ((Variable)row).getValue();
        }
        if (row.toString().startsWith("No current thread")) {
            return NbBundle.getMessage(VariablesTableModel.class, (String)"NoCurrentThreadVar");
        }
        throw new UnknownTypeException(row);
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Variable) {
            if (columnID.equals("LocalsToString") || columnID.equals("WatchToString") || columnID.equals("LocalsType") || columnID.equals("WatchType")) {
                return true;
            }
            if (columnID.equals("LocalsValue") || columnID.equals("WatchValue")) {
                return !(row instanceof LocalVariable) && !(row instanceof Field);
            }
        }
        if (row.toString().startsWith("No current thread")) {
            return true;
        }
        throw new UnknownTypeException(row);
    }

    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (row instanceof LocalVariable && columnID.equals("LocalsValue")) {
            try {
                ((LocalVariable)row).setValue((String)value);
            }
            catch (InvalidExpressionException e) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            return;
        }
        throw new UnknownTypeException(row);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    static String getShort(String c) {
        if (c == null) {
            return null;
        }
        int i = c.lastIndexOf(46);
        if (i < 0) {
            return c;
        }
        return c.substring(i + 1);
    }
}

