/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class FunctionBreakpoint
extends RemoteBreakpoint {
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_FUNCTION_NAME = "functionName";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final int TYPE_FUNCTION_ENTRY = 1;
    public static final int TYPE_FUNCTION_EXIT = 2;
    private String function = "";
    private String condition = "";
    private String url = "";
    private String path = "";
    private int lineNumber;
    private int type;

    private FunctionBreakpoint() {
    }

    public static FunctionBreakpoint create(String function) {
        FunctionBreakpointComparable b = new FunctionBreakpointComparable();
        b.setID();
        b.setFunctionName(function);
        return b;
    }

    public String getFunctionName() {
        return this.function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFunctionName(String function) {
        String old;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            int i;
            if (function == null) {
                function = "";
            }
            if ((i = function.indexOf(32)) > 0) {
                function = function.replaceAll(" ", "");
            }
            if ((i = function.indexOf("(void)")) > 0) {
                function = function.substring(0, i + 1) + function.substring(i + 5);
            }
            if (function.equals(this.function)) {
                return;
            }
            old = function;
            this.function = function;
        }
        this.firePropertyChange(PROP_FUNCTION_NAME, old, function);
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String url) {
        String old;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            block11: {
                if (url == this.url || url != null && this.url != null && url.equals(this.url)) {
                    return;
                }
                if (!(url = url.replace(" ", "%20")).startsWith("file:/")) {
                    url = url.startsWith("/") ? "file:" + url : "file:/" + url;
                }
                try {
                    assert (url != null || !Boolean.getBoolean("gdb.assertions.enabled"));
                    FileObject fo = URLMapper.findFileObject((URL)new URL(url));
                    if (fo != null) {
                        this.path = Utilities.isWindows() ? fo.getPath() : "/" + fo.getPath();
                    }
                }
                catch (MalformedURLException mue) {
                    assert (!Boolean.getBoolean("gdb.assertions.enabled"));
                    return;
                }
                catch (Exception ex) {
                    if ($assertionsDisabled || !Boolean.getBoolean("gdb.assertions.enabled")) break block11;
                    throw new AssertionError();
                }
            }
            old = this.url;
            this.url = url;
        }
        this.firePropertyChange(PROP_URL, old, url);
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int ln) {
        int old;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            if (ln == this.lineNumber) {
                return;
            }
            old = this.lineNumber;
            this.lineNumber = ln;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(old), new Integer(ln));
    }

    public void setBreakpointType(int type) {
        this.type = type;
    }

    public int getBreakpointType() {
        return this.type;
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String c) {
        String old;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            if (c == null) {
                c = "";
            }
            if ((c = c.trim()) == this.condition || c != null && this.condition != null && this.condition.equals(c)) {
                return;
            }
            old = this.condition;
            this.condition = c;
        }
        this.firePropertyChange(PROP_CONDITION, old, c);
    }

    public String toString() {
        return "FunctionBreakpoint " + this.function;
    }

    private static class FunctionBreakpointComparable
    extends FunctionBreakpoint
    implements Comparable {
        public int compareTo(Object o) {
            if (o instanceof FunctionBreakpointComparable) {
                FunctionBreakpointComparable lbthis = this;
                FunctionBreakpoint lb = (FunctionBreakpoint)((Object)o);
                return ((FunctionBreakpoint)lbthis).function.compareTo(lb.function);
            }
            return -1;
        }
    }
}

