/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.prop;

import com.hp.openvms.netbeans.cppsupport.prop.SheetButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.UIManager;

class PropertyShow
extends JPanel {
    static final long serialVersionUID = -8663903931982719530L;
    private PropertyEditor propertyEditor;
    private Vector listeners = new Vector(1, 5);

    public PropertyShow(PropertyEditor aPropertyEditor) {
        this.propertyEditor = aPropertyEditor;
        this.setDoubleBuffered(false);
        this.setOpaque(true);
    }

    public void setValue(Object newValue) {
        this.propertyEditor.setValue(newValue);
    }

    public void paintComponent(Graphics g) {
        Dimension sz = this.getSize();
        Color color = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, sz.width, sz.height);
        Rectangle r = new Rectangle();
        r.setBounds(4, 0, sz.width - 4, sz.height);
        g.setColor(this.getForeground());
        this.propertyEditor.paintValue(g, r);
        g.setColor(color);
        if (this.hasFocus()) {
            g.setColor(UIManager.getColor("Button.focus"));
            g.drawRect(1, 1, sz.width - 3, sz.height - 3);
        }
    }

    public void setEditor(PropertyEditor aEditor) {
        this.propertyEditor = aEditor;
    }

    void fireSheetButtonClicked(ActionEvent e) {
        Vector l = (Vector)this.listeners.clone();
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            ((SheetButtonListener)l.elementAt(i)).sheetButtonClicked(e);
        }
    }

    public void addSheetButtonListener(SheetButtonListener sheetListener) {
        this.listeners.addElement(sheetListener);
    }

    public void removeSheetButtonListener(SheetButtonListener sheetListener) {
        this.listeners.removeElement(sheetListener);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessiblePropertyShow();
        }
        return this.accessibleContext;
    }

    private class AccessiblePropertyShow
    extends JPanel.AccessibleJPanel {
        AccessiblePropertyShow() {
            super(PropertyShow.this);
        }

        public String getAccessibleName() {
            return PropertyShow.this.propertyEditor.getAsText();
        }
    }
}

