/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.cobol;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerType;
import com.hp.openvms.netbeans.baseclasses.compiler.BogusCompiler;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompiler;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.distributed.common.util.Utils;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class CobolCompilerType
extends AlphaVMSCompilerType {
    public static final String PROP_ANSIFORMATTING = "ansiFormatting";
    private Boolean updated;
    private static ResourceBundle bundle;
    static final long serialVersionUID = 3952144683021797629L;

    public CobolCompilerType(FileObject fobj) {
        super(fobj);
        this.project = FileOwnerQuery.getOwner((FileObject)fobj);
        FileObject pdir = this.project.getProjectDirectory();
        String projectDirectory = FileUtil.toFile((FileObject)pdir).getAbsolutePath();
        this.settingsMap = Utils.getCompilerSettingsFrom3GLXML(projectDirectory, "cobol");
    }

    public static String getString(String name) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(CobolCompilerType.class);
        }
        return bundle.getString(name);
    }

    public Object getAnsiFormatting() {
        String ansi = (String)this.settingsMap.get("cobol_ansi");
        return ansi.equals("true") ? Boolean.TRUE : Boolean.FALSE;
    }

    public synchronized void setAnsiFormatting(Object newAnsi) {
        this.settingsMap.put("cobol_ansi", (Boolean)newAnsi != false ? "true" : "false");
    }

    public void prepareJob(CompilerJob job, Class type, DataObject obj) {
        if (obj instanceof CobolDataObject) {
            super.prepareJob(job, type, obj);
        } else {
            String message = MessageFormat.format(CobolCompilerType.getString("MSG_InvalidCompiler"), this.getName(), obj.getPrimaryFile().toString());
            Throwable t = ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Invalid compiler"), 256, null, message, null, null);
            BogusCompiler compiler = new BogusCompiler(obj.getPrimaryFile(), t);
            job.add(compiler);
        }
    }

    protected Compiler createCompiler(Class type, FileObject fo) {
        return new CobolCompiler(type, fo, this.getExternalCompiler(), this.getErrorExpression(), this);
    }

    public void flushSettings() throws IOException {
        Utils.writeCompilerSettingto3GLXML(this.project, "cobol", this.settingsMap);
    }
}

