/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.security.Permission;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;

public final class NbfsURLConnection
extends URLConnection {
    public static final String PROTOCOL = "nbfs";
    private URLConnection del;

    public NbfsURLConnection(URL u) {
        super(u);
    }

    public static URL encodeFileObject(FileObject fo) throws FileStateInvalidException {
        return fo.getURL();
    }

    public static FileObject decodeURL(URL u) {
        if (!u.getProtocol().equals(PROTOCOL)) {
            return null;
        }
        FileObject[] fos = URLMapper.findFileObjects((URL)u);
        return fos.length > 0 ? fos[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (this.del != null) {
            return;
        }
        NbfsURLConnection nbfsURLConnection = this;
        synchronized (nbfsURLConnection) {
            if (this.del != null) {
                return;
            }
            FileObject fo = NbfsURLConnection.decodeURL(this.url);
            if (fo == null) {
                throw new IOException("Cannot find: " + this.url);
            }
            this.del = fo.getURL().openConnection();
        }
    }

    public InputStream getInputStream() throws IOException, UnknownServiceException {
        this.connect();
        return this.del.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, UnknownServiceException {
        this.connect();
        return this.del.getOutputStream();
    }

    public int getContentLength() {
        try {
            this.connect();
            return this.del.getContentLength();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    public String getHeaderField(String name) {
        try {
            this.connect();
            return this.del.getHeaderField(name);
        }
        catch (IOException ex) {
            return super.getHeaderField(name);
        }
    }

    public Permission getPermission() throws IOException {
        if (this.del != null) {
            return this.del.getPermission();
        }
        return new FilePermission("<<ALL FILES>>", "read");
    }
}

