/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.util.NbBundle;

final class StandardModule
extends Module {
    private final File jar;
    private File physicalJar = null;
    private static final Map extensionOwners;
    private static final Set moduleJARs;
    private Set localeVariants = null;
    private Set plainExtensions = null;
    private Set localeExtensions = null;
    private Set patches = null;
    private Properties localizedProps;
    private transient boolean released;
    private transient int releaseCount = 0;
    private static PermissionCollection modulePermissions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardModule(ModuleManager mgr, Events ev, File jar, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException {
        super(mgr, ev, history, reloadable, autoload, eager);
        this.jar = jar;
        this.loadManifest();
        this.findPatches(this.calculateCodeNameBase(this.manifest));
        Manifest patchedManifest = null;
        patchedManifest = this.findPatchedManifest();
        if (patchedManifest != null) {
            this.manifest = patchedManifest;
        }
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        Set bogoOwners = (Set)extensionOwners.get(jar);
        if (bogoOwners != null) {
            Util.err.log(16, "WARNING - module " + jar + " was incorrectly placed in the Class-Path of other JARs " + bogoOwners + "; please use OpenIDE-Module-Module-Dependencies instead");
        }
        moduleJARs.add(jar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLocalizedAttribute(String attr) {
        int idx;
        String locb = this.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        boolean usingLoader = false;
        if (locb != null) {
            if (this.classloader != null) {
                if (locb.endsWith(".properties")) {
                    usingLoader = true;
                    String basename = locb.substring(0, locb.length() - 11).replace('/', '.');
                    try {
                        ResourceBundle bundle = NbBundle.getBundle((String)basename, (Locale)Locale.getDefault(), (ClassLoader)this.classloader);
                        try {
                            return bundle.getString(attr);
                        }
                        catch (MissingResourceException mre) {
                        }
                    }
                    catch (MissingResourceException mre) {
                        Util.err.notify((Throwable)mre);
                    }
                } else {
                    Util.err.log(16, "WARNING - cannot efficiently load non-*.properties OpenIDE-Module-Localizing-Bundle: " + locb);
                }
            }
            if (!usingLoader) {
                String val;
                block19: {
                    if (this.localizedProps == null) {
                        Util.err.log("Trying to get localized attr " + attr + " from disabled module " + this.getCodeNameBase());
                        try {
                            if (this.jar != null) {
                                JarFile jarFile = new JarFile(this.jar, false);
                                try {
                                    this.loadLocalizedProps(jarFile, this.manifest);
                                    break block19;
                                }
                                finally {
                                    jarFile.close();
                                }
                            }
                            throw new IllegalStateException();
                        }
                        catch (IOException ioe) {
                            Util.err.annotate((Throwable)ioe, 1, this.jar.getAbsolutePath(), null, null, null);
                            Util.err.notify(1, (Throwable)ioe);
                            if (this.localizedProps != null) break block19;
                            this.localizedProps = new Properties();
                        }
                    }
                }
                if ((val = this.localizedProps.getProperty(attr)) != null) {
                    return val;
                }
            }
        }
        if ((idx = attr.lastIndexOf(47)) == -1) {
            return NbBundle.getLocalizedValue((Attributes)this.getManifest().getMainAttributes(), (Attributes.Name)new Attributes.Name(attr));
        }
        String section = attr.substring(0, idx);
        String realAttr = attr.substring(idx + 1);
        Attributes attrs = this.getManifest().getAttributes(section);
        if (attrs != null) {
            return NbBundle.getLocalizedValue((Attributes)attrs, (Attributes.Name)new Attributes.Name(realAttr));
        }
        return null;
    }

    public boolean owns(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)cl)).getModule() == this;
        }
        return false;
    }

    public boolean isFixed() {
        return false;
    }

    public File getJarFile() {
        return this.jar;
    }

    private void ensurePhysicalJar() throws IOException {
        if (this.reloadable && this.physicalJar == null) {
            this.physicalJar = Util.makeTempJar(this.jar);
        }
    }

    private void destroyPhysicalJar() {
        if (this.physicalJar != null) {
            if (this.physicalJar.isFile()) {
                if (!this.physicalJar.delete()) {
                    Util.err.log(16, "Warning: temporary JAR " + this.physicalJar + " not currently deletable.");
                } else {
                    Util.err.log("deleted: " + this.physicalJar);
                }
            }
            this.physicalJar = null;
        } else {
            Util.err.log("no physicalJar to delete for " + (Object)((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest loadPatchJarManifest(File patchJar) throws IOException {
        Util.err.log("loading patch jar manifest of " + patchJar);
        File jarBeingOpened = null;
        try {
            jarBeingOpened = patchJar;
            JarFile jarFile = new JarFile(patchJar, false);
            try {
                Manifest m = jarFile.getManifest();
                if (m == null) return null;
                Manifest manifest = m;
                return manifest;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException e) {
            if (jarBeingOpened == null) throw e;
            Util.err.annotate((Throwable)e, 0, "While loading patch jar manifest from: " + jarBeingOpened, null, null, null);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest() throws IOException {
        block8: {
            Util.err.log("loading manifest of " + this.jar);
            File jarBeingOpened = null;
            try {
                if (this.reloadable) {
                    jarBeingOpened = this.physicalJar;
                    this.ensurePhysicalJar();
                    jarBeingOpened = this.physicalJar;
                    JarFile jarFile = new JarFile(this.physicalJar, false);
                    try {
                        Manifest m = jarFile.getManifest();
                        if (m == null) {
                            throw new IOException("No manifest found in " + this.physicalJar);
                        }
                        this.manifest = m;
                        break block8;
                    }
                    finally {
                        jarFile.close();
                    }
                }
                jarBeingOpened = this.jar;
                this.manifest = this.getManager().loadManifest(this.jar);
            }
            catch (IOException e) {
                if (jarBeingOpened != null) {
                    Util.err.annotate((Throwable)e, 0, "While loading manifest from: " + jarBeingOpened, null, null, null);
                }
                throw e;
            }
        }
    }

    private void findPatches(String codeNameBase) {
        File patchdir = new File(new File(this.jar.getParentFile(), "patches"), codeNameBase.replace('.', '-'));
        this.scanForPatches(patchdir);
        String patchesClassPath = System.getProperty("netbeans.patches." + this.getCodeNameBase());
        if (patchesClassPath != null) {
            StringTokenizer tokenizer = new StringTokenizer(patchesClassPath, File.pathSeparator);
            while (tokenizer.hasMoreElements()) {
                String element = (String)tokenizer.nextElement();
                File fileElement = new File(element);
                if (!fileElement.exists()) continue;
                if (this.patches == null) {
                    this.patches = new HashSet(15);
                }
                this.patches.add(fileElement);
            }
        }
        if (this.patches != null) {
            Iterator it = this.patches.iterator();
            while (it.hasNext()) {
                this.events.log("patch", it.next());
            }
        }
    }

    private void findExtensionsAndVariants(Manifest m) {
        if (!$assertionsDisabled && this.jar == null) {
            throw new AssertionError((Object)("Cannot load extensions from classpath module " + this.getCodeNameBase()));
        }
        this.localeVariants = null;
        List l = Util.findLocaleVariantsOf(this.jar, false);
        if (!l.isEmpty()) {
            this.localeVariants = new HashSet(l);
        }
        this.plainExtensions = null;
        this.localeExtensions = null;
        String classPath = m.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classPath != null) {
            StringTokenizer tok = new StringTokenizer(classPath);
            while (tok.hasMoreTokens()) {
                File extfile;
                String ext = tok.nextToken();
                if ((new File(ext).isAbsolute() || ext.indexOf("../") != -1) && !ext.equals("../lib/updater.jar")) {
                    Util.err.log(16, "WARNING: Class-Path value " + ext + " from " + this.jar + " is illegal according to the Java Extension Mechanism: must be relative and not move up directories");
                }
                if (!(extfile = new File(this.jar.getParentFile(), ext.replace('/', File.separatorChar))).exists()) {
                    Util.err.log(16, "Warning: Class-Path value " + ext + " from " + this.jar + " cannot be found at " + extfile);
                    continue;
                }
                HashSet<File> owners = (HashSet<File>)extensionOwners.get(extfile);
                if (owners == null) {
                    owners = new HashSet<File>(2);
                    owners.add(this.jar);
                    extensionOwners.put(extfile, owners);
                } else if (!owners.contains(this.jar)) {
                    owners.add(this.jar);
                    this.events.log("extensionMultiplyLoaded", extfile, owners);
                }
                if (moduleJARs.contains(extfile)) {
                    Util.err.log(16, "WARNING: Class-Path value " + ext + " from " + this.jar + " illegally refers to another module; use OpenIDE-Module-Module-Dependencies instead");
                }
                if (this.plainExtensions == null) {
                    this.plainExtensions = new HashSet();
                }
                this.plainExtensions.add(extfile);
                l = Util.findLocaleVariantsOf(extfile, false);
                if (l.isEmpty()) continue;
                if (this.localeExtensions == null) {
                    this.localeExtensions = new HashSet();
                }
                this.localeExtensions.addAll(l);
            }
        }
        Util.err.log("localeVariants of " + this.jar + ": " + this.localeVariants);
        Util.err.log("plainExtensions of " + this.jar + ": " + this.plainExtensions);
        Util.err.log("localeExtensions of " + this.jar + ": " + this.localeExtensions);
        Util.err.log("patches of " + this.jar + ": " + this.patches);
        if (this.patches != null) {
            Iterator it = this.patches.iterator();
            while (it.hasNext()) {
                this.events.log("patch", it.next());
            }
        }
    }

    private void scanForPatches(File patchdir) {
        if (!patchdir.isDirectory()) {
            return;
        }
        File[] jars = patchdir.listFiles(Util.jarFilter());
        if (jars != null) {
            for (int j = 0; j < jars.length; ++j) {
                if (this.patches == null) {
                    this.patches = new HashSet(5);
                }
                this.patches.add(jars[j]);
            }
        } else {
            Util.err.log(16, "Could not search for patches in " + patchdir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalizedProps(JarFile jarFile, Manifest m) throws IOException {
        String locbundle = m.getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
        if (locbundle != null) {
            String ext;
            String name;
            int idx;
            ZipEntry bundleFile = jarFile.getEntry(locbundle);
            if (bundleFile != null) {
                this.localizedProps = new Properties();
                InputStream is = jarFile.getInputStream(bundleFile);
                try {
                    this.localizedProps.load(is);
                }
                finally {
                    is.close();
                }
            }
            if ((idx = locbundle.lastIndexOf(46)) == -1) {
                name = locbundle;
                ext = "";
            } else {
                name = locbundle.substring(0, idx);
                ext = locbundle.substring(idx);
            }
            List pairs = Util.findLocaleVariantsOf(this.jar, true);
            Collections.reverse(pairs);
            Iterator it = pairs.iterator();
            while (it.hasNext()) {
                Object[] pair = (Object[])it.next();
                File localeJar = (File)pair[0];
                String suffix = (String)pair[1];
                String rsrc = name + suffix + ext;
                JarFile localeJarFile = new JarFile(localeJar, false);
                try {
                    ZipEntry bundleFile2 = localeJarFile.getEntry(rsrc);
                    if (bundleFile2 == null) continue;
                    if (this.localizedProps == null) {
                        this.localizedProps = new Properties();
                    }
                    InputStream is = localeJarFile.getInputStream(bundleFile2);
                    try {
                        this.localizedProps.load(is);
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    localeJarFile.close();
                }
            }
            if (this.localizedProps == null) {
                throw new IOException("Could not find localizing bundle: " + locbundle);
            }
        }
    }

    public List getAllJars() {
        ArrayList<File> l = new ArrayList<File>();
        if (this.patches != null) {
            l.addAll(this.patches);
        }
        if (this.physicalJar != null) {
            l.add(this.physicalJar);
        } else if (this.jar != null) {
            l.add(this.jar);
        }
        if (this.plainExtensions != null) {
            l.addAll(this.plainExtensions);
        }
        if (this.localeVariants != null) {
            l.addAll(this.localeVariants);
        }
        if (this.localeExtensions != null) {
            l.addAll(this.localeExtensions);
        }
        return l;
    }

    public void setReloadable(boolean r) {
        this.getManager().assertWritable();
        if (this.reloadable != r) {
            this.reloadable = r;
            this.getManager().fireReloadable(this);
        }
    }

    private Manifest findPatchedManifest() {
        if (this.patches != null) {
            Iterator itr = this.patches.iterator();
            while (itr.hasNext()) {
                File file = (File)itr.next();
                try {
                    Manifest m = this.loadPatchJarManifest(file);
                    Attributes patchAttr = m.getMainAttributes();
                    String str = patchAttr.getValue("OpenIDE-Module-Patch-Manifest");
                    if (str == null || !new Boolean(str).booleanValue()) continue;
                    return m;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public void reload() throws IOException {
        this.destroyPhysicalJar();
        String codeNameBase1 = this.getCodeNameBase();
        this.localizedProps = null;
        this.loadManifest();
        this.findPatches(this.calculateCodeNameBase(this.manifest));
        Manifest patchedManifest = null;
        patchedManifest = this.findPatchedManifest();
        if (patchedManifest != null) {
            this.manifest = patchedManifest;
        }
        this.parseManifest();
        this.findExtensionsAndVariants(this.manifest);
        String codeNameBase2 = this.getCodeNameBase();
        if (!codeNameBase1.equals(codeNameBase2)) {
            throw new InvalidException("Code name base changed during reload: " + codeNameBase1 + " -> " + codeNameBase2);
        }
    }

    protected void classLoaderUp(Set parents) throws IOException {
        File act;
        Util.err.log("classLoaderUp on " + (Object)((Object)this) + " with parents " + parents);
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>(parents.size() + 1);
        loaders.add(Module.class.getClassLoader());
        Iterator it = parents.iterator();
        while (it.hasNext()) {
            Module parent = (Module)((Object)it.next());
            Module.PackageExport[] exports = parent.getPublicPackages();
            if (exports != null && exports.length == 0) {
                Dependency[] deps = this.getDependenciesArray();
                boolean implDep = false;
                for (int i = 0; i < deps.length; ++i) {
                    if (deps[i].getType() != 1 || deps[i].getComparison() != 2 || !deps[i].getName().equals(parent.getCodeName())) continue;
                    implDep = true;
                    break;
                }
                if (!implDep) continue;
            }
            ClassLoader l = parent.getClassLoader();
            if (parent.isFixed() && loaders.contains(l)) {
                Util.err.log("#24996: skipping duplicate classloader from " + (Object)((Object)parent));
                continue;
            }
            loaders.add(l);
        }
        ArrayList<Object> classp = new ArrayList<Object>(3);
        if (this.patches != null) {
            it = this.patches.iterator();
            while (it.hasNext()) {
                File f = (File)it.next();
                if (f.isDirectory()) {
                    classp.add(f);
                    continue;
                }
                classp.add(new JarFile(f, false));
            }
        }
        if (this.reloadable) {
            this.ensurePhysicalJar();
            classp.add(new JarFile(this.physicalJar, false));
        } else {
            classp.add(new JarFile(this.jar, false));
        }
        if (this.localeVariants != null) {
            it = this.localeVariants.iterator();
            while (it.hasNext()) {
                classp.add(new JarFile((File)it.next(), false));
            }
        }
        if (this.localeExtensions != null) {
            it = this.localeExtensions.iterator();
            while (it.hasNext()) {
                act = (File)it.next();
                classp.add(act.isDirectory() ? act : new JarFile(act, false));
            }
        }
        if (this.plainExtensions != null) {
            it = this.plainExtensions.iterator();
            while (it.hasNext()) {
                act = (File)it.next();
                classp.add(act.isDirectory() ? act : new JarFile(act, false));
            }
        }
        this.getManager().refineClassLoader(this, loaders);
        try {
            this.classloader = new OneModuleClassLoader(classp, loaders.toArray(new ClassLoader[loaders.size()]));
        }
        catch (IllegalArgumentException iae) {
            IOException ioe = new IOException(iae.toString());
            Util.err.annotate((Throwable)ioe, (Throwable)iae);
            throw ioe;
        }
    }

    protected void classLoaderDown() {
        if (this.classloader instanceof ProxyClassLoader) {
            ((ProxyClassLoader)this.classloader).destroy();
        }
        this.classloader = null;
        Util.err.log("classLoaderDown on " + (Object)((Object)this) + ": releaseCount=" + this.releaseCount + " released=" + this.released);
        this.released = false;
    }

    protected void cleanup() {
        if (this.isEnabled()) {
            throw new IllegalStateException("cleanup on enabled module: " + (Object)((Object)this));
        }
        if (this.classloader != null) {
            throw new IllegalStateException("cleanup on module with classloader: " + (Object)((Object)this));
        }
        if (!this.released) {
            Util.err.log("Warning: not all resources associated with module " + this.jar + " were successfully released.");
            this.released = true;
        } else {
            Util.err.log("All resources associated with module " + this.jar + " were successfully released.");
        }
        this.destroyPhysicalJar();
    }

    public void destroy() {
        moduleJARs.remove(this.jar);
    }

    public String toString() {
        String s = "StandardModule:" + this.getCodeNameBase() + " jarFile: " + this.jar.getAbsolutePath();
        if (!this.isValid()) {
            s = s + "[invalid]";
        }
        return s;
    }

    private static synchronized PermissionCollection getAllPermission() {
        if (modulePermissions == null) {
            modulePermissions = new Permissions();
            modulePermissions.add(new AllPermission());
            modulePermissions.setReadOnly();
        }
        return modulePermissions;
    }

    static {
        $assertionsDisabled = !StandardModule.class.desiredAssertionStatus();
        extensionOwners = new HashMap();
        moduleJARs = new HashSet();
    }

    private class OneModuleClassLoader
    extends JarClassLoader
    implements Util.ModuleProvider,
    Util.PackageAccessibleClassLoader {
        private int rc;

        public OneModuleClassLoader(List classp, ClassLoader[] parents) throws IllegalArgumentException {
            super(classp, parents, false);
            this.rc = StandardModule.this.releaseCount++;
        }

        public Module getModule() {
            return StandardModule.this;
        }

        protected PermissionCollection getPermissions(CodeSource cs) {
            return StandardModule.getAllPermission();
        }

        protected String findLibrary(String libname) {
            String mapped = System.mapLibraryName(libname);
            File lib = new File(new File(StandardModule.this.jar.getParentFile(), "lib"), mapped);
            if (lib.isFile()) {
                return lib.getAbsolutePath();
            }
            return null;
        }

        protected boolean isSpecialResource(String pkg) {
            if (StandardModule.this.mgr.isSpecialResource(pkg)) {
                return true;
            }
            return super.isSpecialResource(pkg);
        }

        protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
            if (!super.shouldDelegateResource(pkg, parent)) {
                return false;
            }
            Module other = parent instanceof Util.ModuleProvider ? ((Util.ModuleProvider)((Object)parent)).getModule() : null;
            return StandardModule.this.getManager().shouldDelegateResource(StandardModule.this, other, pkg);
        }

        public String toString() {
            return super.toString() + "[" + StandardModule.this.getCodeNameBase() + "]";
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.log("Finalize for " + this + ": rc=" + this.rc + " releaseCount=" + StandardModule.this.releaseCount + " released=" + StandardModule.this.released);
            if (this.rc == StandardModule.this.releaseCount) {
                StandardModule.this.released = true;
            } else {
                Util.err.log("Now resources for " + StandardModule.this.getCodeNameBase() + " have been released.");
            }
        }
    }
}

