/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.openide.compiler.Compilable;
import org.openide.compiler.Compiler;

public final class DependencyException
extends Exception {
    private final Compilable[] array;

    DependencyException(Compilable[] compilableArray) {
        super(compilableArray.length + " compilers formed a cycle");
        this.array = compilableArray;
    }

    public Compilable[] getCompilables() {
        return this.array;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        printStream.println("Compiler cycle:");
        for (int i = 0; i < this.array.length; ++i) {
            Compilable compilable;
            printStream.println("\t" + DependencyException.info(this.array[i]));
            printStream.println("\t\tIncludes:\n");
            Iterator iterator = this.array[i].compilers().iterator();
            while (iterator.hasNext()) {
                compilable = (Compiler)iterator.next();
                printStream.println("\t\t\t" + DependencyException.info(compilable));
            }
            printStream.println("\t\tDepends on:\n");
            iterator = this.array[i].dependsOn().iterator();
            while (iterator.hasNext()) {
                compilable = (Compilable)iterator.next();
                printStream.println("\t\t\t" + DependencyException.info(compilable));
            }
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        printWriter.println("Compiler cycle:");
        for (int i = 0; i < this.array.length; ++i) {
            Compilable compilable;
            printWriter.println("\t" + DependencyException.info(this.array[i]));
            printWriter.println("\t\tIncludes:\n");
            Iterator iterator = this.array[i].compilers().iterator();
            while (iterator.hasNext()) {
                compilable = (Compiler)iterator.next();
                printWriter.println("\t\t\t" + DependencyException.info(compilable));
            }
            printWriter.println("\t\tDepends on:\n");
            iterator = this.array[i].dependsOn().iterator();
            while (iterator.hasNext()) {
                compilable = (Compilable)iterator.next();
                printWriter.println("\t\t\t" + DependencyException.info(compilable));
            }
        }
    }

    private static String info(Object object) {
        return object.toString() + " [class=" + object.getClass().getName() + ",id=" + System.identityHashCode(object) + ",hash=" + object.hashCode() + "]";
    }
}

