/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointEvent;
import com.hp.openvms.netbeans.debugsupport.event.RemoteBreakpointListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;

public abstract class RemoteBreakpoint
extends Breakpoint {
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final String PROP_BREAKPOINT_STATE = "breakpointState";
    public static final int MIN_GDB_ID = 500;
    public static final int UNVALIDATED = 0;
    public static final int VALIDATION_PENDING = 1;
    public static final int VALIDATED = 2;
    public static final int DELETION_PENDING = 3;
    public Object annotation = null;
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend = 0;
    private int breakpointNumber;
    private String printText;
    private HashSet breakpointListeners = new HashSet();
    private int state = 0;
    private static Map pending;
    private static Map bplist;
    private RemoteDebugger debugger;
    private Object LOCK = new Object();
    private int id;
    private static int nextid;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setID() {
        Object object = this.LOCK;
        synchronized (object) {
            this.id = ++nextid;
        }
    }

    public int getID() {
        return this.id;
    }

    public static RemoteBreakpoint get(String string) {
        return (RemoteBreakpoint)((Object)bplist.get(string));
    }

    public static RemoteBreakpoint getPending(int n) {
        return (RemoteBreakpoint)((Object)pending.get(n));
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        if (n != this.state && (n == 0 || n == 1 || n == 2 || n == 3)) {
            this.state = n;
            if (n == 0) {
                this.breakpointNumber = -1;
            }
        }
    }

    public void setPending() {
        this.setState(1);
        pending.put(this.id, this);
    }

    public void setValidationResult(int n, String string) {
        if (!$assertionsDisabled && n != this.getID()) {
            throw new AssertionError();
        }
        if (string != null) {
            this.breakpointNumber = Integer.parseInt(string);
            this.setState(2);
            if (!this.isEnabled()) {
                this.debugger.break_disable(this.breakpointNumber);
            }
        } else {
            this.setState(0);
        }
        bplist.put(string, this);
        pending.remove(n);
        if (pending.size() == 0 && this.debugger.getState() == "state_loading") {
            this.debugger.setRunning();
        }
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int n) {
        if (n == this.suspend) {
            return;
        }
        int n2 = this.suspend;
        this.suspend = n;
        this.firePropertyChange(PROP_SUSPEND, new Integer(n2), new Integer(n));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        if (bl == this.hidden) {
            return;
        }
        boolean bl2 = this.hidden;
        this.hidden = bl;
        this.firePropertyChange(PROP_HIDDEN, bl2, bl);
    }

    public int getBreakpointNumber() {
        return this.breakpointNumber;
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String string) {
        if (this.printText == string) {
            return;
        }
        String string2 = this.printText;
        this.printText = string;
        this.firePropertyChange(PROP_PRINT_TEXT, string2, string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public synchronized void addRemoteBreakpointListener(RemoteBreakpointListener remoteBreakpointListener) {
        this.breakpointListeners.add(remoteBreakpointListener);
    }

    public synchronized void removeRemoteBreakpointListener(RemoteBreakpointListener remoteBreakpointListener) {
        this.breakpointListeners.remove(remoteBreakpointListener);
    }

    public void fireRemoteBreakpointChange(RemoteBreakpointEvent remoteBreakpointEvent) {
        Iterator iterator = ((HashSet)this.breakpointListeners.clone()).iterator();
        while (iterator.hasNext()) {
            ((RemoteBreakpointListener)iterator.next()).breakpointReached(remoteBreakpointEvent);
        }
    }

    protected void setDebugger(RemoteDebugger remoteDebugger) {
        this.debugger = remoteDebugger;
    }

    public RemoteDebugger getDebugger() {
        return this.debugger;
    }

    static {
        $assertionsDisabled = !RemoteBreakpoint.class.desiredAssertionStatus();
        pending = Collections.synchronizedMap(new HashMap());
        bplist = Collections.synchronizedMap(new HashMap());
        nextid = 500;
    }
}

