/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointImpl;
import com.hp.openvms.netbeans.debugsupport.breakpoints.BreakpointsReader;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import com.hp.openvms.netbeans.utils.FileUtilityLang;
import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.distributed.rmi.protocol.debug.DebugInfo;
import org.netbeans.modules.distributed.rmi.protocol.debug.LookupLinePacket;
import org.netbeans.modules.distributed.rmi.protocol.debug.SourceDisplayInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class LineBreakpointImpl
extends BreakpointImpl {
    private LineBreakpoint breakpoint;
    private int lineNumber;
    private BreakpointsReader reader;
    private boolean writeToCache;

    public LineBreakpointImpl(LineBreakpoint lineBreakpoint, BreakpointsReader breakpointsReader, RemoteDebugger remoteDebugger, Session session, boolean bl) {
        super(lineBreakpoint, breakpointsReader, remoteDebugger, session);
        this.reader = breakpointsReader;
        this.breakpoint = lineBreakpoint;
        this.writeToCache = bl;
        this.lineNumber = lineBreakpoint.getLineNumber();
        this.set();
    }

    public LineBreakpointImpl(LineBreakpoint lineBreakpoint, BreakpointsReader breakpointsReader, RemoteDebugger remoteDebugger, Session session) {
        super(lineBreakpoint, breakpointsReader, remoteDebugger, session);
        this.reader = breakpointsReader;
        this.breakpoint = lineBreakpoint;
        this.writeToCache = false;
        this.lineNumber = lineBreakpoint.getLineNumber();
        this.set();
    }

    void fixed() {
        this.lineNumber = this.breakpoint.getLineNumber();
        super.fixed();
    }

    public boolean getWriteToCache() {
        return this.writeToCache;
    }

    public void setWriteToCache(boolean bl) {
        this.writeToCache = bl;
    }

    private SourceDisplayInfo prepareSourceDisplayInfo() throws Exception {
        FileObject fileObject;
        this.lineNumber = this.breakpoint.getLineNumber();
        String string = this.breakpoint.getURL();
        if (this.breakpoint.getVmsFilePath() == null) {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
            File file = FileUtil.toFile((FileObject)fileObject);
            String string2 = FileUtilityLang._winPathToOpenVMSPath(file.getAbsolutePath(), false, fileObject);
            this.breakpoint.setVmsFilePath(string2);
        }
        fileObject = new SourceDisplayInfo(this.breakpoint.getVmsFilePath(), this.breakpoint.getLineNumber(), this.breakpoint.getLookupLinePacket() == null ? -1 : this.breakpoint.getLookupLinePacket().getLine());
        return fileObject;
    }

    protected void setRequests() {
        try {
            if (this.breakpoint.getState() == 0) {
                if (this.breakpoint.isEnabled()) {
                    SourceDisplayInfo sourceDisplayInfo = this.prepareSourceDisplayInfo();
                    if (this.writeToCache) {
                        this.getDebugger().breakpointInsertCache(sourceDisplayInfo);
                    } else {
                        DebugInfo debugInfo = this.getDebugger().breakpointInsert(sourceDisplayInfo);
                        this.breakpoint.setLookupLinePacket((LookupLinePacket)debugInfo.getLookupLinePackets().get(0));
                    }
                } else if (this.writeToCache) {
                    this.getDebugger().breakpointInsertCache(null);
                }
                this.breakpoint.setPending();
            } else if (this.breakpoint.getState() != 3) {
                if (this.breakpoint.isEnabled()) {
                    SourceDisplayInfo sourceDisplayInfo = this.prepareSourceDisplayInfo();
                    DebugInfo debugInfo = this.getDebugger().breakpointInsert(sourceDisplayInfo);
                    this.breakpoint.setLookupLinePacket((LookupLinePacket)debugInfo.getLookupLinePackets().get(0));
                } else if (this.breakpoint.getLookupLinePacket() != null) {
                    this.getDebugger().breakpointRemove(this.breakpoint.getLookupLinePacket());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String normalize(String string) {
        Pattern pattern = Pattern.compile("(/|\\A)\\./");
        Pattern pattern2 = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$1");
            matcher = pattern.matcher(string);
        }
        matcher = pattern2.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).equals("..")) continue;
            string = string.substring(0, matcher.start()) + matcher.group(1) + string.substring(matcher.end());
            matcher = pattern2.matcher(string);
        }
        return string;
    }
}

