/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.editor.cobol;

import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerType;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.CTokenContext;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.CobolFormatSupport;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.IndentInfo;
import com.hp.openvms.netbeans.cobolsupport.editor.cobol.StringLexerInput;
import com.hp.openvms.netbeans.cobolsupport.editor.lang.CobolLanguage;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Lexer;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.openide.compiler.CompilerType;

public class CobolFormatter
extends ExtFormatter {
    static /* synthetic */ Class class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType;

    public CobolFormatter(Class clazz) {
        super(clazz);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof PlainSyntax;
    }

    public int[] getReformatBlock(JTextComponent jTextComponent, String string) {
        int[] nArray = null;
        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
        int n = jTextComponent.getCaret().getDot();
        if (baseDocument != null) {
            if ("e".equals(string) | "E".equals(string)) {
                try {
                    int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                    if (n2 >= 0 && n2 + 4 == n && "else".equals(baseDocument.getText(n2, 4)) | "ELSE".equals(baseDocument.getText(n2, 4))) {
                        nArray = new int[]{n2, n2 + 4};
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else if ("f".equals(string) | "F".equals(string)) {
                try {
                    int n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                    if ("end-if".equals(baseDocument.getText(n3, 6)) | "END-IF".equals(baseDocument.getText(n3, 6))) {
                        nArray = new int[]{n3, n};
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else if ("n".equals(string) | "N".equals(string)) {
                try {
                    int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                    if ("then".equals(baseDocument.getText(n4, 4)) | "THEN".equals(baseDocument.getText(n4, 4))) {
                        nArray = new int[]{n4, n};
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return nArray;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
        this.addFormatLayer((FormatLayer)new CobolLayer());
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new CobolFormatSupport(formatWriter);
    }

    public class CobolLayer
    extends AbstractFormatLayer {
        public int initialIndentation;
        public boolean procDiv;

        public CobolLayer() {
            super("cobol-layer");
            this.procDiv = false;
            this.initialIndentation = 0;
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new CobolFormatSupport(formatWriter);
        }

        public TokenContextPath getTokenContextPath() {
            return CTokenContext.contextPath;
        }

        public TokenID getWhitespaceTokenID() {
            return CTokenContext.WHITESPACE;
        }

        public TokenContextPath getWhitespaceTokenContextPath() {
            return this.getTokenContextPath();
        }

        public void insertWhiteSpace(FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, int n) {
            if (formatTokenPosition.getToken() != null) {
                for (int i = 0; i < n; ++i) {
                    formatWriter.insertString(formatTokenPosition.getToken(), 0, " ");
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    formatWriter.insertToken(null, null, null, " ");
                }
            }
        }

        public boolean isWhiteSpace(FormatTokenPosition formatTokenPosition) {
            CobolLanguage cobolLanguage = CobolLanguage.get();
            StringLexerInput stringLexerInput = new StringLexerInput(formatTokenPosition.getToken().getImage());
            Lexer lexer = cobolLanguage.createLexer();
            lexer.restart((LexerInput)stringLexerInput, null);
            Token token = lexer.nextToken();
            return token.getId().getIntId() == 2;
        }

        public TokenItem findLineStartToken(TokenItem tokenItem, CobolFormatSupport cobolFormatSupport) {
            if (tokenItem != null) {
                FormatTokenPosition formatTokenPosition = cobolFormatSupport.getPosition(tokenItem, 0);
                formatTokenPosition = cobolFormatSupport.findLineStart(formatTokenPosition);
                tokenItem = formatTokenPosition.getToken();
                while (tokenItem.getTokenID() == CTokenContext.WHITESPACE) {
                    tokenItem = tokenItem.getNext();
                }
            }
            return tokenItem;
        }

        public boolean isAnsiFormatLabel(TokenItem tokenItem, CobolFormatSupport cobolFormatSupport) {
            FormatTokenPosition formatTokenPosition;
            return tokenItem != null && cobolFormatSupport.isAnsiFormat() && tokenItem.getTokenID() == CTokenContext.NUM_LITERAL_INT && cobolFormatSupport.getVisualColumnOffset(formatTokenPosition = cobolFormatSupport.getPosition(tokenItem, 0)) + tokenItem.getImage().length() <= 6;
        }

        public void createAnsiFormatedLine(FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            if (formatTokenPosition != null) {
                TokenItem tokenItem = null;
                if (cobolFormatSupport.getVisualColumnOffset(formatTokenPosition) < 7) {
                    String string;
                    String string2 = string = formatTokenPosition.getToken().getImage();
                    if (string.length() >= 6) {
                        string2 = string.substring(0, 6);
                    }
                    if (string2.trim().length() >= 1) {
                        try {
                            int n = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            for (int i = 0; i < 7; ++i) {
                                formatWriter.insertString(formatTokenPosition.getToken(), 0, " ");
                            }
                            formatTokenPosition = cobolFormatSupport.findLineFirstNonWhitespace(formatTokenPosition);
                            return;
                        }
                        tokenItem = cobolFormatSupport.splitStart(formatTokenPosition.getToken(), 6, (TokenID)CTokenContext.NUM_LITERAL_INT, this.getTokenContextPath());
                    }
                    if (tokenItem != null) {
                        TokenItem tokenItem2 = tokenItem.getNext();
                        if (cobolFormatSupport.getVisualColumnOffset(cobolFormatSupport.getPosition(tokenItem2, 0)) == 7 && tokenItem2.getImage().length() >= 1 && tokenItem2.getImage().substring(0, 1) != " ") {
                            String string3 = tokenItem2.getImage().substring(0, 1);
                            TokenItem tokenItem3 = cobolFormatSupport.splitStart(tokenItem2, 1, (TokenID)new BaseTokenID(string3), this.getTokenContextPath());
                            tokenItem2 = tokenItem3.getNext();
                        }
                        formatTokenPosition = cobolFormatSupport.getPosition(tokenItem2, 0);
                    }
                } else if (cobolFormatSupport.getVisualColumnOffset(formatTokenPosition) == 7 && !cobolFormatSupport.isComment(formatTokenPosition)) {
                    this.insertWhiteSpace(formatWriter, formatTokenPosition, 7);
                }
            }
        }

        public void removeFirstTabFromLine(FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            FormatTokenPosition formatTokenPosition2 = formatTokenPosition;
            FormatTokenPosition formatTokenPosition3 = formatTokenPosition;
            if (formatTokenPosition2 != null) {
                while (formatTokenPosition2 != null && formatTokenPosition2.getToken() != null && formatTokenPosition2.getToken().getImage() != null && formatTokenPosition2.getToken().getImage().charAt(0) != '\n') {
                    formatTokenPosition3 = formatTokenPosition2;
                    if ((formatTokenPosition2 = cobolFormatSupport.getPreviousPosition(formatTokenPosition2)) != null) continue;
                }
                if ((formatTokenPosition2 = formatTokenPosition3) != null && formatTokenPosition2.getToken() != null && formatTokenPosition2.getToken().getImage() != null && formatTokenPosition2.getToken().getImage().charAt(0) != '\n') {
                    formatTokenPosition3 = formatTokenPosition2;
                    String string = formatTokenPosition3.getToken().getImage();
                    while (string.indexOf(9) != -1) {
                        int n = string.indexOf(9);
                        string = string.substring(0, n) + string.substring(string.indexOf(9) + 1, string.length());
                        formatWriter.remove(formatTokenPosition2.getToken(), n, 1);
                        for (int i = 0; i < cobolFormatSupport.getSpacesPerTab(); ++i) {
                            string = string.substring(0, n) + " " + string.substring(n, string.length());
                            formatWriter.insertString(formatTokenPosition3.getToken(), n, " ");
                        }
                    }
                }
            }
        }

        public void removeWhiteSpace(FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, int n) {
            CobolLanguage cobolLanguage = CobolLanguage.get();
            StringLexerInput stringLexerInput = new StringLexerInput(formatTokenPosition.getToken().getImage());
            Lexer lexer = cobolLanguage.createLexer();
            lexer.restart((LexerInput)stringLexerInput, null);
            Token token = lexer.nextToken();
            if (token != null && token.getId().getIntId() == 2) {
                for (int i = 0; i < n; ++i) {
                    formatWriter.remove(formatTokenPosition.getToken(), 0, 1);
                }
            }
        }

        public void AdjustCursor(FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, IndentInfo indentInfo, int n) {
            this.insertWhiteSpace(formatWriter, formatTokenPosition, n);
        }

        public int findInlineSpacing(TokenItem tokenItem, CobolFormatSupport cobolFormatSupport) {
            int n = 0;
            TokenItem tokenItem2 = this.findLineStartToken(tokenItem, cobolFormatSupport);
            if (this.isAnsiFormatLabel(tokenItem2, cobolFormatSupport)) {
                n = 6 - tokenItem.getImage().length();
                tokenItem2 = tokenItem2.getNext();
            }
            TokenItem tokenItem3 = cobolFormatSupport.findImportantToken(tokenItem, null, true);
            for (tokenItem2 = this.findLineStartToken(tokenItem3, cobolFormatSupport); tokenItem2 != null && (this.isAnsiFormatLabel(tokenItem2, cobolFormatSupport) || tokenItem2.getTokenID() == CTokenContext.WHITESPACE); tokenItem2 = tokenItem2.getNext()) {
            }
            FormatTokenPosition formatTokenPosition = cobolFormatSupport.getPosition(tokenItem2, 0);
            return Math.max(7, cobolFormatSupport.getVisualColumnOffset(formatTokenPosition) + n);
        }

        public void IndentLine(CobolFormatSupport cobolFormatSupport, FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, IndentInfo indentInfo, int n) {
            FormatTokenPosition formatTokenPosition2 = cobolFormatSupport.findLineFirstNonWhitespace(formatTokenPosition);
            int n2 = indentInfo.getIndent();
            if (formatTokenPosition2 != null) {
                int n3;
                if (this.isAnsiFormatLabel(formatTokenPosition2.getToken(), cobolFormatSupport)) {
                    TokenItem tokenItem = formatTokenPosition2.getToken().getNext();
                    while (tokenItem.getTokenID() == this.getWhitespaceTokenID()) {
                        TokenItem tokenItem2 = tokenItem.getNext();
                        cobolFormatSupport.removeToken(tokenItem);
                        tokenItem = tokenItem2;
                    }
                    n = this.findInlineSpacing(formatTokenPosition2.getToken(), cobolFormatSupport);
                    for (n3 = 0; n3 < n - 6; ++n3) {
                        cobolFormatSupport.insertToken(tokenItem, cobolFormatSupport.getValidWhitespaceTokenID(), cobolFormatSupport.getValidWhitespaceTokenContextPath(), " ");
                    }
                    n = 1;
                    n2 = 1;
                }
                boolean bl = true;
                if (n != n2) {
                    if (n > n2) {
                        n3 = n - n2;
                        if (cobolFormatSupport.isAnsiFormat()) {
                            int n4;
                            FormatTokenPosition formatTokenPosition3 = formatTokenPosition2;
                            for (n4 = 0; n4 < 7 && formatTokenPosition3.getToken().getImage() == " "; ++n4) {
                                formatTokenPosition3 = cobolFormatSupport.getNextPosition(formatTokenPosition3);
                            }
                            n3 = n3 + n4 - 7;
                            this.insertWhiteSpace(formatWriter, formatTokenPosition3, n3);
                        } else {
                            this.insertWhiteSpace(formatWriter, formatTokenPosition2, n3);
                        }
                    } else {
                        n3 = n2 - n;
                        if (bl) {
                            this.removeWhiteSpace(formatWriter, formatTokenPosition, n3);
                        }
                    }
                }
            }
        }

        public void IndentLineUnderProcDiv(CobolFormatSupport cobolFormatSupport, FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, IndentInfo indentInfo, int n) {
            FormatTokenPosition formatTokenPosition2 = formatTokenPosition;
            if (cobolFormatSupport.isEndingWithPeriod(formatTokenPosition2)) {
                int n2 = cobolFormatSupport.getVisualColumnOffset(formatTokenPosition2);
                String string = formatTokenPosition.getToken().getImage();
                if ((string = string.substring(n2, string.length())).indexOf(" ") == -1) {
                    if (!cobolFormatSupport.isReservedWord(formatTokenPosition)) {
                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getFormattedIndentPosition());
                    }
                    return;
                }
                this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, n);
            }
        }

        public FormatTokenPosition FindMostRecentIFStatement(FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            FormatTokenPosition formatTokenPosition2 = cobolFormatSupport.getInitialPosition(formatTokenPosition);
            while (true) {
                FormatTokenPosition formatTokenPosition3;
                if ((formatTokenPosition3 = cobolFormatSupport.getPreviousNonEmptyLine(formatTokenPosition)) == null) {
                    formatTokenPosition = formatTokenPosition2;
                    break;
                }
                if (cobolFormatSupport.isIFStatement(formatTokenPosition3)) {
                    FormatTokenPosition formatTokenPosition4;
                    formatTokenPosition = formatTokenPosition4 = cobolFormatSupport.getInitialPosition(formatTokenPosition3);
                    break;
                }
                formatTokenPosition = formatTokenPosition3;
            }
            return formatTokenPosition;
        }

        public FormatTokenPosition FindMostRecentStatementWithPeriod(FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            FormatTokenPosition formatTokenPosition2 = cobolFormatSupport.getInitialPosition(formatTokenPosition);
            while (true) {
                FormatTokenPosition formatTokenPosition3;
                if ((formatTokenPosition3 = cobolFormatSupport.getPreviousNonEmptyLine(formatTokenPosition)) == null) {
                    formatTokenPosition = null;
                    break;
                }
                if (cobolFormatSupport.isEndingWithPeriod(formatTokenPosition3)) {
                    FormatTokenPosition formatTokenPosition4;
                    formatTokenPosition = formatTokenPosition4 = cobolFormatSupport.getInitialPosition(formatTokenPosition3);
                    break;
                }
                formatTokenPosition = formatTokenPosition3;
            }
            return formatTokenPosition;
        }

        public FormatTokenPosition FindMostRecentStatementInAreaA(FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            FormatTokenPosition formatTokenPosition2 = cobolFormatSupport.getInitialPosition(formatTokenPosition);
            while (true) {
                FormatTokenPosition formatTokenPosition3;
                if ((formatTokenPosition3 = cobolFormatSupport.getPreviousNonEmptyLine(formatTokenPosition)) == null) {
                    formatTokenPosition = null;
                    break;
                }
                if (cobolFormatSupport.isInAreaA(formatTokenPosition3)) {
                    FormatTokenPosition formatTokenPosition4;
                    formatTokenPosition = formatTokenPosition4 = cobolFormatSupport.getInitialPosition(formatTokenPosition3);
                    break;
                }
                formatTokenPosition = formatTokenPosition3;
            }
            return formatTokenPosition;
        }

        public boolean IsIfStatementClosed(FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            FormatTokenPosition formatTokenPosition2 = cobolFormatSupport.getInitialPosition(formatTokenPosition);
            boolean bl = false;
            boolean bl2 = false;
            while (true) {
                FormatTokenPosition formatTokenPosition3;
                if ((formatTokenPosition3 = cobolFormatSupport.getNextNonEmptyLine(formatTokenPosition)) == null) {
                    formatTokenPosition = formatTokenPosition2;
                    break;
                }
                if (cobolFormatSupport.isENDIFStatement(formatTokenPosition3)) {
                    bl = true;
                    break;
                }
                if (cobolFormatSupport.isIFStatement(formatTokenPosition3)) break;
                formatTokenPosition = formatTokenPosition3;
            }
            return bl;
        }

        public FormatTokenPosition FindCorrespondingIFStatement(FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            FormatTokenPosition formatTokenPosition2 = cobolFormatSupport.getInitialPosition(formatTokenPosition);
            int n = 0;
            while (true) {
                FormatTokenPosition formatTokenPosition3;
                if ((formatTokenPosition3 = cobolFormatSupport.getPreviousNonEmptyLine(formatTokenPosition)) == null) {
                    formatTokenPosition = formatTokenPosition2;
                    break;
                }
                if (cobolFormatSupport.isENDIFStatement(formatTokenPosition3)) {
                    ++n;
                } else if (cobolFormatSupport.isIFStatement(formatTokenPosition3)) {
                    FormatTokenPosition formatTokenPosition4 = cobolFormatSupport.getInitialPosition(formatTokenPosition3);
                    for (int i = 0; i < n; ++i) {
                        formatTokenPosition4 = this.FindMostRecentIFStatement(formatTokenPosition4, cobolFormatSupport);
                        while (this.IsIfStatementClosed(formatTokenPosition4, cobolFormatSupport)) {
                            formatTokenPosition4 = this.FindMostRecentIFStatement(formatTokenPosition4, cobolFormatSupport);
                        }
                    }
                    formatTokenPosition = formatTokenPosition4;
                    break;
                }
                formatTokenPosition = formatTokenPosition3;
            }
            return formatTokenPosition;
        }

        public boolean isUnderProcedureDivision(FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            if (this.procDiv) {
                return true;
            }
            FormatTokenPosition formatTokenPosition2 = cobolFormatSupport.getInitialPosition(formatTokenPosition);
            boolean bl = true;
            while (true) {
                FormatTokenPosition formatTokenPosition3;
                if ((formatTokenPosition3 = cobolFormatSupport.getPreviousNonEmptyLine(formatTokenPosition)) == null) {
                    bl = false;
                    break;
                }
                if (cobolFormatSupport.isProcedureDivision(formatTokenPosition3)) {
                    bl = true;
                    break;
                }
                formatTokenPosition = formatTokenPosition3;
            }
            this.procDiv = bl;
            return bl;
        }

        public void formatCommentLine(FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            int n;
            int n2;
            if (formatTokenPosition != null && (n2 = cobolFormatSupport.getCommentPosition()) != (n = formatTokenPosition.getToken().getImage().indexOf(cobolFormatSupport.getCommentChar(formatTokenPosition)) + 1)) {
                if (n2 > n) {
                    FormatTokenPosition formatTokenPosition2 = cobolFormatSupport.getPosition(formatTokenPosition.getToken(), n - 1);
                    this.insertWhiteSpace(formatWriter, formatTokenPosition2, n2 - n);
                } else {
                    FormatTokenPosition formatTokenPosition3 = cobolFormatSupport.getPosition(formatTokenPosition.getToken(), n2 - 1);
                    this.removeWhiteSpace(formatWriter, formatTokenPosition3, n - n2);
                }
            }
        }

        public void formatLine(FormatWriter formatWriter, FormatTokenPosition formatTokenPosition, CobolFormatSupport cobolFormatSupport) {
            this.removeFirstTabFromLine(formatWriter, formatTokenPosition, cobolFormatSupport);
            if (cobolFormatSupport.findLineFirstNonWhitespace(formatTokenPosition) != null) {
                if (cobolFormatSupport.isAnsiFormat()) {
                    this.createAnsiFormatedLine(formatWriter, formatTokenPosition, cobolFormatSupport);
                }
                IndentInfo indentInfo = new IndentInfo();
                cobolFormatSupport.getIndentationInfo(formatTokenPosition, indentInfo);
                if (cobolFormatSupport.isENDIFStatement(formatTokenPosition)) {
                    FormatTokenPosition formatTokenPosition2 = this.FindCorrespondingIFStatement(formatTokenPosition, cobolFormatSupport);
                    this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition2));
                } else if (cobolFormatSupport.isELSEStatement(formatTokenPosition)) {
                    FormatTokenPosition formatTokenPosition3 = this.FindCorrespondingIFStatement(formatTokenPosition, cobolFormatSupport);
                    this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition3));
                } else if (cobolFormatSupport.isThenStatement(formatTokenPosition)) {
                    FormatTokenPosition formatTokenPosition4 = this.FindMostRecentIFStatement(formatTokenPosition, cobolFormatSupport);
                    this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition4));
                } else if (cobolFormatSupport.isInAreaA(formatTokenPosition)) {
                    FormatTokenPosition formatTokenPosition5 = this.FindMostRecentStatementInAreaA(formatTokenPosition, cobolFormatSupport);
                    if (formatTokenPosition5 == null) {
                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getFormattedIndentPosition());
                    } else {
                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition5));
                    }
                } else {
                    FormatTokenPosition formatTokenPosition6 = cobolFormatSupport.getPreviousNonEmptyLine(formatTokenPosition);
                    if (formatTokenPosition6 != null) {
                        FormatTokenPosition formatTokenPosition7 = cobolFormatSupport.getInitialPosition(formatTokenPosition6);
                        if (cobolFormatSupport.isEndingWithPeriod(formatTokenPosition7)) {
                            if (cobolFormatSupport.isInAreaA(formatTokenPosition7)) {
                                if (this.isUnderProcedureDivision(formatTokenPosition7, cobolFormatSupport)) {
                                    this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, 4 + cobolFormatSupport.getFormattedIndentPosition());
                                } else if (cobolFormatSupport.isReservedWord(formatTokenPosition7)) {
                                    if (!cobolFormatSupport.isReservedWord(formatTokenPosition)) {
                                        if (this.isUnderProcedureDivision(formatTokenPosition, cobolFormatSupport)) {
                                            this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition7));
                                        } else {
                                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getShiftWidth() + cobolFormatSupport.getIndent(formatTokenPosition7));
                                        }
                                    } else {
                                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition7));
                                    }
                                } else {
                                    this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition7));
                                }
                            } else {
                                FormatTokenPosition formatTokenPosition8 = this.FindMostRecentStatementWithPeriod(formatTokenPosition7, cobolFormatSupport);
                                if (formatTokenPosition8 != null) {
                                    FormatTokenPosition formatTokenPosition9 = cobolFormatSupport.getNextNonEmptyLine(formatTokenPosition8);
                                    if (cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition9)) != cobolFormatSupport.getFormattedIndentPosition()) {
                                        if (this.isUnderProcedureDivision(formatTokenPosition7, cobolFormatSupport) || this.isUnderProcedureDivision(formatTokenPosition, cobolFormatSupport)) {
                                            this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition9)));
                                        } else if (cobolFormatSupport.isReservedWord(formatTokenPosition)) {
                                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getFormattedIndentPosition());
                                        } else {
                                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition9)));
                                        }
                                    } else if (this.isUnderProcedureDivision(formatTokenPosition7, cobolFormatSupport) || this.isUnderProcedureDivision(formatTokenPosition, cobolFormatSupport)) {
                                        this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition8)));
                                    } else if (cobolFormatSupport.isReservedWord(formatTokenPosition)) {
                                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getFormattedIndentPosition());
                                    } else {
                                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition8)));
                                    }
                                } else if (cobolFormatSupport.isInAreaA(formatTokenPosition)) {
                                    this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getFormattedIndentPosition());
                                } else if (this.isUnderProcedureDivision(formatTokenPosition, cobolFormatSupport)) {
                                    this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, 4 + cobolFormatSupport.getFormattedIndentPosition());
                                } else {
                                    this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, 4 + cobolFormatSupport.getFormattedIndentPosition());
                                }
                            }
                        } else if (cobolFormatSupport.isIFStatement(formatTokenPosition7) | cobolFormatSupport.isELSEStatement(formatTokenPosition7) | cobolFormatSupport.isThenStatement(formatTokenPosition7)) {
                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition7) + cobolFormatSupport.getShiftWidth());
                        } else if (cobolFormatSupport.isENDIFStatement(formatTokenPosition7)) {
                            FormatTokenPosition formatTokenPosition10 = this.FindCorrespondingIFStatement(formatTokenPosition7, cobolFormatSupport);
                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition10));
                        } else if (formatTokenPosition7.getToken().getImage().indexOf(".") != -1) {
                            String string = formatTokenPosition7.getToken().getImage();
                            int n = string.indexOf(".");
                            int n2 = ++n;
                            while (string.length() > n && (string.charAt(n) == ' ' || string.charAt(n) == '\t')) {
                                if (string.charAt(++n - 1) == '\t') {
                                    n2 = n + cobolFormatSupport.getSpacesPerTab();
                                    continue;
                                }
                                n2 = n;
                            }
                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, n2);
                        } else if (formatTokenPosition7.getToken().getImage().toLowerCase().indexOf("select") != -1) {
                            int n;
                            String string = formatTokenPosition7.getToken().getImage().toLowerCase();
                            int n3 = string.indexOf("select");
                            int n4 = 0;
                            for (n = 0; n <= n3; ++n) {
                                if (string.charAt(n) != '\t') continue;
                                ++n4;
                            }
                            n = n3 + 1 + n4 * cobolFormatSupport.getSpacesPerTab();
                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, n += cobolFormatSupport.getShiftWidth());
                        } else if (cobolFormatSupport.isAnsiFormat()) {
                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition7));
                        } else if (cobolFormatSupport.getIndent(formatTokenPosition7) == 0) {
                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getShiftWidth());
                        } else {
                            this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition7));
                        }
                    } else {
                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getFormattedIndentPosition());
                    }
                }
            }
        }

        public void format(FormatWriter formatWriter) {
            block57: {
                try {
                    this.procDiv = false;
                    Document document = formatWriter.getDocument();
                    String string = Utilities.getLastActiveComponent().getSelectedText();
                    CobolFormatSupport cobolFormatSupport = (CobolFormatSupport)this.createFormatSupport(formatWriter);
                    FormatTokenPosition formatTokenPosition = cobolFormatSupport.getFormatStartPosition();
                    boolean bl = false;
                    if (cobolFormatSupport.isIndentOnly()) {
                        IndentInfo indentInfo = new IndentInfo();
                        cobolFormatSupport.getIndentationInfo(formatTokenPosition, indentInfo);
                        if (cobolFormatSupport.findLineFirstNonWhitespace(formatTokenPosition) != null) {
                            if (cobolFormatSupport.isENDIFStatement(formatTokenPosition)) {
                                FormatTokenPosition formatTokenPosition2 = this.FindCorrespondingIFStatement(formatTokenPosition, cobolFormatSupport);
                                this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition2));
                            } else if (cobolFormatSupport.isELSEStatement(formatTokenPosition)) {
                                FormatTokenPosition formatTokenPosition3 = this.FindCorrespondingIFStatement(formatTokenPosition, cobolFormatSupport);
                                this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition3));
                            } else if (cobolFormatSupport.isThenStatement(formatTokenPosition)) {
                                FormatTokenPosition formatTokenPosition4 = this.FindMostRecentIFStatement(formatTokenPosition, cobolFormatSupport);
                                this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition4));
                            } else {
                                FormatTokenPosition formatTokenPosition5 = cobolFormatSupport.getPreviousNonEmptyLine(formatTokenPosition);
                                if (formatTokenPosition5 != null) {
                                    FormatTokenPosition formatTokenPosition6 = cobolFormatSupport.getInitialPosition(formatTokenPosition5);
                                    if (cobolFormatSupport.isEndingWithPeriod(formatTokenPosition6)) {
                                        if (cobolFormatSupport.isInAreaA(formatTokenPosition6)) {
                                            if (this.isUnderProcedureDivision(formatTokenPosition6, cobolFormatSupport)) {
                                                this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, 4 + cobolFormatSupport.getFormattedIndentPosition());
                                            } else {
                                                this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition6));
                                            }
                                        } else {
                                            FormatTokenPosition formatTokenPosition7 = this.FindMostRecentStatementWithPeriod(formatTokenPosition6, cobolFormatSupport);
                                            if (formatTokenPosition7 != null) {
                                                FormatTokenPosition formatTokenPosition8 = cobolFormatSupport.getNextNonEmptyLine(formatTokenPosition7);
                                                if (cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition8)) != 0) {
                                                    if (this.isUnderProcedureDivision(formatTokenPosition6, cobolFormatSupport)) {
                                                        this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition8)));
                                                    } else {
                                                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition8)));
                                                    }
                                                } else if (this.isUnderProcedureDivision(formatTokenPosition6, cobolFormatSupport)) {
                                                    this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition7)));
                                                } else {
                                                    this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition7)));
                                                }
                                            } else if (cobolFormatSupport.isInAreaA(formatTokenPosition)) {
                                                this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getFormattedIndentPosition());
                                            } else if (this.isUnderProcedureDivision(formatTokenPosition, cobolFormatSupport)) {
                                                this.IndentLineUnderProcDiv(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, 4 + cobolFormatSupport.getFormattedIndentPosition());
                                            } else {
                                                this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, 4 + cobolFormatSupport.getFormattedIndentPosition());
                                            }
                                        }
                                    } else if (cobolFormatSupport.isIFStatement(formatTokenPosition6) | cobolFormatSupport.isELSEStatement(formatTokenPosition6) | cobolFormatSupport.isThenStatement(formatTokenPosition6)) {
                                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition6) + cobolFormatSupport.getShiftWidth());
                                    } else if (formatTokenPosition6.getToken().getImage().indexOf(".") != -1) {
                                        String string2 = formatTokenPosition6.getToken().getImage();
                                        int n = string2.indexOf(".");
                                        int n2 = ++n;
                                        while (string2.length() > n && (string2.charAt(n) == ' ' || string2.charAt(n) == '\t')) {
                                            if (string2.charAt(++n - 1) == '\t') {
                                                n2 = n + cobolFormatSupport.getSpacesPerTab();
                                                continue;
                                            }
                                            n2 = n;
                                        }
                                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, n2);
                                    } else if (formatTokenPosition6.getToken().getImage().toLowerCase().indexOf("select") != -1) {
                                        int n;
                                        String string3 = formatTokenPosition6.getToken().getImage().toLowerCase();
                                        int n3 = string3.indexOf("select");
                                        int n4 = 0;
                                        for (n = 0; n <= n3; ++n) {
                                            if (string3.charAt(n) != '\t') continue;
                                            ++n4;
                                        }
                                        n = n3 + 1 + n4 * cobolFormatSupport.getSpacesPerTab();
                                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, n += cobolFormatSupport.getShiftWidth());
                                    } else {
                                        this.IndentLine(cobolFormatSupport, formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition6));
                                    }
                                }
                            }
                        } else {
                            FormatTokenPosition formatTokenPosition9 = cobolFormatSupport.getPreviousNonEmptyLine(formatTokenPosition);
                            if (formatTokenPosition9 != null) {
                                FormatTokenPosition formatTokenPosition10 = cobolFormatSupport.getInitialPosition(formatTokenPosition9);
                                if (cobolFormatSupport.isEndingWithPeriod(formatTokenPosition10)) {
                                    if (cobolFormatSupport.isInAreaA(formatTokenPosition10)) {
                                        if (this.isUnderProcedureDivision(formatTokenPosition10, cobolFormatSupport)) {
                                            this.AdjustCursor(formatWriter, formatTokenPosition, indentInfo, 4 + cobolFormatSupport.getFormattedIndentPosition());
                                        } else {
                                            this.AdjustCursor(formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition10));
                                        }
                                    } else {
                                        FormatTokenPosition formatTokenPosition11 = this.FindMostRecentStatementWithPeriod(formatTokenPosition10, cobolFormatSupport);
                                        if (formatTokenPosition11 != null) {
                                            FormatTokenPosition formatTokenPosition12 = cobolFormatSupport.getNextNonEmptyLine(formatTokenPosition11);
                                            this.AdjustCursor(formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(cobolFormatSupport.getInitialPosition(formatTokenPosition12)));
                                        } else {
                                            this.AdjustCursor(formatWriter, formatTokenPosition, indentInfo, 4 + cobolFormatSupport.getFormattedIndentPosition());
                                        }
                                    }
                                } else if (cobolFormatSupport.isIFStatement(formatTokenPosition10) | cobolFormatSupport.isELSEStatement(formatTokenPosition10) | cobolFormatSupport.isThenStatement(formatTokenPosition10)) {
                                    this.AdjustCursor(formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition10) + cobolFormatSupport.getShiftWidth());
                                } else if (cobolFormatSupport.isENDIFStatement(formatTokenPosition10)) {
                                    FormatTokenPosition formatTokenPosition13 = this.FindCorrespondingIFStatement(formatTokenPosition10, cobolFormatSupport);
                                    this.AdjustCursor(formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition13));
                                } else {
                                    this.AdjustCursor(formatWriter, formatTokenPosition, indentInfo, cobolFormatSupport.getIndent(formatTokenPosition10));
                                }
                            }
                        }
                        break block57;
                    }
                    while (formatTokenPosition != null) {
                        if (!cobolFormatSupport.isComment(formatTokenPosition)) {
                            this.formatLine(formatWriter, formatTokenPosition, cobolFormatSupport);
                        } else {
                            this.formatCommentLine(formatWriter, formatTokenPosition, cobolFormatSupport);
                        }
                        CobolCompilerType cobolCompilerType = (CobolCompilerType)CompilerType.find((Class)(class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType == null ? CobolFormatter.class$("com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompilerType") : class$com$hp$openvms$netbeans$cobolsupport$cobol$CobolCompilerType));
                        FormatTokenPosition formatTokenPosition14 = cobolFormatSupport.findLineEnd(formatTokenPosition);
                        if (formatTokenPosition14 != null && formatTokenPosition14.getToken() != null && (formatTokenPosition = cobolFormatSupport.getNextPosition(formatTokenPosition14, Position.Bias.Forward)) != formatTokenPosition14 && formatTokenPosition != null && formatTokenPosition.getToken() != null) {
                            FormatTokenPosition formatTokenPosition15 = cobolFormatSupport.findLineFirstNonWhitespace(formatTokenPosition);
                            if (formatTokenPosition15 != null) {
                                formatTokenPosition = formatTokenPosition15;
                                continue;
                            }
                            formatTokenPosition = cobolFormatSupport.findLineStart(formatTokenPosition);
                            continue;
                        }
                        break;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("cobol-strip-whitespace-at-line-end");
        }

        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new CobolFormatSupport(formatWriter);
        }

        public void format(FormatWriter formatWriter) {
            Document document = formatWriter.getDocument();
            CobolFormatSupport cobolFormatSupport = (CobolFormatSupport)this.createFormatSupport(formatWriter);
            FormatTokenPosition formatTokenPosition = cobolFormatSupport.getFormatStartPosition();
            if (!cobolFormatSupport.isIndentOnly()) {
                while (formatTokenPosition.getToken() != null) {
                    if ((formatTokenPosition = cobolFormatSupport.removeLineEndWhitespace(formatTokenPosition)).getToken() == null) continue;
                    formatTokenPosition = cobolFormatSupport.getNextPosition(formatTokenPosition);
                }
            }
        }
    }
}

