/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cobolsupport.cobol;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerType;
import com.hp.openvms.netbeans.baseclasses.compiler.BogusCompiler;
import com.hp.openvms.netbeans.cobolsupport.cobol.CobolCompiler;
import com.hp.openvms.netbeans.cobolsupport.cobol.datasys.CobolDataObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.util.Utils;
import org.openide.ErrorManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class CobolCompilerType
extends AlphaVMSCompilerType {
    public static final String PROP_ANSIFORMATTING = "ansiFormatting";
    private Boolean updated;
    private static ResourceBundle bundle;
    static final long serialVersionUID = 3952144683021797629L;

    public CobolCompilerType(FileObject fileObject) {
        super(fileObject);
        this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = this.project.getProjectDirectory();
        String string = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
        this.settingsMap = Utils.getCompilerSettingsFrom3GLXML((String)string, (String)"cobol");
    }

    public static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)CobolCompilerType.class);
        }
        return bundle.getString(string);
    }

    public Object getAnsiFormatting() {
        String string = (String)this.settingsMap.get("cobol_ansi");
        return string.equals("true") ? Boolean.TRUE : Boolean.FALSE;
    }

    public synchronized void setAnsiFormatting(Object object) {
        this.settingsMap.put("cobol_ansi", (Boolean)object != false ? "true" : "false");
    }

    public void prepareJob(CompilerJob compilerJob, Class clazz, DataObject dataObject) {
        if (dataObject instanceof CobolDataObject) {
            super.prepareJob(compilerJob, clazz, dataObject);
        } else {
            String string = MessageFormat.format(CobolCompilerType.getString("MSG_InvalidCompiler"), this.getName(), dataObject.getPrimaryFile().toString());
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)new IllegalArgumentException("Invalid compiler"), 256, null, string, null, null);
            BogusCompiler bogusCompiler = new BogusCompiler(dataObject.getPrimaryFile(), throwable);
            compilerJob.add((Compiler)bogusCompiler);
        }
    }

    protected Compiler createCompiler(Class clazz, FileObject fileObject) {
        return new CobolCompiler(clazz, fileObject, this.getExternalCompiler(), this.getErrorExpression(), this);
    }

    public void flushSettings() throws IOException {
        Utils.writeCompilerSettingto3GLXML((Project)this.project, (String)"cobol", (Map)this.settingsMap);
    }
}

