/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.baseclasses.compiler;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCleanCompiler;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteBuildCookie;
import org.netbeans.modules.distributed.common.cookies.RemoteCompileCookie;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.propertyeditor.RemoteFSFile;
import org.openide.compiler.Compilable;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerType;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public abstract class AlphaVMSCompilerType
extends ExternalCompilerType {
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_MAKEFILE_COMPILER = "makefileCompiler";
    public static final String PROP_BUILD_OPTION = "buildOption";
    public static final String PROP_EXTERNAL_COMPILER = "externalCompiler";
    public static final String PROP_BUILD_COMMAND = "buildCommand";
    public static final String PROP_CCPP_GLOBAL_QUALIFIER = "globalQualifier";
    public static final String PROP_CCPP_LOCAL_QUALIFIER = "localQualifier";
    public static final Object COMPILE = CompilerCookie.Compile.class;
    public static final Object BUILD = CompilerCookie.Build.class;
    public static final Object CLEAN = CompilerCookie.Clean.class;
    public static final Object REMOTE_COMPILE = RemoteCompileCookie.class;
    public static final Object REMOTE_BUILD = RemoteBuildCookie.class;
    public static final String ALPHA_VMS_ERROR_EXPR = "^(.*)\\n[ \\t]*[A|a]t line number ([0-9]+) in file (.*)$";
    public static final String PROP_ERROR_EXPRESSION = "errorExpression";
    private static ResourceBundle bundle;
    private static boolean modified;
    static final long serialVersionUID = 6452094368962892246L;
    protected FileObject fobj;
    protected Map settingsMap;
    protected Project project;
    public static ExternalCompiler.ErrorExpression errorExpression;

    public AlphaVMSCompilerType() {
    }

    public AlphaVMSCompilerType(FileObject fileObject) {
        this.fobj = fileObject;
    }

    public boolean getPropertyModified() {
        return modified;
    }

    public void setPropertyModified(boolean bl) {
        modified = bl;
    }

    public static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)AlphaVMSCompilerType.class);
        }
        return bundle.getString(string);
    }

    public void prepareJob(CompilerJob compilerJob, Class clazz, DataObject dataObject) {
        AlphaVMSCleanCompiler alphaVMSCleanCompiler;
        if (clazz.equals(CLEAN) || clazz.equals(BUILD) || clazz.equals(REMOTE_BUILD)) {
            alphaVMSCleanCompiler = new AlphaVMSCleanCompiler(dataObject);
            compilerJob.add((Compiler)alphaVMSCleanCompiler);
        } else {
            alphaVMSCleanCompiler = null;
        }
        if (clazz.equals(COMPILE) || clazz.equals(BUILD) || clazz.equals(REMOTE_COMPILE) || clazz.equals(REMOTE_BUILD)) {
            Compiler compiler = this.createCompiler(clazz, dataObject.getPrimaryFile());
            compilerJob.add(compiler);
            if (alphaVMSCleanCompiler != null) {
                compiler.dependsOn((Compilable)alphaVMSCleanCompiler);
            }
        } else if (alphaVMSCleanCompiler == null) {
            // empty if block
        }
    }

    protected abstract Compiler createCompiler(Class var1, FileObject var2);

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        String string = (String)this.settingsMap.get("error_exp_opt");
        String[] stringArray = string.split(" ");
        return new ExternalCompiler.ErrorExpression(NbBundle.getMessage((Class)AlphaVMSCompilerType.class, (String)"ALPHA_VMS_ERROR_FILTER"), (String)this.settingsMap.get("error_exp"), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    public void setErrorExpression(ExternalCompiler.ErrorExpression errorExpression) {
        this.settingsMap.put("error_exp", errorExpression.getErrorExpression());
        this.settingsMap.put("error_exp_opt", Integer.toString(errorExpression.getFilePos()) + " " + Integer.toString(errorExpression.getLinePos()) + " " + Integer.toString(errorExpression.getColumnPos()) + " " + Integer.toString(errorExpression.getDescriptionPos()));
    }

    public Boolean outputSwitch() {
        try {
            return ((AbstractNetworkFileSystem)this.fobj.getFileSystem()).getUseXtermCompile() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    public Integer xDisplayNumber() {
        try {
            return new Integer(((AbstractNetworkFileSystem)this.fobj.getFileSystem()).getXDisplayDeviceNumber());
        }
        catch (Exception exception) {
            return new Integer(0);
        }
    }

    public RemoteFSFile getBuildDirectory() {
        try {
            String string = (String)this.settingsMap.get("build_dir");
            RemoteFSFile remoteFSFile = (RemoteFSFile)Utils.deSerializeObj((String)string);
            if (string == null || string.trim().length() == 0 || remoteFSFile.getAbsolutePath().length() == 0) {
                return null;
            }
            return remoteFSFile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setBuildDirectory(RemoteFSFile remoteFSFile) {
        try {
            if (remoteFSFile != null && remoteFSFile.getAbsolutePath().equals("")) {
                remoteFSFile = null;
            }
            String string = Utils.serializeObj((Object)remoteFSFile);
            this.settingsMap.put("build_dir", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBuildCommand() {
        return (String)this.settingsMap.get("build_command");
    }

    public void setBuildCommand(String string) {
        this.settingsMap.put("build_command", string);
    }

    public NbProcessDescriptor getExternalCompiler() {
        return new NbProcessDescriptor((String)this.settingsMap.get("compile_command"), (String)this.settingsMap.get("compile_param"), AlphaVMSCompilerType.getAdditionalHint());
    }

    public void setExternalCompiler(NbProcessDescriptor nbProcessDescriptor) {
        this.settingsMap.put("compile_command", nbProcessDescriptor.getProcessName());
        this.settingsMap.put("compile_param", nbProcessDescriptor.getArguments());
    }

    public Object getBuildOption() {
        String string = (String)this.settingsMap.get("use_command_file");
        return string.equals("true") ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setBuildOption(Object object) {
        this.settingsMap.put("use_command_file", (Boolean)object != false ? "true" : "false");
    }

    public RemoteFSFile getMakefileCompiler() {
        String string = (String)this.settingsMap.get("command_file");
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            return (RemoteFSFile)Utils.deSerializeObj((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setMakefileCompiler(RemoteFSFile remoteFSFile) {
        try {
            String string = remoteFSFile != null && remoteFSFile.getAbsolutePath().equals("") ? "" : Utils.serializeObj((Object)remoteFSFile);
            this.settingsMap.put("command_file", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getGlobalQualifier() {
        return (String)this.settingsMap.get("global_qualifier");
    }

    public String getLocalQualifier() {
        return (String)this.settingsMap.get("local_qualifier");
    }

    public void setGlobalQualifier(String string) {
        this.settingsMap.put("global_qualifier", string);
    }

    public void setLocalQualifier(String string) {
        this.settingsMap.put("local_qualifier", string);
    }

    public static final String getAdditionalHint() {
        return "";
    }

    public String createDefaultBuildCommand() {
        return "@{command file} {file}";
    }

    static {
        errorExpression = new ExternalCompiler.ErrorExpression(NbBundle.getMessage((Class)AlphaVMSCompilerType.class, (String)"ALPHA_VMS_ERROR_FILTER"), ALPHA_VMS_ERROR_EXPR, 3, 2, -1, 1);
    }
}

