/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.settings;

import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;

public class DistributedSettings
extends SystemOption {
    static final long serialVersionUID = 5377810353790672705L;
    public String version = "1.0";
    public static final String PROP_REMOTE_RUNTIMES = "remoteRuntimes";
    public static final String PROP_TRUST_STORE = "trustStore";
    public static final String PROP_TRUST_STORE_PASSWORD = "trustStorePassword";
    public static final String PROP_USERNAME = "userName";
    public static final String PROP_PASSWD = "passwd";
    public static final String PROP_HOSTNAME = "hostName";
    public static final String PROP_PORT = "port";
    public static final String PROP_SAVEALL = "saveAll";
    public static final String PROP_TIME_OUT = "timeOut";
    public static final String PROP_XSVR = "xServer";
    public static final String PROP_JAVAHOME = "javaHome";
    public static final String PROP_JDKHOME = "JDKHome";
    public static final String PROP_USEX_COMPILE = "useXtermCompile";
    public static final String PROP_USEX_EXECUTION = "useXtermExecution";
    public static final String PROP_CONNECT_AT_STARTUP = "connectAtStartup";
    public static String JAVA_HOME_141_OVMS = "/SYS$COMMON/java$141/jre";
    public static String JDK_HOME_141_OVMS = "/SYS$COMMON/java$141";
    public static final String PROP_ASCII_EXT = "asciiExtensions";
    public static final String PROP_BINARY_EXT = "binaryExtensions";
    public static final String PROP_X_DISPLAY_NUMBER = "xDisplayNumber";
    public static final String PROP_SETUP_COMMAND = "setupCommand";
    public static final String PROP_SVR_TIMEOUT = "svrTimeOut";
    private HashMap remoteRuntimes = new HashMap(8);
    private static String trustStore;
    private static String trustStorePassword;
    private static int timeout;
    private static boolean saveAll;
    private static String userName;
    private static String hostName;
    private static char[] passwd;
    private static String port;
    private static String setupCommand;
    private static int svrTimeOut;
    private static String xServer;
    private static boolean useXtermCompile;
    private static boolean useXtermExecution;
    private static int xDisplayNumber;
    private static boolean connectAtStartup;
    private static File setupScript;
    private static Set remoteObjs;
    private static transient boolean firstTime;
    private transient Set listeners = new HashSet();

    private void initializeme() {
        this.setRemoteRuntimes(new HashSet());
        this.setUserName("");
        this.setHostName("");
        this.setPort("1099");
        this.setTrustStorePassword("_keystore");
        File file = InstalledFileLocator.getDefault().locate("distributed/_truststore", null, false);
        String string = null;
        if (file == null) {
            string = System.getProperty("netbeans.user") + File.separatorChar + "distributed" + File.separatorChar + "_truststore";
            file = new File(string);
        } else {
            string = file.getAbsolutePath();
        }
        this.setTrustStore(string);
        this.setSaveAll(true);
        this.setTimeOut(60000);
        this.setXServer("");
        this.setUseXtermCompile(false);
        this.setUseXtermExecution(false);
        remoteObjs = new HashSet();
        this.addToRemoteObjList(new String[]{"java"});
        this.setConnectAtStartup(true);
        this.setSvrTimeOut(120);
    }

    public DistributedSettings() {
        this.initializeme();
    }

    public String displayName() {
        return NbBundle.getMessage((Class)DistributedSettings.class, (String)"LBL_settings");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static void clearStringPasswords(DistributedSettings distributedSettings) {
        HashSet hashSet = distributedSettings.getRemoteRuntimes();
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)iterator.next();
                remoteRuntimeType.convertToCharPassword();
            }
            distributedSettings.setRemoteRuntimes(distributedSettings.getRemoteRuntimes());
        }
    }

    private static void startRemoteServers(final DistributedSettings distributedSettings) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                HashSet hashSet = distributedSettings.getRemoteRuntimes();
                if (hashSet != null) {
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)iterator.next();
                        if (!remoteRuntimeType.getConnectNow() || !remoteRuntimeType.isConnectAtStartup()) continue;
                        remoteRuntimeType.getRemoteRuntimeServerSafe();
                    }
                }
            }
        });
    }

    public static DistributedSettings getDefault() {
        DistributedSettings distributedSettings = (DistributedSettings)SharedClassObject.findObject((Class)DistributedSettings.class);
        if (distributedSettings == null) {
            distributedSettings = (DistributedSettings)SharedClassObject.findObject((Class)DistributedSettings.class, (boolean)true);
        }
        System.out.println("settings ref:" + ((Object)((Object)distributedSettings)).toString());
        String string = null;
        string = System.getProperty("java.rmi.server.hostname") != null ? System.getProperty("java.rmi.server.hostname") : Utils.getUsableInetAddress();
        if (string != null) {
            System.setProperty("java.rmi.server.hostname", string);
        }
        System.setProperty("javax.net.ssl.trustStore", distributedSettings.getTrustStore());
        System.setProperty("javax.net.ssl.trustStorePassword", distributedSettings.getTrustStorePassword());
        if (firstTime) {
            DistributedSettings.clearStringPasswords(distributedSettings);
            DistributedSettings.startRemoteServers(distributedSettings);
            Enumeration enumeration = Repository.getDefault().fileSystems();
            while (enumeration.hasMoreElements()) {
                Repository.getDefault().removeFileSystem((FileSystem)enumeration.nextElement());
            }
            firstTime = false;
        }
        return distributedSettings;
    }

    public String getTrustStore() {
        return trustStore;
    }

    public void setTrustStore(String string) {
        trustStore = string;
        this.firePropertyChange(PROP_TRUST_STORE, null, string);
        System.setProperty("javax.net.ssl.trustStore", trustStore);
    }

    public String getXServer() {
        return xServer;
    }

    public void setXServer(String string) {
        xServer = string;
        this.firePropertyChange(PROP_XSVR, null, string);
    }

    public boolean getSaveAll() {
        return saveAll;
    }

    public void setSaveAll(boolean bl) {
        saveAll = bl;
        this.firePropertyChange(PROP_SAVEALL, null, new Boolean(bl));
    }

    public int getTimeOut() {
        return timeout;
    }

    public void setTimeOut(int n) {
        timeout = n;
        this.firePropertyChange(PROP_TIME_OUT, null, new Integer(n));
    }

    public String getTrustStorePassword() {
        return trustStorePassword;
    }

    public void setTrustStorePassword(String string) {
        trustStorePassword = string;
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        this.firePropertyChange(PROP_TRUST_STORE_PASSWORD, null, string);
    }

    public synchronized HashSet getRemoteRuntimes() {
        Collection collection = this.remoteRuntimes.values();
        HashSet hashSet = new HashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public synchronized void setRemoteRuntimes(HashSet hashSet) {
        Object object;
        Iterator iterator = hashSet.iterator();
        HashMap hashMap = new HashMap();
        while (iterator.hasNext()) {
            object = iterator.next();
            hashMap.put(object, object);
        }
        object = this.remoteRuntimes;
        this.remoteRuntimes = hashMap;
        this.firePropertyChange(PROP_REMOTE_RUNTIMES, object, this.remoteRuntimes);
    }

    public synchronized RemoteRuntimeType findRemoteRuntime(String string, String string2) {
        HashSet hashSet = this.getRemoteRuntimes();
        Object var4_4 = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)iterator.next();
            if (!remoteRuntimeType.equals(string, string2)) continue;
            return remoteRuntimeType;
        }
        return null;
    }

    public void flushRemoteRuntimes() {
        HashSet hashSet = this.getRemoteRuntimes();
        this.setRemoteRuntimes(hashSet);
    }

    public synchronized void putRemoteRuntime(RemoteRuntimeType remoteRuntimeType) {
        HashSet hashSet = this.getRemoteRuntimes();
        hashSet.add(remoteRuntimeType);
        this.setRemoteRuntimes(hashSet);
    }

    public synchronized void removeRemoteRuntime(RemoteRuntimeType remoteRuntimeType) {
        HashSet hashSet = this.getRemoteRuntimes();
        hashSet.remove(remoteRuntimeType);
        this.setRemoteRuntimes(hashSet);
    }

    public String getUserName() {
        return userName;
    }

    public void setPasswd(char[] cArray) {
        passwd = cArray;
        this.firePropertyChange(PROP_PASSWD, null, cArray.toString());
    }

    public void setUserName(String string) {
        userName = string;
        this.firePropertyChange(PROP_USERNAME, null, userName);
    }

    public String getSetupCommand() {
        return setupCommand;
    }

    public void setSetupCommand(String string) {
        setupCommand = string;
        this.firePropertyChange(PROP_SETUP_COMMAND, null, string);
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String string) {
        hostName = string;
        this.firePropertyChange(PROP_HOSTNAME, null, hostName);
    }

    public String getPort() {
        return port;
    }

    public void setPort(String string) {
        port = string;
        this.firePropertyChange(PROP_PORT, null, string);
    }

    public boolean getUseXtermCompile() {
        return useXtermCompile;
    }

    public void setUseXtermCompile(boolean bl) {
        useXtermCompile = bl;
        this.firePropertyChange(PROP_USEX_COMPILE, null, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getXDisplayDeviceNumber() {
        return xDisplayNumber;
    }

    public void setXDisplayDeviceNumber(int n) {
        xDisplayNumber = n;
        this.firePropertyChange(PROP_X_DISPLAY_NUMBER, null, new Integer(n));
    }

    public int getSvrTimeOut() {
        return svrTimeOut;
    }

    public void setSvrTimeOut(int n) {
        svrTimeOut = n;
        this.firePropertyChange(PROP_SVR_TIMEOUT, null, new Integer(n));
    }

    public boolean getUseXtermExecution() {
        return useXtermExecution;
    }

    public void setConnectAtStartup(boolean bl) {
        connectAtStartup = bl;
        this.firePropertyChange(PROP_CONNECT_AT_STARTUP, null, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getConnectAtStartup() {
        return connectAtStartup;
    }

    public void setUseXtermExecution(boolean bl) {
        useXtermExecution = bl;
        this.firePropertyChange(PROP_USEX_EXECUTION, null, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public File getSetupScript() {
        return setupScript;
    }

    public void setSetupScript(File file) {
        setupScript = file;
    }

    public void addToRemoteObjList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            remoteObjs.add(stringArray[i]);
        }
    }

    public void removeFromRemoteObjList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            remoteObjs.remove(stringArray[i]);
        }
    }

    public boolean isRemoteObj(String string) {
        return remoteObjs.contains(string);
    }

    protected void reset() {
    }

    static {
        xDisplayNumber = 0;
        firstTime = true;
    }
}

