/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.diagnose;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.distributed.ideserverclient.RemoteLoginClient;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;

public class GatherInfo {
    private String lastErrMsg = "";
    private static final String USER_ENV_BEGIN = "USER_DIAG";
    private static final String USER_ENV_END = "USER_DIAG_END";
    private static final int REPORT_PAD = 52;

    public String getLastErrorMsg() {
        return this.lastErrMsg;
    }

    public static String padString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (string.length() < 52) {
            for (int i = string.length(); i < 52; ++i) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public ArrayList getClientVersions() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        Collection collection = result.allItems();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            Lookup.Item item = (Lookup.Item)iterator.next();
            ModuleInfo moduleInfo = (ModuleInfo)item.getInstance();
            SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
            if (!moduleInfo.getCodeNameBase().startsWith("com.hp.openvms") && !moduleInfo.getCodeNameBase().startsWith("com.compaq.openvms") && !moduleInfo.getCodeNameBase().startsWith("org.netbeans.modules.distributed")) continue;
            arrayList.add(GatherInfo.padString(moduleInfo.getCodeNameBase()) + specificationVersion.toString() + "\t" + (moduleInfo.isEnabled() ? "enabled" : "disabled"));
        }
        return arrayList;
    }

    public ArrayList getClientEnv() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Product version\t" + new MessageFormat("NetBeans Platform Dev (Build {0})").format(new Object[]{System.getProperty("netbeans.buildnumber")}));
        arrayList.add("OS info:\t" + System.getProperty("os.name", "unknown") + " " + System.getProperty("os.version", "unknown") + " " + System.getProperty("os.arch", "unknown"));
        arrayList.add("JDK Info:\t" + System.getProperty("java.version", "unknown") + " " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", ""));
        arrayList.add("\t\t" + System.getProperty("java.vendor", "unknown") + " " + System.getProperty("java.home", "unknown"));
        arrayList.add("Home dir:\t" + System.getProperty("user.home", "unknown"));
        arrayList.add("Current dir:\t" + System.getProperty("user.dir", "unknown"));
        arrayList.add("NetBeans home:\t" + System.getProperty("netbeans.home"));
        arrayList.add("User dir:\t" + System.getProperty("netbeans.user"));
        return arrayList;
    }

    private String getUserDirValue() {
        return System.getProperty("netbeans.user");
    }

    public boolean isHostReachable(String string, int n) {
        try {
            Socket socket = null;
            Object var4_6 = null;
            DataInputStream dataInputStream = null;
            socket = new Socket(string, n);
            dataInputStream = new DataInputStream(socket.getInputStream());
        }
        catch (UnknownHostException unknownHostException) {
            this.lastErrMsg = "IP address of the host " + string + " could not be determined";
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean isIdeServerRunning(String string, int n) {
        String string2;
        RemoteLoginClient remoteLoginClient = new RemoteLoginClient();
        this.lastErrMsg = string2 = remoteLoginClient.canFindLoginServer(string, n);
        return string2.equals("success");
    }

    public String getServerVersion(String string, int n) {
        String string2;
        RemoteLoginClient remoteLoginClient = new RemoteLoginClient();
        this.lastErrMsg = string2 = remoteLoginClient.getServerVersionDirect(string, n);
        return string2;
    }

    public boolean authenUser(String string, String string2, char[] cArray, int n) {
        String string3;
        RemoteLoginClient remoteLoginClient = new RemoteLoginClient();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("VERSION", "1.0");
        hashMap.put("USER", string2.toLowerCase());
        hashMap.put("PASSWD", cArray);
        this.lastErrMsg = string3 = remoteLoginClient.authenticate(hashMap, string, n);
        return string3.equals("success");
    }

    public String[] getUserUAI(String string, String string2, char[] cArray, int n) {
        RemoteLoginClient remoteLoginClient = new RemoteLoginClient();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("VERSION", "1.0");
        hashMap.put("USER", string2.toLowerCase());
        hashMap.put("PASSWD", cArray);
        String string3 = remoteLoginClient.getUserUAIInfo(hashMap, string, n);
        String string4 = string3.substring(0, string3.indexOf("Default")).trim();
        String string5 = string3.substring(string3.indexOf("Default"), string3.length()).trim();
        return new String[]{string4, string5};
    }

    public String getUserEnv(String string, String string2, char[] cArray, int n) {
        RemoteLoginClient remoteLoginClient = new RemoteLoginClient();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("VERSION", "1.0");
        hashMap.put("USER", string2.toLowerCase());
        hashMap.put("PASSWD", cArray);
        String string3 = remoteLoginClient.getUserEnv(hashMap, string, n);
        if (string3 == null || string3.indexOf(USER_ENV_BEGIN) < 0 || string3.indexOf(USER_ENV_END) < 0) {
            return "Can't determine the User Login Environment. Invalid output from the server";
        }
        return string3.substring(string3.indexOf(USER_ENV_BEGIN) + USER_ENV_BEGIN.length(), string3.indexOf(USER_ENV_END));
    }

    public static void main(String[] stringArray) {
        GatherInfo gatherInfo = new GatherInfo();
        gatherInfo.isHostReachable("yahoo.com", 1099);
    }
}

