/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.pascalsupport.editor.pascal;

import com.hp.openvms.netbeans.pascalsupport.editor.pascal.StringToken;
import org.netbeans.api.lexer.LexerInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;

public class StringLexerInput
implements LexerInput {
    private String text;
    private int inputIndex;
    private int tokenIndex;
    private int lookaheadIndex;
    private int eof;

    public StringLexerInput(String string) {
        this.text = string;
    }

    public int read() {
        if (this.inputIndex >= this.text.length()) {
            this.eof = 1;
            return -1;
        }
        return this.text.charAt(this.inputIndex++);
    }

    public int getReadLookahead() {
        return Math.max(this.lookaheadIndex, this.inputIndex + this.eof) - this.tokenIndex;
    }

    public int getReadLength() {
        return this.inputIndex - this.tokenIndex;
    }

    public void backup(int n) {
        this.lookaheadIndex = Math.max(this.lookaheadIndex, this.inputIndex + this.eof);
        this.inputIndex -= n;
        if (this.inputIndex < this.tokenIndex) {
            this.inputIndex += n;
            throw new IllegalArgumentException("count=" + n + " > " + (this.inputIndex - this.tokenIndex));
        }
    }

    public Token createToken(TokenId tokenId, int n) {
        StringToken stringToken;
        if (n <= 0) {
            throw new IllegalArgumentException("tokenLength=" + n + " <= 0");
        }
        if (this.tokenIndex + n > this.inputIndex + 1) {
            throw new IllegalArgumentException("tokenLength=" + n + " > number-of-read-characters=" + (this.inputIndex - this.tokenIndex) + ";inputIndex=" + this.inputIndex + "; tokenIndex=" + this.tokenIndex);
        }
        if (this.tokenIndex + n == this.inputIndex + 1) {
            if (this.tokenIndex == 0) {
                if (n > this.text.length()) {
                    stringToken = new StringToken(tokenId, this.text.substring(0, this.text.length()));
                    n = this.text.length();
                } else {
                    stringToken = new StringToken(tokenId, this.text.substring(this.tokenIndex, this.tokenIndex + n));
                }
                this.tokenIndex += n;
            } else {
                stringToken = new StringToken(tokenId, this.text.substring(this.tokenIndex - 1, this.tokenIndex - 1 + n));
                this.tokenIndex += n - 1;
            }
        } else {
            stringToken = new StringToken(tokenId, this.text.substring(this.tokenIndex, this.tokenIndex + n));
            this.tokenIndex += n;
        }
        return stringToken;
    }

    public Token createToken(TokenId tokenId) {
        return this.createToken(tokenId, this.inputIndex - this.tokenIndex);
    }

    public CharSequence getReadText(int n, int n2) {
        return this.getReadText(this.inputIndex, this.tokenIndex);
    }

    public boolean isEOFLookahead() {
        return this.getReadLookahead() <= 0;
    }
}

