/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.fortransupport.fortran.datasys;

import com.hp.openvms.netbeans.baseclasses.dataobjects.AlphaVMSDataObject;
import com.hp.openvms.netbeans.fortransupport.fortran.RemotePropertiesAction;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranCompilerSupport;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataEditor;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataLoader;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranDataNode;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranEditorSupport;
import org.netbeans.modules.distributed.common.cookies.RemotePropertyCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class FortranDataObject
extends AlphaVMSDataObject {
    private static final long serialVersionUID = 7950969510179979629L;
    private static final String FORTRAN_ICON_BASE = "com/hp/openvms/netbeans/fortransupport/fortran/resources/FortranDataIcon";

    public FortranDataObject(FileObject fileObject, FortranDataLoader fortranDataLoader) throws DataObjectExistsException {
        super(fileObject, fortranDataLoader);
        this.init();
    }

    protected String getMIMEType() {
        return "text/x-hp+openvms+for";
    }

    String getIconBase() {
        return FORTRAN_ICON_BASE;
    }

    private void init() {
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)new FortranDataEditor(this));
        cookieSet.add((Node.Cookie)new FortranEditorSupport(this));
        if (!Utilities.isUnix() && !Utilities.isWindows()) {
            cookieSet.add((Node.Cookie)new FortranCompilerSupport.Compile(this.getPrimaryEntry()));
            cookieSet.add((Node.Cookie)new FortranCompilerSupport.Build(this.getPrimaryEntry()));
        }
        cookieSet.add((Node.Cookie)new FortranCompilerSupport.Clean(this.getPrimaryEntry()));
        cookieSet.add((Node.Cookie)new FortranCompilerSupport.RemoteCompile(this.getPrimaryEntry()));
        cookieSet.add((Node.Cookie)new FortranCompilerSupport.RemoteBuild(this.getPrimaryEntry()));
        cookieSet.add((Node.Cookie)new RemotePropertyCookie(){

            public void operations(Node[] nodeArray) {
                RemotePropertiesAction.doAction(nodeArray);
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        return new FortranDataNode(this);
    }
}

