/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.model;

import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import com.hp.openvms.netbeans.debugsupport.model.BoldVariablesTableModelFilterFirst;
import com.hp.openvms.netbeans.debugsupport.model.BreakpointsTreeModelFilter;
import java.util.Vector;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    private Vector listeners = new Vector();
    private static final String ZEROS = "            ";
    private RemoteBreakpoint currentBreakpoint;

    static int log10(int n) {
        int n2 = 1;
        while ((n /= 10) > 0) {
            ++n2;
        }
        return n2;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String string = ZEROS;
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            int n;
            int n2;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
            int n3 = lineBreakpoint.getLineNumber();
            String string = Integer.toString(n3);
            Integer n4 = (Integer)BreakpointsTreeModelFilter.MAX_LINES.get((Object)lineBreakpoint);
            if (n4 != null && (n2 = BreakpointsNodeModel.log10(n = n4.intValue()) - BreakpointsNodeModel.log10(n3)) > 0) {
                string = BreakpointsNodeModel.zeros(n2) + string;
            }
            return this.bold(lineBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(lineBreakpoint), (Object)string));
        }
        if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            String string = "";
            if (functionBreakpoint.getFunctionName().equals("")) {
                return this.bold(functionBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            String string2 = BreakpointsNodeModel.getShort(string);
            if (string2 != null && string2.length() > 0) {
                return this.bold(functionBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint_With_Class", (Object)BreakpointsNodeModel.getShort(string), (Object)functionBreakpoint.getFunctionName()));
            }
            return this.bold(functionBreakpoint, NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)functionBreakpoint.getFunctionName()));
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)((Object)object)), (Object)("" + ((LineBreakpoint)((Object)object)).getLineNumber()));
        }
        if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            String string = "";
            if (functionBreakpoint.getFunctionName().equals("")) {
                return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)string);
            }
            return NbBundle.getMessage((Class)BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)string, (Object)functionBreakpoint.getFunctionName());
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            return LINE_BREAKPOINT;
        }
        if (object instanceof FunctionBreakpoint) {
            return BREAKPOINT;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    void fireNodeChanged(RemoteBreakpoint remoteBreakpoint) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)remoteBreakpoint));
        }
    }

    static String getShort(String string) {
        if (string.indexOf(42) >= 0) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private String bold(RemoteBreakpoint remoteBreakpoint, String string) {
        return remoteBreakpoint == this.currentBreakpoint ? BoldVariablesTableModelFilterFirst.toHTML(string, true, false, null) : string;
    }

    public void setCurrentBreakpoint(RemoteBreakpoint remoteBreakpoint) {
        if (this.currentBreakpoint != null) {
            this.fireNodeChanged(this.currentBreakpoint);
        }
        this.currentBreakpoint = remoteBreakpoint;
        if (remoteBreakpoint != null) {
            this.fireNodeChanged(remoteBreakpoint);
        }
    }
}

