/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.debugger;

import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.CallStackFrame;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContext;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class EditorContextBridge {
    public static final String FUNCTION = "function";
    public static final String LINE = "line";
    private static EditorContext context;

    public static EditorContext getContext() {
        if (context == null) {
            List list = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                context = new CompoundContextProvider((EditorContext)list.get(i), context);
            }
        }
        return context;
    }

    public static boolean showSource(String string, int n, Object object) {
        return EditorContextBridge.getContext().showSource(string, n, object);
    }

    public static boolean showSource(CallStackFrame callStackFrame) {
        String string = callStackFrame.getFullname();
        if (string != null) {
            String string2;
            File file = new File(string);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            try {
                InputStream inputStream = fileObject.getInputStream();
                if (inputStream == null) {
                    return false;
                }
                URL uRL = fileObject.getURL();
                string2 = fileObject.getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string2 = Utilities.isWindows() ? "file:/" + fileObject.getPath().replace(" ", "%20") : "file:/" + fileObject.getPath();
            }
            catch (IOException iOException) {
                return false;
            }
            return EditorContextBridge.getContext().showSource(string2, callStackFrame.getLineNumber(), null);
        }
        return false;
    }

    public static void createTimeStamp(Object object) {
        EditorContextBridge.getContext().createTimeStamp(object);
    }

    public static void disposeTimeStamp(Object object) {
        EditorContextBridge.getContext().disposeTimeStamp(object);
    }

    public static Object annotate(String string, int n, String string2, Object object) {
        return EditorContextBridge.getContext().annotate(string, n, string2, object);
    }

    public static Object annotate(CallStackFrame callStackFrame, String string) {
        File file;
        String string2 = callStackFrame.getFullname();
        if (string2 != null && (file = new File(string2)).exists()) {
            String string3;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            try {
                string3 = fileObject.getURL().toExternalForm();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string3 = Utilities.isWindows() ? "file:/" + fileObject.getPath().replace(" ", "%20") : "file:" + fileObject.getPath();
            }
            return EditorContextBridge.getContext().annotate(string3, callStackFrame.getLineNumber(), string, null);
        }
        return null;
    }

    public static void removeAnnotation(Object object) {
        EditorContextBridge.getContext().removeAnnotation(object);
    }

    public static int getLineNumber(Object object, Object object2) {
        return EditorContextBridge.getContext().getLineNumber(object, object2);
    }

    public static int getCurrentLineNumber() {
        return EditorContextBridge.getContext().getCurrentLineNumber();
    }

    public static int getMostRecentLineNumber() {
        return EditorContextBridge.getContext().getMostRecentLineNumber();
    }

    public static String getCurrentURL() {
        return EditorContextBridge.getContext().getCurrentURL();
    }

    public static String getMostRecentURL() {
        return EditorContextBridge.getContext().getMostRecentURL();
    }

    public static String getCurrentFunctionName() {
        return EditorContextBridge.getContext().getCurrentFunctionName();
    }

    public static String getSelectedFunctionName() {
        return EditorContextBridge.getContext().getSelectedFunctionName();
    }

    public static int getFieldLineNumber(String string, String string2, String string3) {
        return EditorContextBridge.getContext().getFieldLineNumber(string, string2, string3);
    }

    public String getCurrentMIMEType() {
        return EditorContextBridge.getContext().getCurrentMIMEType();
    }

    public static String getMostRecentMIMEType() {
        return EditorContextBridge.getContext().getMostRecentMIMEType();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        EditorContextBridge.getContext().addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        EditorContextBridge.getContext().removePropertyChangeListener(propertyChangeListener);
    }

    public static String getFileName(LineBreakpoint lineBreakpoint) {
        try {
            return EditorContextBridge.basename(new File(new URL(lineBreakpoint.getURL()).getFile()).getName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static String basename(String string) {
        int n = string.lastIndexOf(47);
        if (n > 0) {
            return string.substring(n);
        }
        return string;
    }

    public static boolean showSource(LineBreakpoint lineBreakpoint, Object object) {
        if (lineBreakpoint.getLineNumber() < 1) {
            return EditorContextBridge.showSource(lineBreakpoint.getURL(), 1, object);
        }
        return EditorContextBridge.showSource(lineBreakpoint.getURL(), lineBreakpoint.getLineNumber(), object);
    }

    public static String getDefaultType() {
        return LINE;
    }

    public static Object annotate(LineBreakpoint lineBreakpoint) {
        boolean bl;
        String string = lineBreakpoint.getURL();
        int n = lineBreakpoint.getLineNumber();
        if (n < 1) {
            return null;
        }
        String string2 = lineBreakpoint.getCondition();
        boolean bl2 = bl = string2 != null && !string2.trim().equals("");
        String string3 = lineBreakpoint.isEnabled() ? (bl ? EditorContext.CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.BREAKPOINT_ANNOTATION_TYPE) : (bl ? EditorContext.DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        return EditorContextBridge.annotate(string, n, string3, null);
    }

    public static Object annotate(FunctionBreakpoint functionBreakpoint) {
        boolean bl;
        String string = functionBreakpoint.getURL();
        int n = functionBreakpoint.getLineNumber();
        if (n < 1) {
            return null;
        }
        String string2 = functionBreakpoint.getCondition();
        boolean bl2 = bl = string2 != null && !string2.trim().equals("");
        String string3 = functionBreakpoint.isEnabled() ? (bl ? EditorContext.CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.BREAKPOINT_ANNOTATION_TYPE) : (bl ? EditorContext.DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        return EditorContextBridge.annotate(string, n, string3, null);
    }

    public static String getRelativePath(String string) {
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext editorContext, EditorContext editorContext2) {
            this.cp1 = editorContext;
            this.cp2 = editorContext2;
        }

        public void createTimeStamp(Object object) {
            this.cp1.createTimeStamp(object);
            this.cp2.createTimeStamp(object);
        }

        public void disposeTimeStamp(Object object) {
            this.cp1.disposeTimeStamp(object);
            this.cp2.disposeTimeStamp(object);
        }

        public void updateTimeStamp(Object object, String string) {
            this.cp1.updateTimeStamp(object, string);
            this.cp2.updateTimeStamp(object, string);
        }

        public String getCurrentURL() {
            String string = this.cp1.getCurrentURL();
            if (string.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return string;
        }

        public String getMostRecentURL() {
            String string = this.cp1.getMostRecentURL();
            if (string.trim().length() < 1) {
                return this.cp2.getMostRecentURL();
            }
            return string;
        }

        public int getCurrentLineNumber() {
            int n = this.cp1.getCurrentLineNumber();
            if (n < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return n;
        }

        public int getMostRecentLineNumber() {
            int n = this.cp1.getMostRecentLineNumber();
            if (n < 1) {
                return this.cp2.getMostRecentLineNumber();
            }
            return n;
        }

        public String getCurrentFunctionName() {
            String string = this.cp1.getCurrentFunctionName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getCurrentFunctionName();
            }
            return string;
        }

        public String getSelectedFunctionName() {
            String string = this.cp1.getSelectedFunctionName();
            if (string == null || string.trim().length() < 1) {
                return this.cp2.getSelectedFunctionName();
            }
            return string;
        }

        public void removeAnnotation(Object object) {
            CompoundAnnotation compoundAnnotation = (CompoundAnnotation)object;
            this.cp1.removeAnnotation(compoundAnnotation.annotation1);
            this.cp2.removeAnnotation(compoundAnnotation.annotation2);
        }

        public Object annotate(String string, int n, String string2, Object object) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            compoundAnnotation.annotation1 = this.cp1.annotate(string, n, string2, object);
            compoundAnnotation.annotation2 = this.cp2.annotate(string, n, string2, object);
            return compoundAnnotation;
        }

        public int getLineNumber(Object object, Object object2) {
            CompoundAnnotation compoundAnnotation = new CompoundAnnotation();
            int n = this.cp1.getLineNumber(compoundAnnotation.annotation1, object2);
            if (n >= 0) {
                return n;
            }
            return this.cp2.getLineNumber(compoundAnnotation.annotation2, object2);
        }

        public boolean showSource(String string, int n, Object object) {
            return this.cp1.showSource(string, n, object) | this.cp2.showSource(string, n, object);
        }

        public int getFieldLineNumber(String string, String string2, String string3) {
            int n = this.cp1.getFieldLineNumber(string, string2, string3);
            if (n != -1) {
                return n;
            }
            return this.cp2.getFieldLineNumber(string, string2, string3);
        }

        public String getCurrentMIMEType() {
            String string = this.cp1.getCurrentMIMEType();
            if (string == null) {
                return this.cp2.getCurrentMIMEType();
            }
            return string;
        }

        public String getMostRecentMIMEType() {
            String string = this.cp1.getMostRecentMIMEType();
            if (string == null) {
                return this.cp2.getMostRecentMIMEType();
            }
            return string;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }

        public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(string, propertyChangeListener);
            this.cp2.addPropertyChangeListener(string, propertyChangeListener);
        }

        public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(string, propertyChangeListener);
            this.cp2.removePropertyChangeListener(string, propertyChangeListener);
        }
    }
}

