/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.distributed.rmi.protocol.debug.LookupLinePacket;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class LineBreakpoint
extends RemoteBreakpoint {
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String PROP_URL = "url";
    public static final String PROP_CONDITION = "condition";
    private String url = "";
    private String path = "";
    private int lineNumber;
    private String condition = "";
    private LookupLinePacket linePacket;
    private String vmsFilePath;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static LineBreakpoint create(String string, int n) {
        LineBreakpointComparable lineBreakpointComparable = new LineBreakpointComparable();
        lineBreakpointComparable.setID();
        lineBreakpointComparable.setURL(string);
        lineBreakpointComparable.setLineNumber(n);
        return lineBreakpointComparable;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            block10: {
                if (string == this.url || string != null && this.url != null && string.equals(this.url)) {
                    return;
                }
                try {
                    if (!$assertionsDisabled && string == null && Boolean.getBoolean("gdb.assertions.enabled")) {
                        throw new AssertionError();
                    }
                    FileObject fileObject = URLMapper.findFileObject((URL)new URL(string));
                    if (fileObject != null) {
                        this.path = Utilities.isWindows() ? fileObject.getPath() : "/" + fileObject.getPath();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    if (!$assertionsDisabled && Boolean.getBoolean("gdb.assertions.enabled")) {
                        throw new AssertionError();
                    }
                    return;
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || !Boolean.getBoolean("gdb.assertions.enabled")) break block10;
                    throw new AssertionError();
                }
            }
            string2 = this.url;
            this.url = string;
        }
        this.firePropertyChange(PROP_URL, string2, string);
    }

    public LookupLinePacket getLookupLinePacket() {
        return this.linePacket;
    }

    public void setLookupLinePacket(LookupLinePacket lookupLinePacket) {
        this.linePacket = lookupLinePacket;
    }

    public String getVmsFilePath() {
        return this.vmsFilePath;
    }

    public void setVmsFilePath(String string) {
        this.vmsFilePath = string;
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int n) {
        int n2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (n == this.lineNumber) {
                return;
            }
            n2 = this.lineNumber;
            this.lineNumber = n;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(n2), new Integer(n));
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String string) {
        String string2;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (string == null) {
                string = "";
            }
            if ((string = string.trim()) == this.condition || string != null && this.condition != null && this.condition.equals(string)) {
                return;
            }
            string2 = this.condition;
            this.condition = string;
        }
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public String toString() {
        return "LineBreakpoint " + this.url + " : " + this.lineNumber;
    }

    static {
        $assertionsDisabled = !LineBreakpoint.class.desiredAssertionStatus();
    }

    private static class LineBreakpointComparable
    extends LineBreakpoint
    implements Comparable {
        public int compareTo(Object object) {
            if (object instanceof LineBreakpointComparable) {
                LineBreakpointComparable lineBreakpointComparable = this;
                LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
                int n = ((LineBreakpoint)lineBreakpointComparable).url.compareTo(lineBreakpoint.url);
                if (n != 0) {
                    return n;
                }
                return ((LineBreakpoint)lineBreakpointComparable).lineNumber - lineBreakpoint.lineNumber;
            }
            return -1;
        }
    }
}

