/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.debugsupport.breakpoints;

import com.hp.openvms.netbeans.debugsupport.breakpoints.FunctionBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.LineBreakpoint;
import com.hp.openvms.netbeans.debugsupport.breakpoints.RemoteBreakpoint;
import com.hp.openvms.netbeans.debugsupport.debugger.EditorContextBridge;
import com.hp.openvms.netbeans.debugsupport.debugger.RemoteDebugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.openide.util.Utilities;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter {
    private HashMap breakpointToAnnotation = new HashMap();
    private boolean listen = true;

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (!this.listen) {
            return;
        }
        if (!(string.equals("condition") || string.equals("url") || string.equals("lineNumber") || string.equals("enabled"))) {
            return;
        }
        if (propertyChangeEvent.getSource() instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)propertyChangeEvent.getSource());
            this.annotate(lineBreakpoint);
            return;
        }
        if (propertyChangeEvent.getSource() instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)propertyChangeEvent.getSource());
            this.annotate(functionBreakpoint);
            return;
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            ((LineBreakpoint)breakpoint).addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotate((LineBreakpoint)breakpoint);
        }
        if (breakpoint instanceof FunctionBreakpoint) {
            ((FunctionBreakpoint)breakpoint).addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            ((LineBreakpoint)breakpoint).removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation((LineBreakpoint)breakpoint);
        }
        if (breakpoint instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)breakpoint;
            functionBreakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.removeAnnotation(functionBreakpoint);
            int n = functionBreakpoint.getBreakpointNumber();
            if (n > 0) {
                RemoteDebugger remoteDebugger = functionBreakpoint.getDebugger();
            }
        }
    }

    public RemoteBreakpoint findBreakpoint(String string, int n) {
        Iterator iterator = this.breakpointToAnnotation.keySet().iterator();
        while (iterator.hasNext()) {
            int n2;
            Object v;
            RemoteBreakpoint remoteBreakpoint;
            Object k = iterator.next();
            if (k instanceof LineBreakpoint) {
                remoteBreakpoint = (LineBreakpoint)((Object)k);
                if (!((LineBreakpoint)remoteBreakpoint).getURL().equals(string)) continue;
                v = this.breakpointToAnnotation.get((Object)remoteBreakpoint);
                n2 = EditorContextBridge.getContext().getLineNumber(v, null);
                if (n2 == n) {
                    return remoteBreakpoint;
                }
            }
            if (!(k instanceof FunctionBreakpoint)) continue;
            remoteBreakpoint = (FunctionBreakpoint)((Object)k);
            if (Utilities.isWindows()) {
                boolean bl = false;
                if (((FunctionBreakpoint)remoteBreakpoint).getURL().equals(string)) {
                    bl = true;
                } else {
                    String string2 = ((FunctionBreakpoint)remoteBreakpoint).getURL();
                    if (string2.startsWith("file:/") && string.startsWith("file:/") && string2.charAt(7) == ':' && string.charAt(7) == ':') {
                        String string3 = string.substring(0, 8);
                        string3 = string3.toLowerCase() + string.substring(8);
                        String string4 = string2.substring(0, 8);
                        if ((string4 = string4.toLowerCase() + string2.substring(8)).equals(string3)) {
                            bl = true;
                        }
                    }
                }
                if (!bl) {
                    continue;
                }
            } else if (!((FunctionBreakpoint)remoteBreakpoint).getURL().equals(string)) continue;
            v = this.breakpointToAnnotation.get((Object)remoteBreakpoint);
            n2 = EditorContextBridge.getContext().getLineNumber(v, null);
            if (n2 != n) continue;
            return remoteBreakpoint;
        }
        return null;
    }

    private void annotate(LineBreakpoint lineBreakpoint) {
        Object object = this.breakpointToAnnotation.get((Object)lineBreakpoint);
        if (object != null) {
            EditorContextBridge.getContext().removeAnnotation(object);
        }
        if (lineBreakpoint.isHidden()) {
            return;
        }
        object = EditorContextBridge.annotate(lineBreakpoint);
        if (object == null) {
            return;
        }
        this.breakpointToAnnotation.put(lineBreakpoint, object);
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object object2 = null;
        if (debuggerEngine != null) {
            object2 = debuggerEngine.lookupFirst(null, RemoteDebugger.class);
        }
        this.update(lineBreakpoint, object2);
    }

    public void updateBreakpoints() {
        Iterator iterator = this.breakpointToAnnotation.keySet().iterator();
        while (iterator.hasNext()) {
            RemoteBreakpoint remoteBreakpoint;
            Object k = iterator.next();
            if (k instanceof LineBreakpoint) {
                remoteBreakpoint = (LineBreakpoint)((Object)k);
                this.update((LineBreakpoint)remoteBreakpoint, (Object)null);
            }
            if (!(k instanceof FunctionBreakpoint)) continue;
            remoteBreakpoint = (FunctionBreakpoint)((Object)k);
            this.update((FunctionBreakpoint)remoteBreakpoint, null);
        }
    }

    private void update(LineBreakpoint lineBreakpoint, Object object) {
        Object v = this.breakpointToAnnotation.get((Object)lineBreakpoint);
        int n = EditorContextBridge.getContext().getLineNumber(v, object);
        this.listen = false;
        lineBreakpoint.setLineNumber(n);
        this.listen = true;
    }

    private void removeAnnotation(LineBreakpoint lineBreakpoint) {
        Object v = this.breakpointToAnnotation.remove((Object)lineBreakpoint);
        if (v != null) {
            EditorContextBridge.getContext().removeAnnotation(v);
        }
    }

    private void annotate(FunctionBreakpoint functionBreakpoint) {
        Object object = this.breakpointToAnnotation.get((Object)functionBreakpoint);
        if (object != null) {
            EditorContextBridge.getContext().removeAnnotation(object);
        }
        if (functionBreakpoint.isHidden()) {
            return;
        }
        int n = functionBreakpoint.getLineNumber();
        if (n < 1) {
            return;
        }
        object = EditorContextBridge.annotate(functionBreakpoint);
        if (object == null) {
            return;
        }
        this.breakpointToAnnotation.put(functionBreakpoint, object);
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        Object object2 = null;
        if (debuggerEngine != null) {
            object2 = debuggerEngine.lookupFirst(null, RemoteDebugger.class);
        }
        this.update(functionBreakpoint, object2);
    }

    private void update(FunctionBreakpoint functionBreakpoint, Object object) {
        Object v = this.breakpointToAnnotation.get((Object)functionBreakpoint);
        int n = EditorContextBridge.getContext().getLineNumber(v, object);
        this.listen = false;
        functionBreakpoint.setLineNumber(n);
        this.listen = true;
    }

    private void removeAnnotation(FunctionBreakpoint functionBreakpoint) {
        Object object = this.breakpointToAnnotation.remove((Object)functionBreakpoint);
        if (object == null) {
            object = functionBreakpoint.annotation;
        }
        if (object != null) {
            EditorContextBridge.getContext().removeAnnotation(object);
        }
    }
}

