/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.lang.ref.WeakReference;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class TimedWeakReference
extends WeakReference
implements Runnable {
    public static int TIMEOUT = 15000;
    private static final RequestProcessor RP = new RequestProcessor("TimedWeakReference");
    private RequestProcessor.Task task;
    private Object o;
    private long touched;

    public TimedWeakReference(Object o) {
        super(o, Utilities.activeReferenceQueue());
        this.o = o;
        this.task = RP.create((Runnable)this);
        this.task.schedule(TIMEOUT);
    }

    public synchronized void run() {
        if (this.o != null) {
            long unused = System.currentTimeMillis() - this.touched;
            if (unused > (long)(TIMEOUT / 2)) {
                this.o = null;
                this.touched = 0L;
            } else {
                this.task.schedule(TIMEOUT - (int)unused);
            }
        }
    }

    public synchronized Object get() {
        if (this.o == null) {
            this.o = super.get();
        }
        if (this.o != null) {
            if (this.touched == 0L) {
                this.task.schedule(TIMEOUT);
            }
            this.touched = System.currentTimeMillis();
            return this.o;
        }
        return null;
    }
}

