/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.openide.ErrorManager;

final class ReaderCharSequence
implements CharSequence {
    private final Reader r;
    private char[] buf;
    private int size = 0;
    private int origin = 0;
    private int horizon;
    private boolean eof = false;
    private final float loadFactor;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void invariants() {
        if (!$assertionsDisabled && this.buf.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.size < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.origin < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.origin > this.size) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.horizon < this.size) {
            throw new AssertionError();
        }
    }

    public ReaderCharSequence(Reader reader) {
        this(reader, 4096, Integer.MAX_VALUE, 1.3333334f);
    }

    public ReaderCharSequence(Reader reader, int n, int n2, float f) {
        this.r = reader;
        this.buf = new char[n];
        this.horizon = n2;
        this.loadFactor = f;
    }

    public void prune(int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (n > this.origin && n <= this.size) {
            int n2 = n - this.origin;
            this.origin = n;
        }
        this.invariants();
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.horizon) {
            throw new IndexOutOfBoundsException();
        }
        while (n >= this.origin) {
            if (n < this.size) {
                return this.buf[n % this.buf.length];
            }
            if (this.eof) {
                return '\uffff';
            }
            this.readOneChar();
        }
        return '\uffff';
    }

    private void readOneChar() {
        int n;
        if (!$assertionsDisabled && this.eof) {
            throw new AssertionError();
        }
        try {
            n = this.r.read();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            n = -1;
            this.eof = true;
        }
        if (n == -1) {
            this.eof = true;
        } else {
            char c = (char)n;
            if (this.size - this.origin == this.buf.length) {
                this.realloc();
            } else if (!$assertionsDisabled && this.size - this.origin >= this.buf.length) {
                throw new AssertionError();
            }
            this.buf[this.size++ % this.buf.length] = c;
            if (this.horizon != Integer.MAX_VALUE) {
                ++this.horizon;
            }
        }
        this.invariants();
    }

    private void realloc() {
        int n = this.buf.length;
        int n2 = (int)((float)n * this.loadFactor);
        char[] cArray = new char[n2];
        int n3 = n2 - n;
        for (int i = this.origin; i < this.size; ++i) {
            cArray[i % n2] = this.buf[i % n];
        }
        this.buf = cArray;
        this.invariants();
    }

    public int length() {
        if (this.eof) {
            return this.size;
        }
        return this.horizon;
    }

    public CharSequence subSequence(int n, int n2) {
        return new SubCharSequence(n, n2);
    }

    private String substring(int n, int n2) {
        int n3;
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 > this.size) {
            throw new AssertionError();
        }
        int n4 = this.buf.length;
        if (n >= this.origin && n % n4 <= n2 % n4) {
            return new String(this.buf, n % n4, n2 - n);
        }
        char[] cArray = new char[n2 - n];
        if (n < this.origin) {
            Arrays.fill(cArray, 0, this.origin - n, '\uffff');
            n3 = this.origin;
        } else {
            n3 = n;
        }
        for (int i = n3; i < n2; ++i) {
            cArray[i - n] = this.buf[i % this.buf.length];
        }
        return new String(cArray);
    }

    public String toString() {
        while (!this.eof) {
            this.readOneChar();
        }
        return this.substring(0, this.size);
    }

    static {
        $assertionsDisabled = !ReaderCharSequence.class.desiredAssertionStatus();
    }

    private final class SubCharSequence
    implements CharSequence {
        private final int start;
        private final int end;

        public SubCharSequence(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public char charAt(int n) {
            if (n < 0 || n >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return ReaderCharSequence.this.charAt(this.start + n);
        }

        public int length() {
            if (ReaderCharSequence.this.eof && this.start > ReaderCharSequence.this.size) {
                return 0;
            }
            if (ReaderCharSequence.this.eof && this.end > ReaderCharSequence.this.size) {
                return ReaderCharSequence.this.size - this.start;
            }
            return this.end - this.start;
        }

        public CharSequence subSequence(int n, int n2) {
            return new SubCharSequence(this.start + n, this.start + n2);
        }

        public String toString() {
            while (!ReaderCharSequence.this.eof && this.end > ReaderCharSequence.this.size) {
                ReaderCharSequence.this.readOneChar();
            }
            if (this.start > ReaderCharSequence.this.size) {
                return new String();
            }
            if (this.end > ReaderCharSequence.this.size) {
                return ReaderCharSequence.this.substring(this.start, ReaderCharSequence.this.size);
            }
            return ReaderCharSequence.this.substring(this.start, this.end);
        }
    }
}

