/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class FTPResponse {
    private int code;
    private String response;
    public static final int POSITIVE_PRELIMINARY = 1;
    public static final int POSITIVE_COMPLETION = 2;
    public static final int POSITIVE_INTERMEDIATE = 3;
    public static final int TRANSIENT_NEGATIVE_COMPLETION = 4;
    public static final int PERMANENT_NEGATIVE_COMPLETION = 5;

    public FTPResponse(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        String string2 = string.substring(0, 3);
        try {
            this.code = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.code = 0;
        }
        if (string.length() >= 4 && string.charAt(3) == '-') {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            do {
                string = bufferedReader.readLine();
                stringBuffer.append("\n");
                stringBuffer.append(string);
            } while (!string.startsWith(string2) || string.startsWith(string2 + "-"));
            this.response = stringBuffer.toString();
        } else {
            this.response = string;
        }
    }

    protected void writeLog(PrintWriter printWriter) {
        if (printWriter != null) {
            printWriter.println(this.response);
            printWriter.flush();
        }
    }

    public String getResponse() {
        return this.response;
    }

    public String toString() {
        return this.response;
    }

    public int getCode() {
        return this.code;
    }

    public int getFirstDigit() {
        return this.getCode() / 100;
    }

    public int getSecondDigit() {
        return this.getCode() % 100 / 10;
    }

    public int getThirdDigit() {
        return this.getCode() % 10;
    }

    public boolean isPositivePreliminary() {
        return this.getFirstDigit() == 1;
    }

    public boolean isPositiveCompletion() {
        return this.getFirstDigit() == 2;
    }

    public boolean isPositiveIntermediate() {
        return this.getFirstDigit() == 3;
    }

    public boolean isTransientNegativeCompletion() {
        return this.getFirstDigit() == 4;
    }

    public boolean isPermanentNegativeCompletion() {
        return this.getFirstDigit() == 5;
    }
}

