/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.DisconnectCallBack;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPDialogs;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPSettings;
import org.netbeans.modules.distributed.remotefs.ftpfs.FileStatusInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.LogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteCompileAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.RemoteExecuteAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.Sync;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPLogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.logs.FTPBrowserChildren;
import org.netbeans.modules.distributed.remotefs.ftpfs.logs.FTPBrowserNode;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.modules.InstalledFileLocator;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class FTPFileSystem
extends RemoteFileSystem
implements FTPClient.Reconnect,
AbstractNetworkFileSystem,
FileSystem.HtmlStatus,
LookupListener,
FileStatusListener {
    static final long serialVersionUID = -981665601872580022L;
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 1;
    private static final boolean DEBUG = true;
    private static final String FTPWORK = System.getProperty("netbeans.user") + File.separator + "ftpcache";
    private static RequestProcessor statusRequestProcessor;
    private static final Object STATUS_REQUEST_PROCESSOR_LOCK;
    private FTPSettings ftpsettings = (FTPSettings)SystemOption.findObject((Class)FTPSettings.class, (boolean)true);
    private Boolean useXtermCompile;
    private Boolean useXtermExecution;
    private int refCount;
    private RemoteRuntimeType remoteRuntimeType;
    private boolean justSerialized = false;
    private transient String hostName;
    private transient String userName;
    private transient Lookup.Result annotationProviders;
    private transient Collection previousProviders;
    private static final Pattern lt;
    private static final Pattern gt;

    public FTPFileSystem(String string, String string2, int n, String string3, String string4, boolean bl, boolean bl2) throws IOException {
        this.loginfo = new FTPLogInfo(string, n, string2, null);
        FTPClient.removeFromFailedAttempts(string, string2);
        this.cachedir = new File(string3);
        this.startdir = string4;
        this.SSHForwarding = bl;
        this.ftpPassiveMode = bl2;
        this.hostName = string;
        this.userName = string2;
        this.getFTPSettings().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FTPFileSystem.this.ftpSettingsChanged(propertyChangeEvent);
            }
        });
        this.addedFS((FileSystem)this);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        Object object;
        Object object2;
        HashSet hashSet;
        HashSet hashSet2 = this.annotationProviders.allInstances();
        if (this.previousProviders != null) {
            hashSet = new HashSet(hashSet2);
            hashSet.removeAll(this.previousProviders);
            object2 = new HashSet(this.previousProviders);
            ((AbstractSet)object2).removeAll(hashSet2);
            object = ((HashSet)object2).iterator();
            while (object.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)object.next();
                if (annotationProvider.getInterceptionListener() instanceof FileChangeListener) {
                    this.removeFileChangeListener((FileChangeListener)annotationProvider.getInterceptionListener());
                }
                annotationProvider.removeFileStatusListener((FileStatusListener)this);
            }
        } else {
            hashSet = hashSet2;
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (AnnotationProvider)object2.next();
            if (object.getInterceptionListener() instanceof FileChangeListener) {
                this.addFileChangeListener((FileChangeListener)object.getInterceptionListener());
            }
            try {
                object.addFileStatusListener((FileStatusListener)this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                ErrorManager.getDefault().notify((Throwable)tooManyListenersException);
            }
        }
        this.previousProviders = hashSet2;
    }

    public static void refreshFTPLogs() {
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("UI/Runtime");
            DataFolder dataFolder = (DataFolder)DataObject.find((FileObject)fileObject);
            Lookup lookup = new FolderLookup((DataObject.Container)dataFolder).getLookup();
            FTPBrowserNode fTPBrowserNode = (FTPBrowserNode)((Object)lookup.lookup(FTPBrowserNode.class));
            ((FTPBrowserChildren)fTPBrowserNode.getChildren()).refreshKeys2();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SystemAction[] getActions(Set set) {
        AnnotationProvider annotationProvider;
        Action[] actionArray = null;
        Iterator iterator = this.annotationProviders.allInstances().iterator();
        while (actionArray == null && iterator.hasNext()) {
            annotationProvider = (AnnotationProvider)iterator.next();
            actionArray = annotationProvider.actions(set);
        }
        if (actionArray == null) {
            actionArray = new Action[]{};
        }
        annotationProvider = new SystemAction[actionArray.length];
        for (int i = 0; i < actionArray.length; ++i) {
            annotationProvider[i] = (SystemAction)actionArray[i];
        }
        SystemAction[] systemActionArray = super.getActions();
        SystemAction[] systemActionArray2 = new SystemAction[systemActionArray.length + ((AnnotationProvider)annotationProvider).length + 2];
        System.arraycopy(systemActionArray, 0, systemActionArray2, 0, systemActionArray.length);
        SystemAction[] systemActionArray3 = new SystemAction[]{SystemAction.get((Class)RemoteCompileAction.class), SystemAction.get((Class)RemoteExecuteAction.class)};
        System.arraycopy(systemActionArray3, 0, systemActionArray2, systemActionArray.length, 2);
        System.arraycopy(annotationProvider, 0, systemActionArray2, systemActionArray.length + 2, ((AnnotationProvider)annotationProvider).length);
        return systemActionArray2;
    }

    public SystemAction[] getActions() {
        SystemAction[] systemActionArray = super.getActions();
        SystemAction[] systemActionArray2 = new SystemAction[systemActionArray.length + 2];
        System.arraycopy(systemActionArray, 0, systemActionArray2, 0, systemActionArray.length);
        SystemAction[] systemActionArray3 = new SystemAction[]{SystemAction.get((Class)RemoteCompileAction.class), SystemAction.get((Class)RemoteExecuteAction.class)};
        System.arraycopy(systemActionArray3, 0, systemActionArray2, systemActionArray.length, 2);
        return systemActionArray2;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        RemoteRuntimeType remoteRuntimeType = DistributedSettings.getDefault().findRemoteRuntime(this.hostName, this.userName);
        return remoteRuntimeType;
    }

    public boolean getUseXtermCompile() {
        if (this.useXtermCompile == null) {
            return DistributedSettings.getDefault().getUseXtermCompile();
        }
        return this.useXtermCompile;
    }

    public void setUseXtermCompile(boolean bl) {
        this.useXtermCompile = new Boolean(bl);
        this.firePropertyChange("useXtermCompile", null, this.useXtermCompile);
    }

    public boolean getUseXtermExecution() {
        if (this.useXtermExecution == null) {
            return DistributedSettings.getDefault().getUseXtermExecution();
        }
        return this.useXtermExecution;
    }

    public void setUseXtermExecution(boolean bl) {
        this.useXtermExecution = new Boolean(bl);
        this.firePropertyChange("useXtermExecution", null, this.useXtermExecution);
    }

    public String getRemoteRoot() {
        return this.getRootFile();
    }

    public String getLocalRoot() {
        return this.getCache().getAbsolutePath();
    }

    private void deleteClientFiles(File file, String string) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                this.deleteClientFiles(fileArray[i], string + "/" + file.getAbsolutePath());
            }
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getAbsolutePath());
            file.delete();
        } else {
            StatusDisplayer.getDefault().setStatusText("Deleting " + file.getAbsolutePath());
            if (file.delete()) {
                this.setFileAttribute(string, "ftp_cache_lastmodified", null);
                this.setFileAttribute(string, "ftp_remote_lastmodified", null);
                this.setFileAttribute(string, "file_residence_mode", null);
            }
        }
    }

    private void deleteServerFiles(RemoteFileName remoteFileName, String string) throws IOException {
        if (remoteFileName.isDirectory()) {
            RemoteFileAttributes[] remoteFileAttributesArray = this.client.list(remoteFileName);
            for (int i = 0; remoteFileAttributesArray != null && i < remoteFileAttributesArray.length; ++i) {
                this.deleteServerFiles(remoteFileAttributesArray[i].getName(), string + "/" + remoteFileAttributesArray[i].getName().getName());
            }
            StatusDisplayer.getDefault().setStatusText("Deleting " + remoteFileName.getFullName());
            this.client.rmdir(remoteFileName);
        } else {
            StatusDisplayer.getDefault().setStatusText("Deleting " + remoteFileName.getFullName());
            this.client.delete(remoteFileName);
            this.setFileAttribute(string, "ftp_cache_lastmodified", null);
            this.setFileAttribute(string, "ftp_remote_lastmodified", null);
            this.setFileAttribute(string, "file_residence_mode", null);
        }
    }

    public void delete(String string) throws IOException {
        FTPFileName fTPFileName;
        RemoteFileAttributes remoteFileAttributes;
        if ((string = string.replace('/', '\\')).endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || string.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
            new File(this.getLocalRoot(), string).delete();
            return;
        }
        this.isReadyToModify();
        File file = new File(this.getLocalRoot(), string);
        boolean bl = file.isDirectory();
        this.deleteClientFiles(file, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("REMOTE_ROOT", this.getRemoteRoot());
        hashMap.put("LCOAL_ROOT", this.getCache().getAbsolutePath());
        String string2 = FileUtility.winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, hashMap);
        string2 = FileUtility.openVMSPathToUnixPath((String)string2, (boolean)false);
        if (string2.endsWith(".")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((remoteFileAttributes = this.client.listFile("", fTPFileName = new FTPFileName("", string2, bl))) != null && remoteFileAttributes.getDate().getTime() != 0L) {
            if (remoteFileAttributes.isDirectory()) {
                this.deleteServerFiles(new FTPFileName("", string2, true), string);
            } else {
                this.deleteServerFiles(new FTPFileName("", string2, false), string);
            }
        }
    }

    public static void refreshParent(String string, String string2, char c, FileSystem fileSystem) {
        String string3 = string.substring(string2.length() + 1);
        string3 = string3.lastIndexOf(c) > 0 ? string3.substring(0, string3.lastIndexOf(c)).replace(c, '/') : "";
        FileObject fileObject = fileSystem.findResource(string3);
        if (fileObject != null) {
            fileObject.refresh();
        }
    }

    public static File toFile(FileObject fileObject) {
        return (File)fileObject.getAttribute("java.io.File");
    }

    public Date lastModified(String string) {
        return super.lastModified(string);
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void addNotify() {
        super.addNotify();
        this.incRefCount();
        try {
            super.addedFS((FileSystem)this);
            FTPFileSystem.refreshFTPLogs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
    }

    public void removeNotify() {
        super.removeNotify();
        this.decRefCount();
        super.removedFS((FileSystem)this);
        FTPFileSystem.refreshFTPLogs();
    }

    public void addedFS(FileSystem fileSystem) throws IOException {
        if (fileSystem == this) {
            try {
                if (!this.getSystemName().equals(this.computeSystemName())) {
                    this.setSystemName(this.computeSystemName());
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
            super.addedFS(fileSystem);
            this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
            this.annotationProviders.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }
    }

    protected void ftpSettingsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("passivemode") && this.client != null) {
            ((FTPClient)this.client).setPassiveMode((Boolean)propertyChangeEvent.getNewValue());
        }
        if (propertyChangeEvent.getPropertyName().equals("refreshtime")) {
            this.setRefreshTime((Integer)propertyChangeEvent.getNewValue());
        }
    }

    protected FTPSettings getFTPSettings() {
        if (this.ftpsettings == null) {
            this.ftpsettings = (FTPSettings)SystemOption.findObject((Class)FTPSettings.class, (boolean)true);
        }
        return this.ftpsettings;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hostName = ((FTPLogInfo)this.loginfo).getHost();
        this.userName = ((FTPLogInfo)this.loginfo).getUser();
        ((FTPLogInfo)this.loginfo).clearStringPassword();
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeType();
        if (remoteRuntimeType == null) {
            return;
        }
        if (this.password == null) {
            this.password = this.getOrPromptforPassword();
        }
        ((FTPLogInfo)this.loginfo).setPassword(this.password);
        this.client = this.createClient(this.loginfo, this.cachedir, this.startdir);
        this.justSerialized = true;
        this.annotationProviders = Lookup.getDefault().lookup(new Lookup.Template(AnnotationProvider.class));
        this.annotationProviders.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void setFtpSocketTimeout(int n) throws PropertyVetoException {
    }

    public int getFtpSocketTimeout() {
        if (this.getRemoteRuntimeType() == null) {
            return DistributedSettings.getDefault().getSvrTimeOut() * 1000;
        }
        return this.getRemoteRuntimeType().getSvrTimeOut() * 1000;
    }

    public void setFtpPassiveMode(boolean bl) throws PropertyVetoException {
        if (bl != this.ftpPassiveMode) {
            this.ftpPassiveMode = bl;
            this.firePropertyChange("ftpPassiveMode", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
            this.propChanged();
        }
    }

    public boolean getFtpPassiveMode() {
        return this.ftpPassiveMode;
    }

    public void setSSHForwarding(boolean bl) throws PropertyVetoException {
        if (bl != this.SSHForwarding) {
            this.SSHForwarding = bl;
            this.firePropertyChange("SSHForwarding", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
            this.propChanged();
        }
    }

    public boolean getSSHForwarding() {
        return this.SSHForwarding;
    }

    private String computeSystemName() {
        String string = this.getCache().getAbsolutePath();
        return string.replaceAll("\\\\|\\.|:", "#");
    }

    private String getDefaultCache() {
        return FTPWORK + File.separator + ((FTPLogInfo)this.loginfo).getHost() + (((FTPLogInfo)this.loginfo).getPort() == 21 ? "" : "_" + String.valueOf(((FTPLogInfo)this.loginfo).getPort())) + "_" + ((FTPLogInfo)this.loginfo).getUser();
    }

    private boolean cacheAlreadyMounted(File file) throws IOException {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        Iterator iterator = OpenProjectList.getFsSet().iterator();
        while (iterator.hasNext()) {
            String string;
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (!(fileSystem instanceof LocalFileSystem && !(fileSystem instanceof AbstractNetworkFileSystem) ? (string = ((LocalFileSystem)fileSystem).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(file.getAbsolutePath()) : fileSystem instanceof AbstractNetworkFileSystem && (string = ((AbstractNetworkFileSystem)fileSystem).getLocalRoot()).equalsIgnoreCase(file.getAbsolutePath()))) continue;
            return true;
        }
        return false;
    }

    public void setCache(File file) throws PropertyVetoException, IOException {
        if (this.cacheAlreadyMounted(file)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"The selected FTP local root directory does not exist or is already being used\nas the local root directory for another FTP file system.\nPlease choose a different FTP local root directory or\nunmount the filesystem that is using the selected directory", 2));
            throw new IOException("selected FTP local directory is not valid");
        }
        if (!file.canWrite() || !file.canRead()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Can't read or write to the selected FTP local root directory", 2));
            throw new IOException("selected FTP local directory is not valid");
        }
        this.cachedir = file;
        String string = this.getDisplayName();
        this.setSystemName(this.computeSystemName());
        this.firePropertyChange("displayName", null, this.getDisplayName());
        this.propChanged();
    }

    protected RemoteFile createRootFile(RemoteClient remoteClient, File file) throws IOException {
        FTPFileName fTPFileName = new FTPFileName("", FileUtility.openVMSPathToUnixPath((String)this.getStartdir(), (boolean)true), true);
        RemoteFileAttributes remoteFileAttributes = new RemoteFileAttributes(fTPFileName, true);
        return new RemoteFile(remoteFileAttributes, null, remoteClient, this, this, file, true, this);
    }

    public File getCache() {
        return this.cachedir;
    }

    public String getServer() {
        return ((FTPLogInfo)this.loginfo).getHost();
    }

    public void setServer(String string) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setHost(string);
        this.ftpsettings.setHostName(string);
        this.propChanged();
    }

    public int getPort() {
        return ((FTPLogInfo)this.loginfo).getPort();
    }

    public void setPort(int n) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setPort(n);
        this.ftpsettings.setFTPPort(n);
        this.propChanged();
    }

    public String getUsername() {
        return ((FTPLogInfo)this.loginfo).getUser();
    }

    public void setUsername(String string) throws PropertyVetoException {
        ((FTPLogInfo)this.loginfo).setUser(string);
        this.ftpsettings.setUserName(string);
        this.propChanged();
    }

    public String getStartdir() {
        return this.startdir;
    }

    public void setStartdir(String string) throws PropertyVetoException, IOException {
        String string2 = string;
        if (string == null || string.equals("/") || string.equals("")) {
            string2 = "/";
        } else {
            if (!string.startsWith("/")) {
                string2 = string;
            }
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        this.startdir = string2;
    }

    private void propChanged() throws PropertyVetoException {
        this.connectOnBackground();
    }

    public RemoteClient createClient(LogInfo logInfo, File file, String string) throws IOException {
        File file2;
        if (!this.cachedir.exists()) {
            this.cachedir.mkdirs();
        }
        if ((file2 = InstalledFileLocator.getDefault().locate("distributed", null, false)) != null) {
            file2 = new File(file2, "ftp_" + System.getProperty("user.name") + ".log");
            file2.createNewFile();
        }
        FTPClient fTPClient = new FTPClient((FTPLogInfo)logInfo, string, new DisconnectCallBack(){

            public void disconnected() {
                FTPFileSystem.this.firePropertyChange("displayName", null, FTPFileSystem.this.getDisplayName());
            }
        });
        fTPClient.setLog(file2);
        fTPClient.setPassiveMode(this.getFtpPassiveMode());
        fTPClient.setSSHForward(this.getSSHForwarding());
        fTPClient.setSocketTimeout(this.getFtpSocketTimeout());
        this.rootFile = this.createRootFile(fTPClient, file);
        return fTPClient;
    }

    public FTPClient getClient() {
        return (FTPClient)this.client;
    }

    protected void isReadyToModify() throws IOException {
        if (this.client == null) {
            super.addedFS((FileSystem)this);
        } else if (this.rootFile == null) {
            throw new IOException("Connection to server " + this.getServer() + " isn't established");
        }
        if (!this.isConnected() && !this.isOfflineChanges()) {
            throw new IOException("Modification in offline mode are not allowed");
        }
    }

    protected void isReadyToRead() throws IOException {
        if (this.client == null || this.rootFile == null) {
            throw new IOException("Connection to server " + this.getServer() + " isn't established" + (this.client == null) + (this.rootFile == null));
        }
    }

    public String[] children(String string) {
        if (this.justSerialized) {
            try {
                super.addedFS((FileSystem)this);
                this.justSerialized = false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.children(string);
    }

    protected boolean isReady() {
        return this.client != null && this.rootFile != null;
    }

    protected int disconnectDialog(String string) {
        return FTPDialogs.disconnect(string);
    }

    protected boolean connectDialog(String string) {
        return FTPDialogs.connect(string);
    }

    protected void startdirNotFound(String string, String string2, String string3) {
        FTPDialogs.startdirNotFound(string, string2, string3);
    }

    protected void errorConnect(String string, String string2) {
        FTPDialogs.ftpConnectionError(string, string2);
    }

    public void notifyIncorrectPassword() {
        FTPDialogs.incorrectPassword(this.getServer());
    }

    public boolean notifyIncorrectCache(File file) {
        return FTPDialogs.incorrectCache(this.getCache().getPath(), file.getPath(), this.getServer());
    }

    public boolean notifyReconnect(String string) {
        return true;
    }

    public int notifyWhichFile(String string, Date date, long l, Date date2, long l2) {
        return 1;
    }

    public int notifyBothFilesChanged(String string, Date date, long l, Date date2, long l2) {
        return 0;
    }

    public boolean isRefreshServer() {
        return this.getFTPSettings().isRefreshServer();
    }

    public boolean isScanCache() {
        return this.getFTPSettings().isScanCache();
    }

    public boolean isAlwaysRefresh() {
        return this.getFTPSettings().isRefreshAlways();
    }

    public void setAlwaysRefresh(boolean bl) {
        this.getFTPSettings().setRefreshAlways(bl);
    }

    public boolean isDownloadServerChangedFile() {
        return this.getFTPSettings().isDownloadServerChangedFile();
    }

    public boolean isOfflineChanges() {
        return this.getFTPSettings().isOfflineChanges();
    }

    public boolean notifyServerChanged(String string, Date date, long l, Date date2, long l2) {
        return true;
    }

    public boolean notifyCacheExtDelete(String string, boolean bl) {
        return false;
    }

    public boolean notifyServerExtDelete(String string, boolean bl) {
        return false;
    }

    public void fileChanged(String string) {
        FileObject fileObject = this.findResource(string);
        if (fileObject != null) {
            fileObject.refresh();
        }
    }

    public void notifyException(Exception exception) {
        ErrorManager.getDefault().notify((Throwable)exception);
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.getLocalRoot());
    }

    public FileObject findExistingResource(String string) {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        FileObject fileObject = null;
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string.equalsIgnoreCase(fileObject2.getPath())) continue;
            fileObject = fileObject2;
            break;
        }
        return fileObject;
    }

    public void statusChanged(String string) {
        FileObject fileObject;
        FileObject fileObject2 = this.findExistingResource(string);
        if (fileObject2 == null) {
            return;
        }
        Enumeration enumeration = this.existingFileObjects(fileObject2);
        HashSet hashSet = new HashSet();
        if (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        while (enumeration.hasMoreElements() && fileObject2.equals((fileObject = (FileObject)enumeration.nextElement()).getParent())) {
            hashSet.add(fileObject);
        }
        fileObject = Collections.synchronizedSet(hashSet);
    }

    public void annotationChanged(FileStatusEvent fileStatusEvent) {
        this.fireFileStatusChanged(fileStatusEvent);
    }

    public String annotateName(String string, Set set) {
        String string2;
        block28: {
            string2 = string;
            if (string2 == null) {
                return string2;
            }
            if (this.getLocalRoot().equals(string) || string.equals("")) {
                String string3 = "";
                if (!this.isConnected()) {
                    string3 = "<offline> ";
                }
                this.firePropertyChange("displayName", null, string3 + this.getDisplayName());
                return string3 + this.getDisplayName();
            }
            int n = set.size();
            if (n == 0 || string.indexOf(this.getLocalRoot()) >= 0) {
                return string2;
            }
            ArrayList arrayList = new ArrayList(set);
            n = arrayList.size();
            if (n == 1) {
                String string4;
                string2 = string4 = ((FileObject)arrayList.get(0)).getNameExt();
                try {
                    if (this.rootFile == null) break block28;
                    RemoteFile remoteFile = this.getRemoteFile(((FileObject)arrayList.get(0)).getPath());
                    if (remoteFile != null) {
                        string2 = remoteFile.getName().getName();
                    }
                    if (remoteFile != null && !remoteFile.getRemoteFS().getDisplayStatus()) {
                        return string2;
                    }
                    if (!((FileObject)arrayList.get(0)).isFolder()) {
                        if (remoteFile != null) {
                            if (((FileObject)arrayList.get(0)).getExt().toLowerCase().equals("xml")) {
                                remoteFile.setMimeType("text");
                            } else if (this.getAsciiFileExts().isRegistered(((FileObject)arrayList.get(0)).getExt().toLowerCase())) {
                                remoteFile.setMimeType("text");
                            } else {
                                String string5 = FileUtil.getMIMEType((FileObject)((FileObject)arrayList.get(0)));
                                remoteFile.setMimeType(string5);
                            }
                            string2 = string2 + " [" + remoteFile.getStatusString() + "]";
                        }
                        break block28;
                    }
                    string2 = string;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            } else {
                Sync.SyncState syncState = null;
                Sync.SyncState syncState2 = null;
                String string6 = "[";
                RemoteFile remoteFile = null;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    FileObject fileObject = (FileObject)iterator.next();
                    try {
                        if (this.rootFile == null) continue;
                        RemoteFile remoteFile2 = this.getRemoteFile(fileObject.getPath());
                        if (remoteFile == null) {
                            remoteFile = remoteFile2;
                        }
                        if (remoteFile2 != null && !remoteFile2.getRemoteFS().getDisplayStatus()) {
                            return string2;
                        }
                        if (fileObject.isFolder() || remoteFile2 == null) continue;
                        String string7 = null;
                        if (fileObject.getExt().toLowerCase().equals("form")) {
                            string7 = "text";
                        } else if (fileObject.getExt().toLowerCase().equals("xml")) {
                            string7 = "text";
                        } else if (this.getAsciiFileExts().isRegistered(fileObject.getExt())) {
                            remoteFile2.setMimeType("text");
                        } else {
                            string7 = FileUtil.getMIMEType((FileObject)fileObject);
                        }
                        remoteFile2.setMimeType(string7);
                        syncState = syncState == null ? remoteFile2.getClientStatus() : remoteFile2.getClientStatus().getSevererStatus(syncState);
                        Sync.SyncState syncState3 = syncState2 = syncState2 == null ? remoteFile2.getServerStatus() : remoteFile2.getServerStatus().getSevererStatus(syncState2);
                        if (!remoteFile2.getName().getName().endsWith(".java")) continue;
                        remoteFile = remoteFile2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
                if (remoteFile != null) {
                    string = remoteFile.getName().getName();
                }
                string2 = string + " [" + (syncState == null ? "" : syncState.toString() + "*") + "|" + (syncState2 == null ? "" : syncState2.toString() + "*") + "]";
            }
        }
        return string2;
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public void pubFireFileStatusChanged(Set set) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, set, true, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestProcessor getStatusChangeRequestProcessor() {
        Object object = STATUS_REQUEST_PROCESSOR_LOCK;
        synchronized (object) {
            if (statusRequestProcessor == null) {
                statusRequestProcessor = new RequestProcessor("FTP FS Status Update Request Processor");
            }
        }
        return statusRequestProcessor;
    }

    public void statusChanged(final String string, final boolean bl) {
        FTPFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fileObject;
                FileObject fileObject2 = FTPFileSystem.this.findExistingResource(string);
                if (fileObject2 == null) {
                    return;
                }
                Enumeration enumeration = FTPFileSystem.this.existingFileObjects(fileObject2);
                HashSet hashSet = new HashSet();
                if (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
                while (enumeration.hasMoreElements()) {
                    fileObject = (FileObject)enumeration.nextElement();
                    if (!bl && !fileObject2.equals(fileObject.getParent())) break;
                    hashSet.add(fileObject);
                }
                fileObject = Collections.synchronizedSet(hashSet);
                FTPFileSystem.this.fireFileStatusChanged(new FileStatusEvent((FileSystem)FTPFileSystem.this, (Set)fileObject, true, true));
            }
        });
    }

    private static String htmlEncode(String string) {
        String string2 = string;
        if (string2.indexOf(60) != -1) {
            string2 = lt.matcher(string2).replaceAll("&lt;");
        }
        if (string2.indexOf(62) != -1) {
            string2 = gt.matcher(string2).replaceAll("&gt;");
        }
        return string2;
    }

    public String annotateNameHtml(String string, Set set) {
        string = FTPFileSystem.htmlEncode(string);
        string = this.annotateName(string, set);
        String string2 = null;
        Iterator iterator = this.annotationProviders.allInstances().iterator();
        while (string2 == null && iterator.hasNext()) {
            AnnotationProvider annotationProvider = (AnnotationProvider)iterator.next();
            string2 = annotationProvider.annotateNameHtml(string, set);
        }
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public Image annotateIcon(Image image, int n, Set set) {
        Object object;
        Object[] objectArray = set.toArray();
        int n2 = objectArray.length;
        Image image2 = null;
        if (n2 == 0) {
            return image;
        }
        ArrayList arrayList = new ArrayList(set);
        n2 = arrayList.size();
        FileObject fileObject = (FileObject)arrayList.get(0);
        Image image3 = null;
        if (this.annotationProviders != null) {
            object = this.annotationProviders.allInstances().iterator();
            while (image3 == null && object.hasNext()) {
                AnnotationProvider annotationProvider = (AnnotationProvider)object.next();
                image3 = annotationProvider.annotateIcon(image, n, set);
            }
            if (image3 != null) {
                image = image3;
            }
        }
        try {
            if ("".equals(fileObject.getName()) && fileObject.isFolder()) {
                image2 = this.isConnected() ? FileStatusInfo.REMOTE_PRJ.getIcon() : FileStatusInfo.REMOTE_PRJ_GREY.getIcon();
                image = Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)1);
                return image;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (((FileObject)arrayList.get(0)).isFolder()) {
            return image;
        }
        try {
            if (this.rootFile != null && (object = this.getRemoteFile(((FileObject)arrayList.get(0)).getPath())) != null) {
                if (((RemoteFile)object).getFileResidenceMode() != 1) {
                    if (((RemoteFile)object).getFileResidenceMode() != 0 && Sync.getAction(((RemoteFile)object).getClientStatus(), ((RemoteFile)object).getServerStatus()) == Sync.SyncAction.conflict_dialog) {
                        image2 = FileStatusInfo.OUT_OF_DATE.getIcon();
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        if (image2 != null) {
            image = Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)1);
        }
        return image;
    }

    public final String getDisplayName() {
        return this.getServer() + " " + this.getCache();
    }

    public FileObject getFSRoot() {
        return this.getRoot();
    }

    public void copyReadableProps(FTPFileSystem fTPFileSystem) {
        try {
            this.setReadOnly(fTPFileSystem.isReadOnly());
            this.setSSHForwarding(fTPFileSystem.getSSHForwarding());
            this.setAsciiFileExts(fTPFileSystem.getAsciiFileExts());
            this.setAutoSync(fTPFileSystem.getAutoSync());
            this.setBackupExtensions(fTPFileSystem.getBackupExtensions());
            this.setDisplayStatus(fTPFileSystem.getDisplayStatus());
            this.setFtpPassiveMode(fTPFileSystem.getFtpPassiveMode());
            this.setHidden(fTPFileSystem.isHidden());
            this.setIgnoreHiddenFiles(fTPFileSystem.getIgnoreHiddenFiles());
            this.setIgnoredFiles(fTPFileSystem.getIgnoredFiles());
            this.setIgnoredFolders(fTPFileSystem.getIgnoredFolders());
            this.setServerOnlyFileExts(fTPFileSystem.getServerOnlyFileExts());
            this.setXDisplayDeviceNumber(fTPFileSystem.getXDisplayDeviceNumber());
            this.setUseXtermCompile(fTPFileSystem.getUseXtermCompile());
            this.setUseXtermExecution(fTPFileSystem.getUseXtermExecution());
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    static {
        STATUS_REQUEST_PROCESSOR_LOCK = new Object();
        lt = Pattern.compile("<");
        gt = Pattern.compile(">");
    }
}

