/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.SimpleTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SimpleTargetChooserPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final List listeners = new ArrayList();
    private SimpleTargetChooserPanelGUI gui;
    private Project project;
    private SourceGroup[] folders;
    private WizardDescriptor.Panel bottomPanel;
    private WizardDescriptor wizard;
    private boolean isFolder;

    SimpleTargetChooserPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel bottomPanel, boolean isFolder) {
        this.folders = folders;
        this.project = project;
        this.bottomPanel = bottomPanel;
        if (bottomPanel != null) {
            bottomPanel.addChangeListener((ChangeListener)this);
        }
        this.isFolder = isFolder;
        this.gui = null;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new SimpleTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.isFolder);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx bottomHelp;
        if (this.bottomPanel != null && (bottomHelp = this.bottomPanel.getHelp()) != null) {
            return bottomHelp;
        }
        return null;
    }

    public boolean isValid() {
        boolean ok;
        boolean bl = ok = this.gui != null && this.gui.getTargetName() != null && (this.bottomPanel == null || this.bottomPanel.isValid());
        if (!ok) {
            return false;
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        String errorMessage = ProjectUtilities.canUseFileName(this.gui.getTargetGroup().getRootFolder(), this.gui.getTargetFolder(), this.gui.getTargetName(), template.getExt(), this.isFolder);
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        return errorMessage == null;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList templist;
        ChangeEvent e = new ChangeEvent(this);
        SimpleTargetChooserPanel simpleTargetChooserPanel = this;
        synchronized (simpleTargetChooserPanel) {
            templist = new ArrayList(this.listeners);
        }
        Iterator it = templist.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    public void readSettings(Object settings) {
        this.wizard = (WizardDescriptor)settings;
        if (this.gui == null) {
            this.getComponent();
        }
        FileObject preselectedTarget = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), preselectedTarget, targetName);
        Object substitute = this.gui.getClientProperty("NewFileWizard_Title");
        if (substitute != null) {
            this.wizard.putProperty("NewFileWizard_Title", substitute);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle((Class)SimpleTargetChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle((Class)SimpleTargetChooserPanel.class).getString("LBL_SimpleTargetChooserPanel_Name")});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings(settings);
        }
    }

    public void storeSettings(Object settings) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)settings).getValue())) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings(settings);
            }
            FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
            String name = this.gui.getTargetName();
            if (name.indexOf(47) > 0) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)settings), (FileObject)this.getTargetFolderFromGUI());
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)settings), (String)name);
        }
        ((WizardDescriptor)settings).putProperty("NewFileWizard_Title", null);
    }

    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private FileObject getTargetFolderFromGUI() {
        FileObject targetFolder;
        FileObject rootFolder = this.gui.getTargetGroup().getRootFolder();
        String folderName = this.gui.getTargetFolder();
        String newObject = this.gui.getTargetName();
        if (newObject.indexOf(47) > 0) {
            String path = newObject.substring(0, newObject.lastIndexOf(47));
            folderName = folderName == null || "".equals(folderName) ? path : folderName + '/' + path;
        }
        if ((targetFolder = folderName == null ? rootFolder : rootFolder.getFileObject(folderName)) == null) {
            try {
                targetFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return targetFolder;
    }
}

