/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.distributed.common.util.RMIMethodInvoker;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.rmi.impl.ServerOutputImpl;
import org.netbeans.modules.distributed.rmi.protocol.Admin;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.netbeans.modules.distributed.rmi.protocol.RemoteLoginServer;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.rmi.protocol.SecurityContext;
import org.netbeans.modules.distributed.rmi.protocol.ServerOutput;
import org.netbeans.modules.distributed.ssl.DistNBClientSocketFactory;

public class RemoteLoginClient
implements Serializable {
    private static final int SVR_TIME_OUT = 60000;
    private static final int SVR_TIME_OUT_DELTA = 10000;
    private static final String CONNECT_FAIL_MSG = "Connection attempt timed out. Please try again.";
    private SecurityContext sci;
    private transient RemoteLoginServer loginServer;
    private transient RemoteRuntime rt;
    private transient RemoteFileService remoteFileService;
    private String server;
    private int port;
    private HashMap loginInfo;
    private transient ServerOutput svrOutput;
    private transient ArrayList extraBucket = new ArrayList(2);
    private transient boolean isTimedOut = false;
    private boolean connected = false;
    private boolean connecting = false;
    private String errorMsg;
    private final String remoteLoginServerName = System.getProperty("org.netbeans.modules.distributed.client.loginServer", "DistNBRemoteLoginServer");
    private long lastTimeServerAlive;
    private VMID uniqueID;

    public synchronized boolean isConnected() {
        return this.findRemoteRuntime() != null;
    }

    public synchronized boolean isConnecting() {
        return this.connecting;
    }

    public String authenticate(HashMap hashMap, String string, int n) {
        try {
            Registry registry = LocateRegistry.getRegistry(string, n, new DistNBClientSocketFactory());
            RemoteLoginServer remoteLoginServer = (RemoteLoginServer)registry.lookup(this.remoteLoginServerName);
            return remoteLoginServer.authenticate(hashMap);
        }
        catch (NotBoundException notBoundException) {
            return notBoundException.getMessage();
        }
        catch (RemoteException remoteException) {
            return remoteException.getMessage();
        }
    }

    public String getUserUAIInfo(HashMap hashMap, String string, int n) {
        try {
            Registry registry = LocateRegistry.getRegistry(string, n, new DistNBClientSocketFactory());
            RemoteLoginServer remoteLoginServer = (RemoteLoginServer)registry.lookup(this.remoteLoginServerName);
            return remoteLoginServer.checkUserSysInfo(hashMap);
        }
        catch (NotBoundException notBoundException) {
            return notBoundException.getMessage();
        }
        catch (RemoteException remoteException) {
            return remoteException.getMessage();
        }
    }

    public String getUserEnv(HashMap hashMap, String string, int n) {
        try {
            Registry registry = LocateRegistry.getRegistry(string, n, new DistNBClientSocketFactory());
            RemoteLoginServer remoteLoginServer = (RemoteLoginServer)registry.lookup(this.remoteLoginServerName);
            return remoteLoginServer.checkUserEnv(hashMap);
        }
        catch (NotBoundException notBoundException) {
            return notBoundException.getMessage();
        }
        catch (RemoteException remoteException) {
            return remoteException.getMessage();
        }
    }

    public String canFindLoginServer(String string, int n) {
        try {
            Registry registry = LocateRegistry.getRegistry(string, n, new DistNBClientSocketFactory());
            RemoteLoginServer remoteLoginServer = (RemoteLoginServer)registry.lookup(this.remoteLoginServerName);
        }
        catch (NotBoundException notBoundException) {
            return notBoundException.getMessage();
        }
        catch (RemoteException remoteException) {
            return remoteException.getMessage();
        }
        return "success";
    }

    public boolean isServerTimedOut() {
        return this.isTimedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(HashMap hashMap, String string, int n) {
        Object object = this;
        synchronized (object) {
            this.close();
            this.connecting = true;
            this.connected = false;
        }
        this.server = string;
        this.port = n;
        this.loginInfo = hashMap;
        this.errorMsg = null;
        this.isTimedOut = false;
        try {
            Object object2;
            object = LocateRegistry.getRegistry(string, n, new DistNBClientSocketFactory());
            try {
                this.loginServer = (RemoteLoginServer)object.lookup(this.remoteLoginServerName);
            }
            catch (NotBoundException notBoundException) {
                this.loginServer = (RemoteLoginServer)object.lookup("rmi://" + InetAddress.getByName(string).getHostAddress() + ":" + n + "/" + this.remoteLoginServerName);
            }
            this.svrOutput = new ServerOutputImpl();
            StringBuffer stringBuffer = new StringBuffer();
            if (RMIMethodInvoker.connect((RemoteLoginServer)this.loginServer, (HashMap)hashMap, (ServerOutput)this.svrOutput, (StringBuffer)stringBuffer)) {
                this.sci = (SecurityContext)this.svrOutput.getOutput();
            } else {
                this.extraBucket.add(this.svrOutput);
                if (stringBuffer.length() == 0) {
                    object2 = CONNECT_FAIL_MSG;
                    this.isTimedOut = true;
                } else {
                    object2 = stringBuffer.toString();
                }
                ((ServerOutputImpl)this.svrOutput).setClientInitiatedServerError((String)object2);
                this.sci = null;
            }
            object2 = this;
            synchronized (object2) {
                this.connecting = false;
                this.remoteFileService = null;
                if (this.sci != null) {
                    this.connected = true;
                    this.uniqueID = new VMID();
                    return true;
                }
                this.connected = false;
                this.errorMsg = this.svrOutput.getMessage();
                this.svrOutput = null;
                return false;
            }
        }
        catch (NotBoundException notBoundException) {
            this.errorMsg = notBoundException.getMessage();
            RemoteLoginClient remoteLoginClient = this;
            synchronized (remoteLoginClient) {
                this.connecting = false;
            }
            return false;
        }
        catch (RemoteException remoteException) {
            this.errorMsg = remoteException.getMessage();
            RemoteLoginClient remoteLoginClient = this;
            synchronized (remoteLoginClient) {
                this.connecting = false;
            }
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            this.errorMsg = unknownHostException.getMessage();
            RemoteLoginClient remoteLoginClient = this;
            synchronized (remoteLoginClient) {
                this.connecting = false;
            }
            return false;
        }
    }

    public RemoteFileService getRemoteFileService() {
        if (this.remoteFileService == null) {
            try {
                this.rt = this.findRemoteRuntime();
                this.remoteFileService = this.rt.getRemoteFileService();
                return this.remoteFileService;
            }
            catch (RemoteException remoteException) {
                this.errorMsg = remoteException.getMessage();
                return null;
            }
        }
        return this.remoteFileService;
    }

    private void sendKeepAlive() throws RemoteException {
    }

    public void keepServerAlive() {
        KeepServerAlive keepServerAlive = new KeepServerAlive(DistributedSettings.getDefault().getTimeOut());
        keepServerAlive.setDaemon(true);
        keepServerAlive.start();
    }

    private void findRemoteRuntimeImpl() throws NotBoundException, RemoteException, UnknownHostException {
        Registry registry = LocateRegistry.getRegistry(this.server, this.port, new DistNBClientSocketFactory());
        try {
            this.rt = (RemoteRuntime)registry.lookup(this.sci.getRemoteRuntimeID());
        }
        catch (NotBoundException notBoundException) {
            this.rt = (RemoteRuntime)registry.lookup("rmi://" + InetAddress.getByName(this.server).getHostAddress() + ":" + this.port + "/" + this.sci.getRemoteRuntimeID());
        }
    }

    public synchronized RemoteRuntime findRemoteRuntimeServerSafe() {
        try {
            if (this.connected) {
                this.findRemoteRuntimeImpl();
                if (this.rt != null && this.sci != null) {
                    return this.rt;
                }
            }
        }
        catch (NotBoundException notBoundException) {
            this.errorMsg = notBoundException.getMessage();
        }
        catch (RemoteException remoteException) {
            this.errorMsg = remoteException.getMessage();
        }
        catch (UnknownHostException unknownHostException) {
            this.errorMsg = unknownHostException.getMessage();
        }
        return null;
    }

    public synchronized RemoteRuntime findRemoteRuntime() {
        try {
            if (this.connected && this.rt != null) {
                return this.rt;
            }
            if (this.connected) {
                this.findRemoteRuntimeImpl();
                if (this.rt != null && this.sci != null) {
                    return this.rt;
                }
            }
        }
        catch (NotBoundException notBoundException) {
            this.errorMsg = notBoundException.getMessage();
        }
        catch (RemoteException remoteException) {
            this.errorMsg = remoteException.getMessage();
        }
        catch (UnknownHostException unknownHostException) {
            this.errorMsg = unknownHostException.getMessage();
        }
        return null;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public synchronized boolean close() {
        try {
            boolean bl = true;
            if (this.isConnected()) {
                this.connected = false;
                this.loginServer.logout(this.loginInfo, this.sci);
                bl = true;
                this.rt = null;
            } else {
                this.errorMsg = "Not connected";
                bl = false;
            }
            for (int i = 0; i < this.extraBucket.size(); ++i) {
                ServerOutputImpl serverOutputImpl = (ServerOutputImpl)this.extraBucket.get(i);
                if (serverOutputImpl.getOutput() == null) continue;
                this.loginServer.logout(this.loginInfo, (SecurityContext)serverOutputImpl.getOutput());
            }
            return bl;
        }
        catch (RemoteException remoteException) {
            this.errorMsg = remoteException.getMessage();
            return false;
        }
    }

    public Admin getAdminInterface(String string) {
        try {
            if (this.isConnected()) {
                return this.loginServer.getAdminInterface(string);
            }
        }
        catch (RemoteException remoteException) {
            this.errorMsg = remoteException.getMessage();
        }
        return null;
    }

    public String getServerVersionDirect(String string, int n) {
        try {
            Registry registry = LocateRegistry.getRegistry(string, n, new DistNBClientSocketFactory());
            RemoteLoginServer remoteLoginServer = (RemoteLoginServer)registry.lookup(this.remoteLoginServerName);
            return remoteLoginServer.getServerVersion();
        }
        catch (NotBoundException notBoundException) {
            return notBoundException.getMessage();
        }
        catch (RemoteException remoteException) {
            return remoteException.getMessage();
        }
    }

    public String getServerVersion() {
        try {
            if (this.isConnected()) {
                return this.loginServer.getServerVersion();
            }
        }
        catch (RemoteException remoteException) {
            this.errorMsg = remoteException.getMessage();
        }
        return "Unavailable";
    }

    public String getJDKVersion() {
        try {
            if (this.isConnected()) {
                return this.loginServer.getJDKVersion();
            }
        }
        catch (RemoteException remoteException) {
            this.errorMsg = remoteException.getMessage();
        }
        return "Unavailable";
    }

    public String getNetworkShareRoot(String string) {
        try {
            if (this.isConnected()) {
                return this.loginServer.translateNetworkShare(string);
            }
        }
        catch (RemoteException remoteException) {
            this.errorMsg = remoteException.getMessage();
        }
        return null;
    }

    public byte[] getTicket() {
        if (this.isConnected()) {
            return this.sci.getAuthenticationHash();
        }
        return null;
    }

    protected void finalize() {
        this.close();
        this.loginServer = null;
    }

    public String getID() {
        return this.sci.getRemoteRuntimeID();
    }

    public boolean isServerFailed() {
        return this.connected && this.findRemoteRuntimeServerSafe() == null;
    }

    class KeepServerAlive
    extends Thread {
        int interval;

        public KeepServerAlive(int n) {
            this.interval = n;
        }

        public void run() {
            try {
                while (!KeepServerAlive.interrupted()) {
                    KeepServerAlive.sleep(this.interval);
                    RemoteLoginClient.this.sendKeepAlive();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

