/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.actions.RemoteBuildAction;
import org.netbeans.modules.distributed.actions.RemoteCompileAction;
import org.netbeans.modules.distributed.actions.RemoteDebugAction;
import org.netbeans.modules.distributed.actions.RemoteExecuteAction;
import org.netbeans.modules.distributed.actions.RemotePropertiesAction;
import org.netbeans.modules.distributed.actions.RemoteRunTargetsAction;
import org.netbeans.modules.distributed.property.RemoteRootProperty;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ConfirmDeleteDialog;
import org.netbeans.modules.distributed.remotefs.ExLocalFileSystem;
import org.netbeans.modules.distributed.remotefs.core.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedProjectSettings;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class NetworkFileSystem
extends ExLocalFileSystem
implements AbstractNetworkFileSystem {
    private static final long serialVersionUID = -8339230545913502376L;
    private static final String nl2 = "\n\n";
    private static final String cvtline1 = "The RMS record format of";
    private static final String cvtline2 = "is not STREAM_LF.";
    private static final String cvtline3 = "Editing this file in its current format from within NetBeans will cause the file to become corrupted.";
    private static final String cvtline4 = "Click OK to convert the file on the OpenVMS machine to STREAM_LF record format.";
    private static final String cvtline5 = "Click CANCEL to skip the conversion (file will not be opened).";
    private static final String NON_STMLF_MSG1 = "The selected SMB share {0} is not configured to have a default RMS file format of STREAM_LF.\n\n";
    private static final String NON_STMLF_MSG2 = "Distributed NetBeans requires that writeable SMB shares used for remote filesystems\nhave STREAM_LF as the default RMS record format.\n\nThe remote filesystem is being mounted as read-only.\n\nIn order to mount this remote filesystem as writeable, you must\n    - modify the SMB share on your OpenVMS server to have STREAM_LF as the default format,\n    - then unmount and re-mount the remote filesystem in Distributed NetBeans.\n\nPlese see the user documentation for your SMB server for more details on setting the\ndefault record format for files.";
    private static final String MOUNT_READONLY_MSG = "The remote filesystem is being mounted as a read-only filesystem.";
    public static final String NON_STMLF_MSG = "The selected SMB share {0} is not configured to have a default RMS file format of STREAM_LF.\n\nDistributed NetBeans requires that writeable SMB shares used for remote filesystems\nhave STREAM_LF as the default RMS record format.\n\nThe remote filesystem is being mounted as read-only.\n\nIn order to mount this remote filesystem as writeable, you must\n    - modify the SMB share on your OpenVMS server to have STREAM_LF as the default format,\n    - then unmount and re-mount the remote filesystem in Distributed NetBeans.\n\nPlese see the user documentation for your SMB server for more details on setting the\ndefault record format for files.";
    public static final String NOT_WRITABLE_MSG1 = "The selected SMB share {0} is not writable.";
    public static final String NOT_WRITABLE_MSG = "The selected SMB share {0} is not writable.\n\nThe remote filesystem is being mounted as a read-only filesystem.";
    public static final int NON_STREAMLF = 0;
    public static final int STREAMLF = 1;
    public static final int NOT_WRITABLE = 2;
    private RemoteRootProperty remoteRoot;
    private RemoteRuntimeType remoteRuntimeType;
    private Boolean useXtermCompile;
    private Boolean useXtermExecution;
    private Integer xDisplayNumber = new Integer(-1);
    private int refCount;
    private transient boolean readOnce = false;
    static /* synthetic */ Class class$org$openide$cookies$CloseCookie;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditCookie;

    public NetworkFileSystem() {
    }

    public NetworkFileSystem(RemoteRuntimeType remoteRuntime) {
        this.remoteRuntimeType = remoteRuntime;
    }

    public Date lastModified(String name) {
        return super.lastModified(name);
    }

    public SystemAction[] getActions() {
        SystemAction[] defaultActions = super.getActions();
        SystemAction[] allActions = new SystemAction[defaultActions.length + 6];
        System.arraycopy(defaultActions, 0, allActions, 0, defaultActions.length);
        SystemAction[] newActions = new SystemAction[]{SystemAction.get((Class)RemoteCompileAction.class), SystemAction.get((Class)RemoteBuildAction.class), SystemAction.get((Class)RemoteExecuteAction.class), SystemAction.get((Class)RemoteDebugAction.class), SystemAction.get((Class)RemotePropertiesAction.class), SystemAction.get((Class)RemoteRunTargetsAction.class)};
        System.arraycopy(newActions, 0, allActions, defaultActions.length, 6);
        return allActions;
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        RemoteRuntimeType ret = DistributedSettings.getDefault().finRemoteRuntime(this.remoteRuntimeType);
        return ret;
    }

    public void setRemoteRuntimeType(RemoteRuntimeType rt) {
        this.remoteRuntimeType = rt;
    }

    public boolean getUseXtermCompile() {
        if (this.useXtermCompile == null) {
            return DistributedProjectSettings.getDefault().getUseXtermCompile();
        }
        return this.useXtermCompile;
    }

    public void setUseXtermCompile(boolean useX) {
        this.useXtermCompile = new Boolean(useX);
        this.firePropertyChange("useXtermCompile", null, this.useXtermCompile);
    }

    public boolean getUseXtermExecution() {
        if (this.useXtermExecution == null) {
            return DistributedProjectSettings.getDefault().getUseXtermExecution();
        }
        return this.useXtermExecution;
    }

    public void setUseXtermExecution(boolean useX) {
        this.useXtermExecution = new Boolean(useX);
        this.firePropertyChange("useXtermExecution", null, this.useXtermExecution);
    }

    public int getXDisplayDeviceNumber() {
        if (this.xDisplayNumber == -1) {
            return DistributedProjectSettings.getDefault().getXDisplayDeviceNumber();
        }
        return this.xDisplayNumber;
    }

    public void setXDisplayDeviceNumber(int n) {
        this.xDisplayNumber = new Integer(n);
        this.firePropertyChange("xDisplayNumber", null, this.xDisplayNumber);
    }

    public String getRemoteRoot() {
        return this.remoteRoot.getRemoteRoot();
    }

    public String getLocalRoot() {
        return this.getRootDirectory().getAbsolutePath();
    }

    public void setRemoteRoot(RemoteRootProperty rt) {
        try {
            this.remoteRoot = rt;
            this.setRootDirectory(new File(rt.getLocalRoot()));
        }
        catch (PropertyVetoException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        if (Utilities.isWindows()) {
            String rootDir = this.getRootDirectory().getAbsolutePath();
            rootDir = rootDir.substring(0, 2);
            String shareName = FileSystemView.getFileSystemView().getSystemDisplayName(new File(rootDir));
            if (shareName.lastIndexOf(40) > 0) {
                shareName = shareName.substring(0, shareName.lastIndexOf(40) - 1);
            }
            return shareName + "(" + super.getDisplayName() + ")";
        }
        return "(" + super.getDisplayName() + ")";
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(super.getRootDirectory().toString());
    }

    private static String getSearchRoot(String remoteRootName, NetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        String searchRootName = remoteRootName;
        if (Utils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            searchRootName = remoteRootName.endsWith(":") ? remoteRootName : remoteRootName.substring(0, remoteRootName.length() - 1);
        }
        return searchRootName;
    }

    private static String getClientPath(String fileName, String remoteRootName, NetworkFileSystem nfs) {
        RemoteRuntimeType rrt = nfs.getRemoteRuntimeType();
        if (Utils.getServerOS(rrt).equals(Utils.OS_VMS)) {
            if (Utilities.isWindows()) {
                return FileUtility.openVMSPathToWinPath(fileName, false, nfs.getRootDirectory().getAbsolutePath(), remoteRootName);
            }
            if (Utilities.isUnix()) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
            if (Utilities.getOperatingSystem() == 8192) {
                return FileUtility.openVMSPathToUnixPath(fileName, false);
            }
        }
        return fileName;
    }

    public static void refreshParent(String fileName, String root, char sep, FileSystem fs) {
        String parent = fileName.substring(root.length() + 1);
        parent = parent.lastIndexOf(sep) > 0 ? parent.substring(0, parent.lastIndexOf(sep)).replace(sep, '/') : "";
        FileObject pfo = fs.findResource(parent);
        if (pfo != null) {
            pfo.refresh();
        }
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void addNotify() {
        super.addNotify();
        this.incRefCount();
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        --this.refCount;
    }

    public void removeNotify() {
        super.removeNotify();
        this.decRefCount();
    }

    public static File toFile(FileObject fo) {
        return (File)fo.getAttribute("java.io.File");
    }

    public static FileObject[] fromFile(String fileName) {
        Enumeration en = Repository.getDefault().getFileSystems();
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        while (en.hasMoreElements()) {
            FileSystem fs = (FileSystem)en.nextElement();
            if (!(fs instanceof NetworkFileSystem)) continue;
            try {
                File file2Fo;
                FileObject fo;
                String res;
                NetworkFileSystem nfs = (NetworkFileSystem)fs;
                File root = NetworkFileSystem.toFile(fs.getRoot());
                if (root == null) continue;
                String rootName = root.getCanonicalPath();
                String remoteRootName = nfs.getRemoteRoot();
                String searchRootName = NetworkFileSystem.getSearchRoot(remoteRootName, nfs);
                if (fileName.toLowerCase().indexOf(searchRootName.toLowerCase()) == 0 && (fileName.charAt(remoteRootName.length() - 1) == '.' || fileName.charAt(remoteRootName.length() - 1) == ']')) {
                    fileName = NetworkFileSystem.getClientPath(fileName, remoteRootName, nfs);
                    res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                    NetworkFileSystem.refreshParent(fileName, rootName, File.separatorChar, fs);
                    fo = fs.findResource(res);
                    File file = file2Fo = fo != null ? NetworkFileSystem.toFile(fo) : null;
                    if (fo == null || file2Fo == null) continue;
                    list.add(fo);
                    continue;
                }
                if (!Utils.getServerOS(nfs.getRemoteRuntimeType()).equals(Utils.OS_VMS)) continue;
                remoteRootName = FileUtility.openVMSPathToUnixPath(remoteRootName, true);
                if (fileName.toLowerCase().indexOf(remoteRootName.toLowerCase()) != 0 || fileName.charAt(remoteRootName.length()) != '/') continue;
                res = fileName.substring(remoteRootName.length() + 1);
                NetworkFileSystem.refreshParent(fileName, remoteRootName, '/', fs);
                fo = fs.findResource(res);
                File file = file2Fo = fo != null ? NetworkFileSystem.toFile(fo) : null;
                if (fo == null || file2Fo == null) continue;
                list.add(fo);
            }
            catch (IOException iexc) {}
        }
        FileObject[] results = new FileObject[list.size()];
        list.toArray(results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkIfFSStreamLF(String localDir, String remoteDir, RemoteRuntimeType rrt) {
        File f = null;
        try {
            f = File.createTempFile("distnbstmlftest", ".txt", new File(localDir));
            if (rrt.isFileSTRMLF(remoteDir + f.getName())) {
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (IOException e) {
            int n = 2;
            return n;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAccessible(String localDir, String remoteDir, RemoteRuntimeType rrt) {
        File f = null;
        try {
            f = File.createTempFile("distnbstmlftest", ".txt", new File(localDir));
            if (rrt != null && rrt.getRemoteRuntime() != null) {
                boolean bl = rrt.fileExists(remoteDir + f.getName());
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public void doSTRMLFConversion(final FileObject fobj) throws IOException {
        File file = FileUtil.toFile((FileObject)fobj);
        String vmsPath = null;
        if (Utilities.isWindows()) {
            vmsPath = FileUtility._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 8192) {
            vmsPath = FileUtility.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
        }
        final String finalVmsPath = vmsPath;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!Utils.isEditorFile(fobj.getPackageNameExt('/', '.'))) {
                    return;
                }
                try {
                    DataObject dobj = null;
                    CloseCookie cc = null;
                    try {
                        dobj = DataObject.find((FileObject)fobj);
                        if (dobj != null) {
                            cc = (CloseCookie)dobj.getCookie(class$org$openide$cookies$CloseCookie == null ? (class$org$openide$cookies$CloseCookie = NetworkFileSystem.class$("org.openide.cookies.CloseCookie")) : class$org$openide$cookies$CloseCookie);
                        }
                    }
                    catch (DataObjectNotFoundException e) {
                        DistributedModule.err.notify((Throwable)e);
                    }
                    if (dobj == null) {
                        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Error Opening " + finalVmsPath + ". Please close it now. The file can be corrupted if continue using"), -1, 2));
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText("Connecting to the remote server:" + NetworkFileSystem.this.getRemoteRuntimeType().getHostName() + ":" + NetworkFileSystem.this.getRemoteRuntimeType().getUserName());
                    RemoteRuntime rt = NetworkFileSystem.this.getRemoteRuntimeType().getRemoteRuntime();
                    if (rt == null) {
                        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Can't determine the file type of " + finalVmsPath + "\nbecause Remote Server is not connected.\n"), -1, 2));
                        if (cc != null) {
                            cc.close();
                        } else {
                            Utils.closeEditorFile(fobj.getPackageNameExt('/', '.'));
                        }
                        return;
                    }
                    if (!rt.getRemoteFileService().isFileSTRMLF(finalVmsPath)) {
                        if (cc != null) {
                            cc.close();
                        } else {
                            Utils.closeEditorFile(fobj.getPackageNameExt('/', '.'));
                        }
                        String message = "The RMS record format of\n\n         " + finalVmsPath + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline2 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline3 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline4 + NetworkFileSystem.nl2 + NetworkFileSystem.cvtline5;
                        String title = "File Format Not STREAM_LF";
                        ConfirmDeleteDialog d = new ConfirmDeleteDialog(message, title, "xxx");
                        d.openChooseDialog();
                        if (!d.isCancel()) {
                            rt.getRemoteFileService().changeTxtFileToSTRMLF(finalVmsPath, finalVmsPath);
                            OpenCookie oc = (OpenCookie)dobj.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = NetworkFileSystem.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                            if (oc == null) {
                                EditCookie ec = (EditCookie)dobj.getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = NetworkFileSystem.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
                                ec.edit();
                            } else {
                                oc.open();
                            }
                        } else if (cc != null) {
                            cc.close();
                        } else {
                            Utils.closeEditorFile(fobj.getPackageNameExt('/', '.'));
                        }
                    }
                }
                catch (RemoteException e) {
                    DistributedModule.err.notify((Throwable)e);
                }
            }
        });
    }

    public InputStream inputStream(String name) throws FileNotFoundException {
        InputStream is = super.inputStream(name);
        if (!name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) && !name.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
            try {
                this.doSTRMLFConversion(this.findResource(name));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return is;
    }

    public FileObject getFSRoot() {
        return this.getRoot();
    }
}

