/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.distributed.property.RemoteNbClassPath;
import org.netbeans.modules.distributed.propertyeditors.FileEditor;
import org.netbeans.modules.distributed.propertyeditors.NbClassPathEditor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkJarFileSystem;
import org.netbeans.modules.distributed.remotefs.core.RemoteFSFile;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class NbClassPathCustomEditor
extends JPanel {
    private static File lastDirFolder = null;
    private static File lastJarFolder = null;
    private PropertyEditor editor;
    private DefaultListModel listModel = new DefaultListModel();
    private boolean editable = true;
    private JLabel pathLabel;
    private JList pathList;
    private JButton addJarButton;
    private JButton downButton;
    private JScrollPane pathScrollPane;
    private JButton upButton;
    private JPanel innerPanel;
    private JButton addDirButton;
    private JButton removeButton;

    public NbClassPathCustomEditor() {
        this.initComponents();
        this.pathList.setModel(this.listModel);
        this.pathScrollPane.setViewportView(this.pathList);
        this.setPreferredSize(new Dimension(400, 200));
        this.pathLabel.setDisplayedMnemonic(NbClassPathCustomEditor.getString("CTL_Classpath.Border_Mnemonic").charAt(0));
        this.addDirButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_AddDirectory_Mnemonic").charAt(0));
        this.addJarButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_AddJAR_Mnemonic").charAt(0));
        this.upButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_MoveUp_Mnemonic").charAt(0));
        this.downButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_MoveDown_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(NbClassPathCustomEditor.getString("CTL_Remove_Mnemonic").charAt(0));
        this.pathList.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_PathList"));
        this.addDirButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_AddDirectory"));
        this.addJarButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_AddJAR"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_MoveDown"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_Remove"));
        this.getAccessibleContext().setAccessibleDescription(NbClassPathCustomEditor.getString("ACSD_CustomNbClassPathEditor"));
    }

    NbClassPathCustomEditor(PropertyEditor propEd) {
        this();
        this.editor = propEd;
        Object value = propEd.getValue();
        if (value instanceof RemoteNbClassPath) {
            this.setClassPath(((RemoteNbClassPath)value).getClassPath());
        }
        if (this.editor instanceof NbClassPathEditor && !((NbClassPathEditor)((Object)this.editor)).isEditable()) {
            this.editable = false;
            this.addDirButton.setEnabled(false);
            this.addJarButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.addDirButton = new JButton();
        this.addJarButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.removeButton = new JButton();
        this.pathScrollPane = new JScrollPane();
        this.pathList = new JList();
        this.pathLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.innerPanel.setLayout(new GridBagLayout());
        this.innerPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.addDirButton.setText(NbClassPathCustomEditor.getString("CTL_AddDirectory"));
        this.addDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbClassPathCustomEditor.this.addDirButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addDirButton, gridBagConstraints);
        this.addJarButton.setText(NbClassPathCustomEditor.getString("CTL_AddJAR"));
        this.addJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbClassPathCustomEditor.this.addJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addJarButton, gridBagConstraints);
        this.upButton.setText(NbClassPathCustomEditor.getString("CTL_MoveUp"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbClassPathCustomEditor.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(NbClassPathCustomEditor.getString("CTL_MoveDown"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbClassPathCustomEditor.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.innerPanel.add((Component)this.downButton, gridBagConstraints);
        this.removeButton.setText(NbClassPathCustomEditor.getString("CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbClassPathCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.innerPanel.add((Component)this.removeButton, gridBagConstraints);
        this.pathList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                NbClassPathCustomEditor.this.pathListValueChanged(evt);
            }
        });
        this.pathList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NbClassPathCustomEditor.this.pathListMouseClicked(evt);
            }
        });
        this.pathScrollPane.setViewportView(this.pathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.innerPanel.add((Component)this.pathScrollPane, gridBagConstraints);
        this.pathLabel.setText(NbClassPathCustomEditor.getString("CTL_Classpath.Border_Classpath_Title"));
        this.pathLabel.setLabelFor(this.pathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.innerPanel.add((Component)this.pathLabel, gridBagConstraints);
        this.add((Component)this.innerPanel, "Center");
    }

    private void pathListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        this.triggerEdit(this.pathList.getSelectedIndex());
    }

    private void pathListValueChanged(ListSelectionEvent evt) {
        this.enableButtons();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.pathList.getSelectedIndex();
        Object[] selectedValues = this.pathList.getSelectedValues();
        for (int i = 0; i < selectedValues.length; ++i) {
            this.listModel.removeElement(selectedValues[i]);
            this.fireValueChanged();
        }
        int size = this.listModel.getSize();
        if (index >= 0 && size > 0) {
            if (size == index) {
                this.pathList.setSelectedIndex(index - 1);
            } else if (size > index) {
                this.pathList.setSelectedIndex(index);
            } else {
                this.pathList.setSelectedIndex(0);
            }
        }
        this.enableButtons();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int i = this.pathList.getSelectedIndex();
        this.swap(i);
        this.pathList.setSelectedIndex(i + 1);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int i = this.pathList.getSelectedIndex();
        this.swap(i - 1);
        this.pathList.setSelectedIndex(i - 1);
    }

    private void addJarButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = FileEditor.createHackedFileChooserSafe(new FileEditor.RemoteFileSystemView());
        this.setHelpToChooser(chooser);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
            }

            public String getDescription() {
                return NbClassPathCustomEditor.getString("CTL_JarArchivesMask");
            }
        });
        if (lastJarFolder != null) {
            chooser.setCurrentDirectory(lastJarFolder);
        }
        chooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_FileSystemPanel.Jar_Dialog_Title"));
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0) {
            File[] files = chooser.getSelectedFiles();
            boolean found = false;
            block2: for (int i = 0; i < files.length; ++i) {
                if (files[i] == null || !files[i].isFile()) continue;
                if (!(files[i] instanceof RemoteFSFile)) {
                    FileObject[] fobjs = FileUtil.fromFile((File)files[i]);
                    for (int j = 0; j < fobjs.length; ++j) {
                        try {
                            if (!(fobjs[j].getFileSystem() instanceof NetworkJarFileSystem) && !(fobjs[j].getFileSystem() instanceof NetworkFileSystem)) continue;
                            found = true;
                            this.listModel.addElement(files[i].getAbsolutePath());
                            continue block2;
                        }
                        catch (FileStateInvalidException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                found = true;
                this.listModel.addElement(files[i].getAbsolutePath());
            }
            if (found) {
                lastJarFolder = chooser.getCurrentDirectory();
                this.fireValueChanged();
            } else {
                String msg = "You can only add Remote Archive File System";
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
            }
            this.pathList.setSelectedIndex(this.listModel.size() - 1);
        }
    }

    private void addDirButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = FileEditor.createHackedFileChooserSafe(new FileEditor.RemoteFileSystemView());
        this.setHelpToChooser(chooser);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_FileSystemPanel.Local_Dialog_Title"));
        if (lastDirFolder != null) {
            chooser.setCurrentDirectory(lastDirFolder);
        }
        if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0) {
            File f = chooser.getSelectedFile();
            boolean networkFS = false;
            if (f instanceof RemoteFSFile) {
                networkFS = true;
            } else {
                FileObject[] fobjs = FileUtil.fromFile((File)f);
                for (int i = 0; i < fobjs.length; ++i) {
                    try {
                        if (!(fobjs[i].getFileSystem() instanceof AbstractNetworkFileSystem)) continue;
                        networkFS = true;
                        break;
                    }
                    catch (FileStateInvalidException e) {
                        // empty catch block
                    }
                }
            }
            if (f != null && f.isDirectory() && networkFS) {
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                lastDirFolder = f.getParentFile();
                if (f instanceof RemoteFSFile) {
                    this.listModel.addElement(f.getName());
                } else {
                    this.listModel.addElement(f.getAbsolutePath());
                }
                this.fireValueChanged();
                this.pathList.setSelectedIndex(this.listModel.size() - 1);
            } else {
                String msg = "You can only add Remote File System";
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
            }
        }
    }

    private void fireValueChanged() {
        if (this.editor != null) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void triggerEdit(int index) {
        if (index < 0) {
            return;
        }
        String selectedItem = (String)this.listModel.elementAt(index);
        File selectedF = new File(selectedItem);
        if (selectedF.isDirectory()) {
            File f;
            JFileChooser chooser = FileEditor.createHackedFileChooser();
            this.setHelpToChooser(chooser);
            chooser.setFileSelectionMode(1);
            chooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_Edit_Local_Dialog_Title"));
            if (selectedF.getParentFile() != null) {
                chooser.setCurrentDirectory(selectedF.getParentFile());
                chooser.setSelectedFile(selectedF);
            }
            if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (f = chooser.getSelectedFile()) != null && f.isDirectory()) {
                lastDirFolder = chooser.getCurrentDirectory();
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this.listModel.set(index, f.getAbsolutePath());
                this.fireValueChanged();
            }
        } else if (selectedF.isFile()) {
            File f;
            JFileChooser chooser = FileEditor.createHackedFileChooser();
            this.setHelpToChooser(chooser);
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
                }

                public String getDescription() {
                    return NbClassPathCustomEditor.getString("CTL_JarArchivesMask");
                }
            });
            chooser.setCurrentDirectory(selectedF.getParentFile());
            chooser.setSelectedFile(selectedF);
            chooser.setDialogTitle(NbClassPathCustomEditor.getString("CTL_Edit_Jar_Dialog_Title"));
            if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), NbClassPathCustomEditor.getString("CTL_Approve_Button_Title")) == 0 && (f = chooser.getSelectedFile()) != null && f.isFile()) {
                lastJarFolder = chooser.getCurrentDirectory();
                this.listModel.set(index, f.getAbsolutePath());
                this.fireValueChanged();
            }
        }
    }

    private void swap(int index) {
        if (index < 0 || index >= this.listModel.size() - 1) {
            return;
        }
        Object value = this.listModel.elementAt(index);
        this.listModel.removeElement(value);
        this.listModel.add(index + 1, value);
        this.fireValueChanged();
    }

    private void enableButtons() {
        if (!this.editable) {
            return;
        }
        this.removeButton.setEnabled(this.pathList.getSelectedIndices().length > 0);
        if (this.pathList.getSelectedIndices().length == 1) {
            this.downButton.setEnabled(this.pathList.getSelectedIndices()[0] < this.pathList.getModel().getSize() - 1);
            this.upButton.setEnabled(this.pathList.getSelectedIndices()[0] > 0);
        } else {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
        }
    }

    private void setClassPath(String classPath) {
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.startsWith("\"")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"")) {
                s = s.substring(0, s.length() - 1);
            }
            this.listModel.addElement(s);
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        ArrayList list = new ArrayList();
        Enumeration e = this.listModel.elements();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        String[] arr = list.toArray(new String[list.size()]);
        return new RemoteNbClassPath(arr);
    }

    private static final String getString(String s) {
        return NbBundle.getMessage((Class)NbClassPathCustomEditor.class, (String)s);
    }

    private void setHelpToChooser(JFileChooser chooser) {
        HelpCtx help = HelpCtx.findHelp((Component)this);
        if (help != null) {
            HelpCtx.setHelpIDString((JComponent)chooser, (String)help.getHelpID());
        }
    }
}

