/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.distributed.execute.RemoteExecutor;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.property.RemoteNbClassPath;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.java.JavaProcessExecutor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.Executor;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class RemoteJavaExecutor
extends RemoteExecutor {
    private static final long serialVersionUID = 4921782425419448314L;
    private static final RemoteNbClassPath EMPTY_CLASSPATH = new RemoteNbClassPath("");
    public static final String PROP_LIBRARYPATH = "libraryPath";
    public static final String PROP_REPOSPATH = "repositoryPath";
    public static final String PROP_EXTERNAL_EXECUTOR2 = "externalExecutor2";
    public static final String PROP_CLASSPATH = "classPath";
    public static final String PROP_BOOTCLASSPATH = "bootClassPath";
    public static final String PROP_WORKDIR = "workingDirectory";
    public static final String PROP_ENVVARS = "environmentVariables";
    public static final String PROP_APPENDENVVARS = "appendEnvironmentVariables";
    public static final String PROP_ASSERT_ENABLED = "assertEnabled";
    public static final String PROP_USELOCAL = "useLocal";
    public static final String PROP_USE_CLASSIC_VM = "useClassicVM";
    private boolean useLocal = false;
    protected NbProcessDescriptor externalExecutor2;
    private RemoteNbClassPath classPath;
    private RemoteNbClassPath bootClassPath;
    private String[] environmentVariables = null;
    private boolean appendEnvironmentVariables = false;
    private boolean assertEnabled = false;
    private boolean useClassicVM = true;

    public RemoteJavaExecutor() {
        this.setChangeWorkingDir(false);
        this.setRemoteExecutor(this.getExternalExecutor());
        this.setErrorExpression(ExternalCompiler.JAVAC);
    }

    protected void finalize() throws Throwable {
    }

    private void makeReadOnly() {
        if (this.getUseLocal()) {
            String msg = "Selected property is a property of the External Compilation.\n";
            msg = msg + "To change the property, change the property from Compiler Type\\External Compilation.\n";
            msg = msg + "To change the corresponding remote property, set Use Local Copy to false";
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        }
    }

    public boolean getUseLocal() {
        return this.useLocal;
    }

    public void setUseLocal(boolean useLocal) {
        this.useLocal = useLocal;
        this.resetToLocal();
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        if (this.remoteExecutor == null) {
            this.remoteExecutor = new RemoteProcessDescriptor(this.getExternalExecutor2().getProcessName(), this.getExternalExecutor2().getArguments(), this.getExternalExecutor2().getInfo());
        }
        return this.remoteExecutor;
    }

    public RemoteProcessDescriptor getRemoteExecutor() {
        return this.getExternalExecutor();
    }

    public void setRemoteExecutor(RemoteProcessDescriptor re) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        this.remoteExecutor = re;
        this.firePropertyChange("remoteExecutor", null, this.remoteExecutor);
    }

    private JavaProcessExecutor getJavaProcessExecutor() {
        Class c = JavaProcessExecutor.class;
        JavaProcessExecutor type = (JavaProcessExecutor)Lookup.getDefault().lookup(c);
        return type == null ? (JavaProcessExecutor)Executor.getDefault() : type;
    }

    public NbProcessDescriptor getExternalExecutor2() {
        if (this.getUseLocal()) {
            return this.getJavaProcessExecutor().getExternalExecutor();
        }
        if (this.externalExecutor2 == null) {
            this.externalExecutor2 = this.createDescriptor();
        }
        return this.externalExecutor2;
    }

    public void setExternalExecutor2(NbProcessDescriptor exec) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        NbProcessDescriptor old = this.externalExecutor2;
        this.externalExecutor2 = exec;
        this.firePropertyChange(PROP_EXTERNAL_EXECUTOR2, old, this.externalExecutor2);
        this.setRemoteExecutor(new RemoteProcessDescriptor(this.externalExecutor2.getProcessName(), this.externalExecutor2.getArguments(), this.externalExecutor2.getInfo()));
    }

    protected NbProcessDescriptor createDescriptor() {
        return new NbProcessDescriptor("{java.home}{/}bin{/}java", "{assertEnabled} -Dsun.java2d.pmoffscreen=false -cp {filesystems}{:}{classpath} {classname} {arguments}", NbBundle.getBundle((Class)ProcessExecutor.class).getString("MSG_ExecutorHint"));
    }

    public RemoteNbClassPath getClassPath() {
        if (this.getUseLocal()) {
            return new RemoteNbClassPath(this.getJavaProcessExecutor().getClassPath());
        }
        RemoteNbClassPath p = this.classPath;
        if (p != null) {
            return p;
        }
        return EMPTY_CLASSPATH;
    }

    public synchronized void setClassPath(RemoteNbClassPath path) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        RemoteNbClassPath old = this.classPath;
        this.classPath = path;
        this.firePropertyChange(PROP_CLASSPATH, old, this.classPath);
    }

    public RemoteNbClassPath getBootClassPath() {
        if (this.getUseLocal()) {
            return new RemoteNbClassPath(this.getJavaProcessExecutor().getBootClassPath());
        }
        RemoteNbClassPath p = this.bootClassPath;
        if (p != null) {
            return p;
        }
        return EMPTY_CLASSPATH;
    }

    public synchronized void setBootClassPath(RemoteNbClassPath path) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        RemoteNbClassPath old = this.bootClassPath;
        this.bootClassPath = path;
        this.firePropertyChange(PROP_BOOTCLASSPATH, old, this.bootClassPath);
    }

    public void setWorkingDirectory(File buildDir) throws IOException {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        boolean found = false;
        if (buildDir != null) {
            FileObject[] fobjs = FileUtil.fromFile((File)buildDir);
            for (int j = 0; j < fobjs.length; ++j) {
                try {
                    if (!(fobjs[j].getFileSystem() instanceof FTPFileSystem) && !(fobjs[j].getFileSystem() instanceof NetworkFileSystem)) continue;
                    found = true;
                    break;
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
            }
        }
        if (found || buildDir == null) {
            File old = this.workingDirectory;
            this.workingDirectory = buildDir;
            this.firePropertyChange(PROP_WORKDIR, old, this.workingDirectory);
        } else {
            String msg = "You can only add Remote File System";
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        }
    }

    public File getWorkingDirectory() {
        if (this.getUseLocal()) {
            return this.getJavaProcessExecutor().getWorkingDirectory();
        }
        return this.workingDirectory;
    }

    public String[] getEnvironmentVariables() {
        if (this.getUseLocal()) {
            return this.getJavaProcessExecutor().getEnvironmentVariables();
        }
        return this.environmentVariables;
    }

    public synchronized void setEnvironmentVariables(String[] nue) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        String[] old = this.environmentVariables;
        this.environmentVariables = nue;
        this.firePropertyChange(PROP_ENVVARS, old, this.environmentVariables);
    }

    public boolean getAppendEnvironmentVariables() {
        if (this.getUseLocal()) {
            return this.getJavaProcessExecutor().getAppendEnvironmentVariables();
        }
        return this.appendEnvironmentVariables;
    }

    public synchronized void setAppendEnvironmentVariables(boolean nue) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        boolean old = this.appendEnvironmentVariables;
        this.appendEnvironmentVariables = nue;
        this.firePropertyChange(PROP_APPENDENVVARS, old ? Boolean.TRUE : Boolean.FALSE, nue ? Boolean.TRUE : Boolean.FALSE);
    }

    public RemoteNbClassPath getLibraryPath() {
        if (this.getUseLocal()) {
            return new RemoteNbClassPath(this.getJavaProcessExecutor().getLibraryPath());
        }
        return RemoteNbClassPath.createLibraryPath();
    }

    public RemoteNbClassPath getRepositoryPath() {
        return RemoteNbClassPath.createRepositoryPath(FileSystemCapability.ALL);
    }

    public boolean isAssertEnabled() {
        if (this.getUseLocal()) {
            return this.getJavaProcessExecutor().isAssertEnabled();
        }
        return this.assertEnabled;
    }

    public void setAssertEnabled(boolean assertFlag) {
        if (this.getUseLocal()) {
            this.makeReadOnly();
            return;
        }
        boolean old = this.assertEnabled;
        this.assertEnabled = assertFlag;
        this.firePropertyChange(PROP_ASSERT_ENABLED, old ? Boolean.TRUE : Boolean.FALSE, this.assertEnabled ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void createDefaultMapFormat(DataObject obj) throws IOException {
        AbstractNetworkFileSystem nfs = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
            Map map = super.createMapFormat(obj, nfs).getMap();
            String className = (String)map.get("java class");
            String arg = (String)map.get("arguments");
            String fileName = (String)map.get("file");
            fileName = FileUtility.openVMSPathToUnixPath(fileName, false);
            map.put("file", fileName);
            String remoteRoot = FileUtility.openVMSPathToUnixPath(nfs.getRemoteRoot(), true);
            this.format = new JFormat(className, new String[]{arg}, this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath(), this.isAssertEnabled(), this.getUseClassicVM(), obj);
        }
        catch (FileStateInvalidException exp) {
        }
        catch (IOException e) {
            throw e;
        }
    }

    public ExecutorTask execute(DataObject obj) throws IOException {
        this.createDefaultMapFormat(obj);
        if (this.getWorkingDirectory() != null) {
            this.setChangeWorkingDir(true);
        } else {
            this.setChangeWorkingDir(false);
        }
        return super.execute(obj);
    }

    public boolean getUseClassicVM() {
        return this.useClassicVM;
    }

    public void setUseClassicVM(boolean b) {
        boolean old = this.useClassicVM;
        this.useClassicVM = b;
        this.firePropertyChange(PROP_USE_CLASSIC_VM, old ? Boolean.TRUE : Boolean.FALSE, this.useClassicVM ? Boolean.TRUE : Boolean.FALSE);
    }

    private void resetToLocal() {
        this.firePropertyChange(PROP_CLASSPATH, null, this.getClassPath());
        this.firePropertyChange(PROP_BOOTCLASSPATH, null, this.getBootClassPath());
        this.firePropertyChange(PROP_WORKDIR, null, this.getWorkingDirectory());
        this.firePropertyChange(PROP_ENVVARS, null, this.getEnvironmentVariables());
        this.firePropertyChange(PROP_APPENDENVVARS, null, this.getAppendEnvironmentVariables() ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange(PROP_ASSERT_ENABLED, null, this.isAssertEnabled() ? Boolean.TRUE : Boolean.FALSE);
    }

    public static class JFormat
    extends MapFormat {
        public static final String TAG_ASSERT_ENABLED = "assertEnabled";
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_BOOTCLASSPATH = "bootclasspath";
        public static final String TAG_REPOSITORY = "filesystems";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_CLASSNAME = "classname";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        public static final String TAG_USE_CLASSIC_VM = "classic";
        static final long serialVersionUID = -1524637220865300000L;

        public JFormat(String className, String[] args, RemoteNbClassPath classPath, RemoteNbClassPath bootClassPath, RemoteNbClassPath repository, RemoteNbClassPath library, boolean isAssertEnabled, boolean useClassic, DataObject dobj) {
            super(new HashMap());
            Map map = this.getMap();
            map.put(TAG_CLASSPATH, classPath.getRemoteClassPath(dobj));
            map.put(TAG_BOOTCLASSPATH, bootClassPath.getRemoteClassPath());
            map.put(TAG_REPOSITORY, repository.getRemoteClassPath());
            map.put(TAG_LIBRARY, library.getRemoteClassPath());
            map.put(TAG_CLASSNAME, className);
            map.put(TAG_SEPARATOR, TAG_SEPARATOR);
            map.put(TAG_PATHSEPARATOR, TAG_PATHSEPARATOR);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                sb.append('\"');
                sb.append(args[i]);
                sb.append('\"');
                sb.append(' ');
            }
            map.put(TAG_ARGUMENTS, sb.toString());
            map.put("assertEnabled", isAssertEnabled ? "-ea " : "");
        }
    }
}

