/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.netbeans.modules.distributed.execute.OutputWriterOutputStream;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.core.RemoteFile;
import org.netbeans.modules.distributed.remotefs.core.Sync;
import org.netbeans.modules.distributed.remotefs.core.SyncTablePanel;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.distributed.util.MySimpleFormatter;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.JavaOptions;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.loaders.DataObject;
import org.openide.modules.ModuleInstall;
import org.openide.nodes.Node;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DistributedModule
extends ModuleInstall {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.distributed");
    public static final Logger logger = Logger.getLogger("org.netbeans.modules.distributed");
    public static final String WSIT_PROPERTIES_FILE = "wsit-ant-user.properties";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    private FileChangeListener createFileChangeListener(FileSystem fileSystem) {
        class FileChangeListenerImpl
        extends FileChangeAdapter {
            private String status = null;
            private final /* synthetic */ FileSystem val$fileSystem;

            FileChangeListenerImpl(FileSystem val$fileSystem) {
                this.val$fileSystem = val$fileSystem;
            }

            public void fileDeleted(FileEvent fe) {
            }

            public void fileRenamed(FileRenameEvent fe) {
            }

            public void fileFolderCreated(FileEvent fe) {
            }

            public void fileChanged(FileEvent fe) {
                if (this.val$fileSystem instanceof FTPFileSystem) {
                    FTPFileSystem ffs = (FTPFileSystem)this.val$fileSystem;
                    HashSet<FileObject> hs = new HashSet<FileObject>();
                    hs.add(fe.getFile());
                    ffs.pubFireFileStatusChanged(hs);
                }
            }

            public void fileDataCreated(FileEvent fe) {
                if (this.val$fileSystem instanceof FTPFileSystem) {
                    try {
                        FTPFileSystem ffs = (FTPFileSystem)this.val$fileSystem;
                        RemoteFile rf = ffs.getRemoteFile(fe.getFile().getPackageNameExt('/', '.'));
                        String mimeType = fe.getFile().getExt().equals("xml") ? "text" : (ffs.getAsciiFileExts().isRegistered(fe.getFile().getExt()) ? "text" : FileUtil.getMIMEType((FileObject)fe.getFile()));
                        rf.setMimeType(mimeType);
                        rf.refresh();
                        Sync.SyncAction action = Sync.getAction(rf.getClientStatus(), rf.getServerStatus());
                        if (!rf.getName().getName().endsWith("~") && action == Sync.SyncAction.conflict_dialog && Thread.currentThread().getName().equals("FTP-Synchronize")) {
                            SyncTablePanel.showSyncFiles(rf, false, true);
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        }
        return new FileChangeListenerImpl(fileSystem);
    }

    private void removeOldDocs() {
        String userPath = System.getProperty("netbeans.user") + File.separatorChar + "modules" + File.separatorChar + "docs" + File.separatorChar;
        String systemPath = System.getProperty("netbeans.home") + File.separatorChar + "modules" + File.separatorChar + "docs" + File.separatorChar;
        String path = userPath;
        for (int i = 0; i < 2; ++i) {
            File helpDoc = new File(path + "cplusmod.zip");
            if (!helpDoc.delete()) {
                path = systemPath;
                continue;
            }
            helpDoc = new File(path + "COBOLHelp.zip");
            helpDoc.delete();
            helpDoc = new File(path + "DCLHelp.zip");
            helpDoc.delete();
            helpDoc = new File(path + "fortranmod.zip");
            helpDoc.delete();
            path = systemPath;
        }
    }

    public void installed() {
        this.removeOldDocs();
        this.restored();
    }

    private void fileOpen(DataObject dobj, boolean editMode) {
        OpenCookie oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        if (oc == null || editMode) {
            EditCookie ec = (EditCookie)dobj.getCookie(EditCookie.class);
            if (ec != null) {
                ec.edit();
            }
        } else {
            oc.open();
        }
    }

    public void restored() {
        this.removeOldDocs();
        StreamHandler handler = null;
        try {
            handler = new File(System.getProperty("netbeans.user") + File.separatorChar + "distributed").exists() ? new FileHandler(System.getProperty("netbeans.user") + File.separatorChar + "distributed" + File.separatorChar + "ftpfilesystem.log", 1000000, 10, true) : new FileHandler(System.getProperty("netbeans.home") + File.separatorChar + "distributed" + File.separatorChar + "ftpfilesystem_" + System.getProperty("user.name") + ".log", 1000000, 10, true);
            handler.setFormatter(new MySimpleFormatter());
        }
        catch (IOException e) {
            handler = new ConsoleHandler();
        }
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            logger.removeHandler(handlers[i]);
        }
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        JavaOptions opts = (JavaOptions)BaseOptions.getOptions((Class)JavaKit.class);
        opts.setUpdatePDAfterMounting("pd_never");
        WindowManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Mode mode;
                if (evt.getPropertyName().equals("activeMode") && (mode = (Mode)evt.getNewValue()) != null && mode.getDisplayName() != null && mode.getDisplayName().equals("editor")) {
                    DataObject dobj;
                    TopComponent tc = mode.getSelectedTopComponent();
                    if (tc == null) {
                        return;
                    }
                    Node[] an = tc.getActivatedNodes();
                    if (an != null && an.length > 0 && (dobj = (DataObject)an[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DistributedModule.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null) {
                        Iterator itr = dobj.files().iterator();
                        try {
                            while (itr.hasNext()) {
                                DataObject dobjNew;
                                FileObject fobj = (FileObject)itr.next();
                                if (fobj.getFileSystem() instanceof FTPFileSystem) {
                                    FTPFileSystem ffs = (FTPFileSystem)fobj.getFileSystem();
                                    RemoteFile rf = ffs.getRemoteFile(fobj.getPackageNameExt('/', '.'));
                                    if (rf != null && !rf.getName().getName().equals(fobj.getNameExt())) {
                                        fobj.getParent().refresh();
                                        FileObject foNew = ffs.findResource(fobj.getPackageNameExt('/', '.').toUpperCase());
                                        if (foNew != null) {
                                            DataObject dobjNew2 = DataObject.find((FileObject)foNew);
                                            DistributedModule.this.fileOpen(dobjNew2, foNew.getNameExt().toLowerCase().equals(DistributedModule.WSIT_PROPERTIES_FILE));
                                        }
                                    } else if (fobj.getNameExt().toLowerCase().equals(DistributedModule.WSIT_PROPERTIES_FILE)) {
                                        dobjNew = DataObject.find((FileObject)fobj);
                                        DistributedModule.this.fileOpen(dobjNew, true);
                                    }
                                }
                                if (!(fobj.getFileSystem() instanceof NetworkFileSystem)) continue;
                                if (fobj.getExt().toLowerCase().equals("xml") || fobj.getExt().toLowerCase().equals("form")) {
                                    ((NetworkFileSystem)fobj.getFileSystem()).doSTRMLFConversion(fobj);
                                }
                                File f = new File(((NetworkFileSystem)fobj.getFileSystem()).getLocalRoot() + File.separatorChar + fobj.getPackageNameExt('\\', '.'));
                                if ((f = f.getCanonicalFile()) != null && !f.getPath().endsWith(fobj.getNameExt())) {
                                    fobj.getParent().refresh();
                                    FileObject foNew = fobj.getFileSystem().findResource(fobj.getPackageNameExt('/', '.').toUpperCase());
                                    if (foNew == null) continue;
                                    dobjNew = DataObject.find((FileObject)foNew);
                                    DistributedModule.this.fileOpen(dobjNew, foNew.getNameExt().toLowerCase().equals(DistributedModule.WSIT_PROPERTIES_FILE));
                                    continue;
                                }
                                if (!fobj.getNameExt().toLowerCase().equals(DistributedModule.WSIT_PROPERTIES_FILE)) continue;
                                DataObject dobjNew3 = DataObject.find((FileObject)fobj);
                                DistributedModule.this.fileOpen(dobjNew3, true);
                            }
                        }
                        catch (FileStateInvalidException e) {
                            err.notify((Throwable)e);
                        }
                        catch (IOException e) {
                            err.notify((Throwable)e);
                        }
                    }
                }
            }
        });
        Repository.getDefault().addRepositoryListener((RepositoryListener)new RepositoryAdapter(){

            public void fileSystemAdded(RepositoryEvent ev) {
                RepositoryEvent fev = ev;
                if (ev.getFileSystem() instanceof FTPFileSystem) {
                    FileChangeListener fileChangeListener = DistributedModule.this.createFileChangeListener(ev.getFileSystem());
                    ev.getFileSystem().addFileChangeListener(fileChangeListener);
                }
            }
        });
    }

    public void uninstalled() {
        System.out.println("unsintalled");
        OutputWriterOutputStream.detachAllAnnotations();
    }

    public void close() {
        Iterator itr = DistributedSettings.getDefault().getRemoteRuntimes().iterator();
        while (itr.hasNext()) {
            RemoteRuntimeType rrt = (RemoteRuntimeType)itr.next();
            try {
                rrt.disconnect(true);
            }
            catch (Exception exception) {}
        }
    }
}

