/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.cookies.RemoteCookie;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.RemoteProjectSettings;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remoteexecute.ant.RemoteAntExecutor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.RemoteFSUtils;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileSystem;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import patchsources.OpenProjectList_Dist;

public class RemoteRunTargetsAction
extends CookieAction
implements Presenter.Popup {
    public String getName() {
        return NbBundle.getMessage(RemoteRunTargetsAction.class, (String)"LBL_run_targets_action");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.apache.tools.ant.module.executing-target");
    }

    public JMenuItem getPopupPresenter() {
        return new SpecialSubMenu((SystemAction)this, new ActSubMenuModel((NodeAction)this), true);
    }

    protected int mode() {
        return 8;
    }

    protected Class[] cookieClasses() {
        return new Class[]{AntProjectCookie.class};
    }

    protected void performAction(Node[] activatedNodes) {
    }

    protected boolean enable(Node[] node) {
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(DataObject.class);
            if (dobj == null) {
                return false;
            }
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            if (dobj.getCookie(RemoteCookie.class) != null) {
                return false;
            }
            if (node[i].getCookie(AntProjectCookie.class) == null) {
                return false;
            }
            if (dobj.getPrimaryFile() instanceof AbstractNetworkFileSystem) continue;
            return false;
        }
        return true;
    }

    private static final class ActSubMenuModel
    implements Actions.SubMenuModel {
        private List targets = null;
        private AntProjectCookie project = null;
        private DataObject dobj = null;
        private final NodeAction action;

        ActSubMenuModel(NodeAction action) {
            this.action = action;
        }

        public int getCount() {
            if (this.targets == null) {
                return 0;
            }
            return this.targets.size();
        }

        public String getLabel(int index) {
            return (String)this.targets.get(index);
        }

        public HelpCtx getHelpCtx(int index) {
            return new HelpCtx("org.apache.tools.ant.module.executing-target");
        }

        private static void refreshFS() {
            for (FileSystem fs : OpenProjectList_Dist.getFsSet()) {
                if (fs.isReadOnly() || !(fs instanceof AbstractNetworkFileSystem)) continue;
                fs.refresh(false);
            }
        }

        public static RemoteAntExecutor getRemoteAntExecutorType(FileObject fobj) {
            Project project = FileOwnerQuery.getOwner((FileObject)fobj);
            RemoteProjectSettings rs = (RemoteProjectSettings)project.getLookup().lookup(RemoteProjectSettings.class);
            if (rs == null) {
                return new RemoteAntExecutor(fobj);
            }
            rs.refresh("ant");
            RemoteAntExecutor rae = (RemoteAntExecutor)rs.getCompilerSettings("ant");
            return rae;
        }

        public void performActionAt(final int index) {
            if (DistributedSettings.getDefault().getSaveAll()) {
                LifecycleManager.getDefault().saveAll();
            }
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    ActSubMenuModel.refreshFS();
                    String target = (String)ActSubMenuModel.this.targets.get(index);
                    RemoteAntExecutor ret = ActSubMenuModel.getRemoteAntExecutorType(ActSubMenuModel.this.dobj.getPrimaryFile());
                    try {
                        ret.execute(ActSubMenuModel.this.dobj, target, new HashMap());
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    ActSubMenuModel.refreshFS();
                }
            });
        }

        boolean isAntImporting(AntProjectCookie project) {
            if (project.getParseException() != null) {
                return false;
            }
            Element pel = project.getProjectElement();
            NodeList nl = pel.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element elem;
                if (!(nl.item(i) instanceof Element) || !(elem = (Element)nl.item(i)).getNodeName().equals("import")) continue;
                return true;
            }
            return false;
        }

        void addNotify() {
            Set<String> targetsSorted;
            String deftarget;
            block21: {
                this.project = null;
                this.targets = null;
                Node[] nodes = this.action.getActivatedNodes();
                if (nodes.length != 1) {
                    return;
                }
                this.project = (AntProjectCookie)nodes[0].getCookie(AntProjectCookie.class);
                this.dobj = (DataObject)nodes[0].getCookie(DataObject.class);
                if (this.project == null) {
                    return;
                }
                FileObject fobj = this.dobj.getPrimaryFile();
                AbstractNetworkFileSystem fs = null;
                try {
                    if (!(fobj.getFileSystem() instanceof AbstractNetworkFileSystem)) {
                        return;
                    }
                    fs = (AbstractNetworkFileSystem)fobj.getFileSystem();
                    if (fs instanceof RemoteFileSystem && !((RemoteFileSystem)((Object)fs)).isConnected()) {
                        return;
                    }
                }
                catch (FileStateInvalidException e) {
                    return;
                }
                RemoteRuntimeType rrt = fs.getRemoteRuntimeType();
                this.targets = new ArrayList();
                if (this.project.getParseException() != null) {
                    return;
                }
                Element pel = this.project.getProjectElement();
                deftarget = pel.getAttribute("default");
                targetsSorted = new TreeSet();
                if (!this.isAntImporting(this.project)) {
                    NodeList nl = pel.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element targ;
                        if (!(nl.item(i) instanceof Element) || !(targ = (Element)nl.item(i)).getNodeName().equals("target")) continue;
                        String targname = targ.getAttribute("name");
                        targetsSorted.add(targname);
                    }
                } else if (rrt != null) {
                    try {
                        String vmsPath = fobj.getNameExt();
                        File file = FileUtil.toFile((FileObject)fobj);
                        if (Utilities.isWindows()) {
                            vmsPath = RemoteFSUtils._winPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                        } else if (Utilities.isUnix() || Utilities.getOperatingSystem() == 16384) {
                            vmsPath = RemoteFSUtils.unixPathToOpenVMSPath(file.getAbsolutePath(), false, fobj);
                        }
                        vmsPath = FileUtility.openVMSPathToUnixPath(vmsPath, false);
                        if (rrt.getRemoteRuntime() != null) {
                            targetsSorted = rrt.getRemoteRuntime().getAntTargets(vmsPath);
                            break block21;
                        }
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Remote server \"" + rrt.getHostName() + "\" " + " is disconnected.\nPlease go to Services Tab and make connection using \"" + rrt.getUserName() + "\""), 1));
                    }
                    catch (Exception e) {}
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\n Please go to Services Tab and create remote server", 2));
                }
            }
            if (deftarget != null && deftarget.trim().length() > 0 && targetsSorted.size() > 0) {
                targetsSorted.remove(deftarget);
                this.targets.add(0, deftarget);
                this.targets.add(1, null);
            }
            Iterator itr = targetsSorted.iterator();
            while (itr.hasNext()) {
                this.targets.add(itr.next());
            }
            if (this.targets.size() == 1) {
                this.targets.add(null);
            }
        }

        public synchronized void addChangeListener(ChangeListener l) {
        }

        public synchronized void removeChangeListener(ChangeListener l) {
        }
    }

    private static final class SpecialSubMenu
    extends Actions.SubMenu {
        private final ActSubMenuModel model;

        SpecialSubMenu(SystemAction action, ActSubMenuModel model, boolean popup) {
            super(action, (Actions.SubMenuModel)model, popup);
            this.model = model;
            this.addNotify();
        }

        public void addNotify() {
            this.model.addNotify();
            super.addNotify();
        }
    }
}

