/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute.ant;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remoteexecute.RemoteExecutor;
import org.netbeans.modules.distributed.remoteexecute.RemoteNbClassPath;
import org.netbeans.modules.distributed.remoteexecute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.smb.NetworkFileSystem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class RemoteAntExecutor
extends RemoteExecutor {
    private String target = "";
    private static final long serialVersionUID = 4921782425409448322L;
    public static final String PROP_CLASSPATH = "classPath";
    private static final RemoteNbClassPath EMPTY_CLASSPATH = new RemoteNbClassPath("");
    private RemoteNbClassPath classPath;
    private Map settingsMap;
    private Project project;
    private FileObject fobj;

    public RemoteAntExecutor() {
        this.settingsMap = new HashMap();
        this.settingsMap.put("error_exp_opt", "2 1 -1 -1");
        this.settingsMap.put("error_exp", "[ \\t]*[A|a]t line number ([0-9]+) in file (.*)$");
        this.settingsMap.put("compile_command", "pipe ant == \"@ide$ant_home:ide_ant.com\" ; ant");
        this.settingsMap.put("compile_param", "{basedir} \"-emacs\" {file} {target}");
        this.settingsMap.put("build_dir", "");
        this.settingsMap.put("error_exp_opt_ant", "2 3 -1 4");
        this.settingsMap.put("error_exp_ant", "^(file\\:)?([^ ][^ ]+):([0-9]+): (.*)");
    }

    public RemoteAntExecutor(FileObject fobj) {
        this.project = FileOwnerQuery.getOwner((FileObject)fobj);
        FileObject pdir = this.project.getProjectDirectory();
        String projectDirectory = FileUtil.toFile((FileObject)pdir).getAbsolutePath();
        this.settingsMap = Utils.getCompilerSettingsFrom3GLXML(projectDirectory, "ant");
    }

    public boolean isRemoteJavaCompile() {
        return false;
    }

    public void flushSettings() throws IOException {
        Utils.writeCompilerSettingto3GLXML(this.project, "ant", this.settingsMap);
    }

    public ExternalCompiler.ErrorExpression getErrorExpression() {
        String exp_opt = (String)this.settingsMap.get("error_exp_opt");
        String[] pos = exp_opt.split(" ");
        return new ExternalCompiler.ErrorExpression("OpenVMS Compiler Errors for Ant", (String)this.settingsMap.get("error_exp"), Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2]), Integer.parseInt(pos[3]));
    }

    public void setErrorExpression(ExternalCompiler.ErrorExpression e) {
        this.settingsMap.put("error_exp", e.getErrorExpression());
        this.settingsMap.put("error_exp_opt", Integer.toString(e.getFilePos()) + " " + Integer.toString(e.getLinePos()) + " " + Integer.toString(e.getColumnPos()) + " " + Integer.toString(e.getDescriptionPos()));
    }

    public Boolean outputSwitch() {
        try {
            return ((AbstractNetworkFileSystem)this.fobj.getFileSystem()).getUseXtermCompile() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        NbProcessDescriptor nbp = this.createDescriptor();
        return new RemoteProcessDescriptor(nbp.getProcessName(), nbp.getArguments(), NbBundle.getBundle(RemoteExecutor.class).getString("MSG_RemoteAntExecutorHint"));
    }

    protected NbProcessDescriptor createDescriptor() {
        return new NbProcessDescriptor((String)this.settingsMap.get("compile_command"), (String)this.settingsMap.get("compile_param"), "");
    }

    public void setExternalExecutor(RemoteProcessDescriptor ext) {
        this.settingsMap.put("compile_command", ext.getProcessName());
        this.settingsMap.put("compile_param", ext.getArguments());
    }

    public String getRemoteAntBaseDirectory() {
        return (String)this.settingsMap.get("build_dir");
    }

    public void setRemoteAntBaseDirectory(String baseDir) {
        this.settingsMap.put("build_dir", baseDir);
    }

    public RemoteNbClassPath getClassPath() {
        RemoteNbClassPath p = this.classPath;
        if (p != null) {
            return p;
        }
        return EMPTY_CLASSPATH;
    }

    protected void createDefaultMapFormat(DataObject obj, String target, HashMap pmap) throws IOException {
        AbstractNetworkFileSystem nfs = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
            Map map = super.createMapFormat(obj, nfs).getMap();
            String fileName = (String)map.get("file");
            fileName = FileUtility.openVMSPathToUnixPath(fileName, false);
            String baseDir = (String)obj.getPrimaryFile().getAttribute("REMOTE_ANT_BASE_DIR");
            if ((baseDir == null || baseDir.equals("")) && ((baseDir = this.getRemoteAntBaseDirectory()) == null || baseDir.equals(""))) {
                baseDir = null;
            }
            if (baseDir != null && baseDir.indexOf("^") < 0) {
                baseDir = FileUtility.openVMSPathToUnixPath(baseDir, true);
            }
            this.format = new JFormat(this.getClassPath(), fileName, target, baseDir, pmap, obj);
        }
        catch (FileStateInvalidException exp) {
        }
        catch (IOException e) {
            throw e;
        }
    }

    public ExecutorTask execute(DataObject obj, String target, HashMap pmap) throws IOException {
        this.createDefaultMapFormat(obj, target, pmap);
        if (this.getWorkingDirectory() != null) {
            this.setChangeWorkingDir(true);
        } else {
            this.setChangeWorkingDir(false);
        }
        return super.execute(obj);
    }

    public void setWorkingDirectory(File buildDir) throws IOException {
        boolean found = false;
        if (buildDir != null) {
            FileObject[] fobjs = FileUtil.fromFile((File)buildDir);
            for (int j = 0; j < fobjs.length; ++j) {
                try {
                    if (!(fobjs[j].getFileSystem() instanceof NetworkFileSystem) && !(fobjs[j].getFileSystem() instanceof FTPFileSystem)) continue;
                    found = true;
                    break;
                }
                catch (FileStateInvalidException e) {
                    // empty catch block
                }
            }
        }
        if (found || buildDir == null) {
            File old = this.workingDirectory;
            this.workingDirectory = buildDir;
        } else {
            String msg = "You can only add Remote File System";
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
        }
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.distributed.RemoteExecutor");
    }

    public static class JFormat
    extends MapFormat {
        public static final String TAG_CLASSPATH = "classpath";
        public static final String TAG_ARGUMENTS = "arguments";
        public static final String TAG_JAVAHOME = "java.home";
        public static final String TAG_JDKHOME = "jdk.home";
        public static final String TAG_SEPARATOR = "/";
        public static final String TAG_PATHSEPARATOR = ":";
        public static final String ANT_HOME = "ant.home";
        public static final String ANT_LIB = "ant.lib";
        public static final String ANT_SCRIPT = "file";
        public static final String ANT_TARGET = "target";
        public static final String ANT_BASE_DIR = "basedir";
        static final long serialVersionUID = -1524637220865300001L;

        public JFormat(RemoteNbClassPath classPath, String fileName, String target, String baseDir, HashMap pmap, DataObject dobj) {
            super(new HashMap());
            Map map = this.getMap();
            map.put(TAG_SEPARATOR, TAG_SEPARATOR);
            map.put(TAG_PATHSEPARATOR, TAG_PATHSEPARATOR);
            if (target != null) {
                map.put(ANT_TARGET, "\"" + target + "\"");
            } else {
                map.put(ANT_TARGET, "");
            }
            if (fileName != null) {
                StringBuffer sbuf = new StringBuffer("\"-buildfile\" \"" + fileName + "\" ");
                for (String prop : pmap.keySet()) {
                    sbuf.append("\"-D" + prop + "=" + (String)pmap.get(prop) + "\" ");
                }
                System.out.println("propValue is " + sbuf.toString());
                map.put(ANT_SCRIPT, sbuf.toString());
            } else {
                map.put(ANT_SCRIPT, "");
            }
            if (baseDir != null) {
                map.put(ANT_BASE_DIR, "\"-Dbasedir=" + baseDir + "\"");
            } else {
                map.put(ANT_BASE_DIR, "");
            }
        }
    }
}

