/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.common.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.netbeans.modules.distributed.common.propertyeditors.ExtensionListCustomEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.loaders.ExtensionList;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;

public class ExtensionListEditor
implements PropertyEditor,
ExPropertyEditor {
    private ExtensionList value;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean editable = true;

    public void setValue(Object value) {
        this.value = value != null ? (ExtensionList)((ExtensionList)value).clone() : null;
        this.support.firePropertyChange(null, null, null);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        StringBuffer sb = new StringBuffer();
        String[] exts = this.getStringArray();
        for (int i = 0; i < exts.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(exts[i]);
        }
        return sb.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            if (NbBundle.getMessage(PropertyPanel.class, (String)"CTL_Different_Values").equals(text)) {
                this.setValue(new String[]{text});
            } else {
                StringTokenizer st = new StringTokenizer(text, ",. \n\t");
                this.setAs(st);
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = MessageFormat.format(NbBundle.getMessage(ExtensionListEditor.class, (String)"FMT_EXC_GENERIC_BAD_VALUE"), text);
            }
            ErrorManager.getDefault().annotate((Throwable)iae, 256, iae.getMessage(), msg, (Throwable)e, new Date());
            throw iae;
        }
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return new ExtensionListCustomEditor(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String[] getStringArray() {
        if (this.value == null) {
            return new String[0];
        }
        ArrayList l = new ArrayList();
        Enumeration e = this.value.extensions();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        e = this.value.mimeTypes();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        Collections.sort(l);
        return l.toArray(new String[l.size()]);
    }

    public void setStringArray(String[] nue) {
        this.setAs(Enumerations.array((Object[])nue));
    }

    private void setAs(Enumeration en) {
        ExtensionList list = new ExtensionList();
        while (en.hasMoreElements()) {
            String tok = (String)en.nextElement();
            if (tok.indexOf(47) >= 0) {
                list.addMimeType(tok);
                continue;
            }
            list.addExtension(tok);
        }
        this.value = list;
        this.support.firePropertyChange(null, null, null);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        if (desc instanceof Node.Property) {
            Node.Property prop = (Node.Property)desc;
            this.editable = prop.canWrite();
        }
    }
}

